/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;

@Named(value="requireSnapshotVersion")
public final class RequireSnapshotVersion
extends AbstractStandardEnforcerRule {
    private boolean failWhenParentIsRelease = true;
    private final MavenProject project;

    @Inject
    public RequireSnapshotVersion(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws EnforcerRuleException {
        Artifact parentArtifact;
        Artifact artifact = this.project.getArtifact();
        if (!artifact.isSnapshot()) {
            String message = this.getMessage();
            StringBuilder sb = new StringBuilder();
            if (message != null) {
                sb.append(message).append(System.lineSeparator());
            }
            sb.append("This project cannot be a release:").append(artifact.getId());
            throw new EnforcerRuleException(sb.toString());
        }
        if (this.failWhenParentIsRelease && this.project.hasParent() && (parentArtifact = (Artifact)Optional.ofNullable(this.project.getParent()).map(MavenProject::getArtifact).orElse(null)) != null && !parentArtifact.isSnapshot()) {
            throw new EnforcerRuleException("Parent cannot be a release: " + parentArtifact.getId());
        }
    }

    public void setFailWhenParentIsRelease(boolean failWhenParentIsRelease) {
        this.failWhenParentIsRelease = failWhenParentIsRelease;
    }

    public String toString() {
        return String.format("RequireSnapshotVersion[message=%s, failWhenParentIsRelease=%b]", this.getMessage(), this.failWhenParentIsRelease);
    }
}

