/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Provides;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.api.services.ToolchainManager;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.javac.JavacCompiler;
import org.codehaus.plexus.compiler.javac.JavaxToolsCompiler;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;

@Named
class Providers {
    Providers() {
    }

    @Provides
    static ToolchainManager toolchainManager(Session session) {
        return (ToolchainManager)session.getService(ToolchainManager.class);
    }

    @Provides
    static ArtifactManager artifactManager(Session session) {
        return (ArtifactManager)session.getService(ArtifactManager.class);
    }

    @Provides
    static ProjectManager projectManager(Session session) {
        return (ProjectManager)session.getService(ProjectManager.class);
    }

    @Provides
    static MessageBuilderFactory messageBuilderFactory(Session session) {
        return (MessageBuilderFactory)session.getService(MessageBuilderFactory.class);
    }

    @Provides
    static CompilerManager compilerManager(Map<String, Compiler> compilers) {
        return compilerId -> {
            Compiler compiler = (Compiler)compilers.get(compilerId);
            if (compiler == null) {
                throw new NoSuchCompilerException(compilerId);
            }
            return compiler;
        };
    }

    @Provides
    @Named(value="javac")
    static Compiler javacCompiler() throws Exception {
        JavacCompiler compiler = new JavacCompiler();
        Field ipc = JavacCompiler.class.getDeclaredField("inProcessCompiler");
        ipc.setAccessible(true);
        ipc.set(compiler, new JavaxToolsCompiler());
        return compiler;
    }
}

