/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.dependency.AbstractDependencyMojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="list-repositories", threadSafe=true)
public class ListRepositoriesMojo
extends AbstractDependencyMojo {
    private final RepositorySystem repositorySystem;

    @Inject
    public ListRepositoriesMojo(MavenSession session, BuildContext buildContext, MavenProject project, RepositorySystem repositorySystem) {
        super(session, buildContext, project);
        this.repositorySystem = repositorySystem;
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        CollectRequest request = new CollectRequest();
        request.setRepositories(this.getProject().getRemoteProjectRepositories());
        request.setRootArtifact(RepositoryUtils.toArtifact((Artifact)this.getProject().getArtifact()));
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
        request.setDependencies(this.getProject().getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList()));
        request.setManagedDependencies(Optional.ofNullable(this.getProject().getDependencyManagement()).map(DependencyManagement::getDependencies).orElseGet(Collections::emptyList).stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList()));
        try {
            CollectResult collectResult = this.repositorySystem.collectDependencies(this.session.getRepositorySession(), request);
            final HashSet repositories = new HashSet();
            collectResult.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){
                final /* synthetic */ ListRepositoriesMojo this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean visitEnter(DependencyNode node) {
                    repositories.addAll(node.getRepositories());
                    this.this$0.debugLogNodeRepo(node);
                    return true;
                }

                public boolean visitLeave(DependencyNode node) {
                    return true;
                }
            }));
            if (repositories.isEmpty()) {
                this.getLog().info((CharSequence)("No remote repository is used by this build." + System.lineSeparator()));
                return;
            }
            StringBuilder message = new StringBuilder();
            Map<Boolean, List<RemoteRepository>> repoGroupByMirrors = repositories.stream().collect(Collectors.groupingBy(repo -> repo.getMirroredRepositories().isEmpty()));
            this.prepareRemoteRepositoriesList(message, repoGroupByMirrors.getOrDefault(Boolean.TRUE, Collections.emptyList()));
            this.prepareRemoteMirrorRepositoriesList(message, repoGroupByMirrors.getOrDefault(Boolean.FALSE, Collections.emptyList()));
            this.getLog().info((CharSequence)message);
        }
        catch (DependencyCollectionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void debugLogNodeRepo(DependencyNode node) {
        if (!this.getLog().isDebugEnabled()) {
            return;
        }
        this.getLog().debug((CharSequence)("Node: " + node + " resolved from:"));
        node.getRepositories().forEach(repo -> {
            if (repo.getMirroredRepositories().isEmpty()) {
                this.getLog().debug((CharSequence)(" - " + repo));
            } else {
                this.getLog().debug((CharSequence)(" - " + repo + " as mirror for:"));
                repo.getMirroredRepositories().forEach(mrepo -> this.getLog().debug((CharSequence)("    - " + mrepo)));
            }
        });
    }

    private void prepareRemoteMirrorRepositoriesList(StringBuilder message, Collection<RemoteRepository> remoteProjectRepositories) {
        HashMap<RemoteRepository, RemoteRepository> mirrorMap = new HashMap<RemoteRepository, RemoteRepository>();
        remoteProjectRepositories.forEach(repo -> repo.getMirroredRepositories().forEach(mrepo -> mirrorMap.put((RemoteRepository)mrepo, (RemoteRepository)repo)));
        mirrorMap.forEach((repo, mirror) -> message.append(" * ").append(repo).append(" mirrored by ").append(mirror).append(System.lineSeparator()));
    }

    private void prepareRemoteRepositoriesList(StringBuilder message, Collection<RemoteRepository> remoteProjectRepositories) {
        message.append("Project remote repositories used by this build:").append(System.lineSeparator());
        remoteProjectRepositories.forEach(repo -> message.append(" * ").append(repo).append(System.lineSeparator()));
    }
}

