/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils.filters;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugins.dependency.utils.markers.MarkerHandler;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;

public class MarkerFileFilter
extends AbstractArtifactsFilter
implements ArtifactItemFilter {
    private boolean overWriteReleases;
    private boolean overWriteSnapshots;
    private boolean overWriteIfNewer;
    protected final MarkerHandler handler;

    public MarkerFileFilter(boolean overWriteReleases, boolean overWriteSnapshots, boolean overWriteIfNewer, MarkerHandler handler) {
        this.overWriteReleases = overWriteReleases;
        this.overWriteSnapshots = overWriteSnapshots;
        this.overWriteIfNewer = overWriteIfNewer;
        this.handler = handler;
    }

    public Set<Artifact> filter(Set<Artifact> artifacts) throws ArtifactFilterException {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!this.isArtifactIncluded(new ArtifactItem(artifact))) continue;
            result.add(artifact);
        }
        return result;
    }

    @Override
    public boolean isArtifactIncluded(ArtifactItem item) throws ArtifactFilterException {
        Artifact artifact = item.getArtifact();
        boolean overWrite = artifact.isSnapshot() && this.overWriteSnapshots || !artifact.isSnapshot() && this.overWriteReleases;
        this.handler.setArtifact(artifact);
        try {
            return overWrite || !this.handler.isMarkerSet() || this.overWriteIfNewer && this.handler.isMarkerOlder(artifact);
        }
        catch (MojoExecutionException e) {
            throw new ArtifactFilterException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean overWriteReleases) {
        this.overWriteReleases = overWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean overWriteSnapshots) {
        this.overWriteSnapshots = overWriteSnapshots;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean overWriteIfNewer) {
        this.overWriteIfNewer = overWriteIfNewer;
    }
}

