/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MavenExpression {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(.+?)}");

    private MavenExpression() {
    }

    public static String evaluate(String expression, Map<?, ?> properties) {
        StringBuilder result = new StringBuilder(expression);
        Matcher matcher = EXPRESSION_PATTERN.matcher(result);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            Object propertyValue = properties.get(propertyName);
            result.replace(matcher.start(), matcher.end(), String.valueOf(propertyValue));
            matcher.reset();
        }
        return result.toString();
    }

    public static String extractPropertyFromExpression(String expression) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }
}

