/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.junitplatform.CancellationTokenAdapter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;

final class LauncherAdapter {
    static final Class<?> LAUNCHER_EXECUTION_REQUEST_CLASS = LauncherAdapter.loadLauncherExecutionRequestClass();
    static final Method EXECUTE_METHOD_WITH_LAUNCHER_EXECUTION_REQUEST_PARAMETER = LauncherAdapter.findExecuteMethodWithLauncherExecutionRequestParameter();
    private final Launcher delegate;
    private final CancellationTokenAdapter cancellationToken;

    LauncherAdapter(Launcher delegate, CancellationTokenAdapter cancellationToken) {
        this.delegate = delegate;
        this.cancellationToken = cancellationToken;
    }

    TestPlan discover(LauncherDiscoveryRequest discoveryRequest) {
        return this.delegate.discover(discoveryRequest);
    }

    void execute(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        if (this.cancellationToken == null) {
            this.executeWithoutCancellationToken(discoveryRequest, listeners);
        } else {
            this.executeWithCancellationToken(discoveryRequest, listeners);
        }
    }

    void executeWithoutCancellationToken(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        this.delegate.execute(discoveryRequest, listeners);
    }

    private void executeWithCancellationToken(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        Method executeMethod = Objects.requireNonNull(EXECUTE_METHOD_WITH_LAUNCHER_EXECUTION_REQUEST_PARAMETER);
        Object executionRequest = this.createExecutionRequest(discoveryRequest, listeners);
        ReflectionUtils.invokeMethodWithArray((Object)this.delegate, (Method)executeMethod, (Object[])new Object[]{executionRequest});
    }

    private static Method findExecuteMethodWithLauncherExecutionRequestParameter() {
        if (LAUNCHER_EXECUTION_REQUEST_CLASS == null) {
            return null;
        }
        return ReflectionUtils.getMethod(Launcher.class, (String)"execute", (Class[])new Class[]{LAUNCHER_EXECUTION_REQUEST_CLASS});
    }

    private static Class<?> loadLauncherExecutionRequestClass() {
        return ReflectionUtils.tryLoadClass((ClassLoader)Launcher.class.getClassLoader(), (String)"org.junit.platform.launcher.LauncherExecutionRequest");
    }

    private Object createExecutionRequest(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener[] listeners) {
        Object builder = LauncherAdapter.createLauncherExecutionRequestBuilder(discoveryRequest);
        ReflectionUtils.invokeSetter((Object)builder, (String)"listeners", TestExecutionListener[].class, (Object)listeners);
        ReflectionUtils.invokeSetter((Object)builder, (String)"cancellationToken", CancellationTokenAdapter.CANCELLATION_TOKEN_CLASS, (Object)this.cancellationToken.getDelegate());
        return ReflectionUtils.invokeGetter((Object)builder, (String)"build");
    }

    private static Object createLauncherExecutionRequestBuilder(LauncherDiscoveryRequest discoveryRequest) {
        ClassLoader classLoader = discoveryRequest.getClass().getClassLoader();
        Class builderClass = ReflectionUtils.loadClass((ClassLoader)classLoader, (String)"org.junit.platform.launcher.core.LauncherExecutionRequestBuilder");
        Class[] parameterTypes = new Class[]{LauncherDiscoveryRequest.class};
        Object[] parameters = new Object[]{discoveryRequest};
        return ReflectionUtils.invokeStaticMethod((Class)builderClass, (String)"request", (Class[])parameterTypes, (Object[])parameters);
    }
}

