/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.ManifestSection;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.PomPropertiesUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.StringUtils;

public class MavenArchiver {
    private JarArchiver archiver;
    private File archiveFile;

    public Manifest getManifest(MavenProject project, MavenArchiveConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        boolean hasManifestEntries = !config.isManifestEntriesEmpty();
        Map entries = hasManifestEntries ? config.getManifestEntries() : Collections.EMPTY_MAP;
        Manifest manifest = this.getManifest(project, config.getManifest(), entries);
        if (hasManifestEntries) {
            Set keys = entries.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)entries.get(key);
                Manifest.Attribute attr = manifest.getMainSection().getAttribute(key);
                if (key.equals("Class-Path") && attr != null) {
                    attr.setValue(value + " " + attr.getValue());
                    continue;
                }
                this.addManifestAttribute(manifest, key, value);
            }
        }
        return manifest;
    }

    public Manifest getManifest(MavenProject project, ManifestConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        return this.getManifest(project, config, Collections.EMPTY_MAP);
    }

    private void addManifestAttribute(Manifest manifest, Map map, String key, String value) throws ManifestException {
        if (map.containsKey(key)) {
            return;
        }
        this.addManifestAttribute(manifest, key, value);
    }

    private void addManifestAttribute(Manifest manifest, String key, String value) throws ManifestException {
        if (!StringUtils.isEmpty((String)value)) {
            Manifest.Attribute attr = new Manifest.Attribute(key, value);
            manifest.addConfiguredAttribute(attr);
        } else {
            Manifest.Attribute attr = new Manifest.Attribute(key, "");
            manifest.addConfiguredAttribute(attr);
        }
    }

    protected Manifest getManifest(MavenProject project, ManifestConfiguration config, Map entries) throws ManifestException, DependencyResolutionRequiredException {
        String mainClass;
        Iterator iter;
        Manifest m = new Manifest();
        this.addManifestAttribute(m, entries, "Created-By", "Apache Maven");
        this.addCustomEntries(m, entries, config);
        if (config.isAddClasspath()) {
            StringBuffer classpath = new StringBuffer();
            List artifacts = project.getRuntimeClasspathElements();
            String classpathPrefix = config.getClasspathPrefix();
            iter = artifacts.iterator();
            while (iter.hasNext()) {
                File f = new File((String)iter.next());
                if (!f.isFile()) continue;
                if (classpath.length() > 0) {
                    classpath.append(" ");
                }
                classpath.append(classpathPrefix);
                if (!config.isClasspathMavenRepositoryLayout()) {
                    classpath.append(f.getName());
                    continue;
                }
                Artifact artifact = this.findArtifactWithFile(project.getArtifacts(), f);
                StringBuffer classpathElement = new StringBuffer();
                if (!StringUtils.isEmpty((String)artifact.getGroupId())) {
                    classpathElement.append(artifact.getGroupId().replace('.', '/')).append('/');
                }
                classpathElement.append(artifact.getArtifactId()).append('/');
                classpathElement.append(artifact.getVersion()).append('/');
                classpathElement.append(f.getName());
                classpath.append(classpathElement);
            }
            if (classpath.length() > 0) {
                this.addManifestAttribute(m, "Class-Path", classpath.toString());
            }
        }
        if (config.isAddDefaultSpecificationEntries()) {
            this.addManifestAttribute(m, entries, "Specification-Title", project.getName());
            this.addManifestAttribute(m, entries, "Specification-Version", project.getVersion());
            if (project.getOrganization() != null) {
                this.addManifestAttribute(m, entries, "Specification-Vendor", project.getOrganization().getName());
            }
        }
        if (config.isAddDefaultImplementationEntries()) {
            this.addManifestAttribute(m, entries, "Implementation-Title", project.getName());
            this.addManifestAttribute(m, entries, "Implementation-Version", project.getVersion());
            this.addManifestAttribute(m, entries, "Implementation-Vendor-Id", project.getGroupId());
            if (project.getOrganization() != null) {
                this.addManifestAttribute(m, entries, "Implementation-Vendor", project.getOrganization().getName());
            }
        }
        if ((mainClass = config.getMainClass()) != null && !"".equals(mainClass)) {
            this.addManifestAttribute(m, entries, "Main-Class", mainClass);
        }
        if (config.isAddExtensions()) {
            Artifact artifact;
            StringBuffer extensionsList = new StringBuffer();
            Set artifacts = project.getArtifacts();
            iter = artifacts.iterator();
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                if ("test".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
                if (extensionsList.length() > 0) {
                    extensionsList.append(" ");
                }
                extensionsList.append(artifact.getArtifactId());
            }
            if (extensionsList.length() > 0) {
                this.addManifestAttribute(m, entries, "Extension-List", extensionsList.toString());
            }
            iter = artifacts.iterator();
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                if (!"jar".equals(artifact.getType())) continue;
                String ename = artifact.getArtifactId() + "-Extension-Name";
                this.addManifestAttribute(m, entries, ename, artifact.getArtifactId());
                String iname = artifact.getArtifactId() + "-Implementation-Version";
                this.addManifestAttribute(m, entries, iname, artifact.getVersion());
                if (artifact.getRepository() == null) continue;
                iname = artifact.getArtifactId() + "-Implementation-URL";
                String url = artifact.getRepository().getUrl() + "/" + artifact.toString();
                this.addManifestAttribute(m, entries, iname, url);
            }
        }
        return m;
    }

    private void addCustomEntries(Manifest m, Map entries, ManifestConfiguration config) throws ManifestException {
        this.addManifestAttribute(m, entries, "Built-By", System.getProperty("user.name"));
        this.addManifestAttribute(m, entries, "Build-Jdk", System.getProperty("java.version"));
        if (config.getPackageName() != null) {
            this.addManifestAttribute(m, entries, "Package", config.getPackageName());
        }
    }

    public JarArchiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(JarArchiver archiver) {
        this.archiver = archiver;
    }

    public void setOutputFile(File outputFile) {
        this.archiveFile = outputFile;
    }

    public void createArchive(MavenProject project, MavenArchiveConfiguration archiveConfiguration) throws ArchiverException, ManifestException, IOException, DependencyResolutionRequiredException {
        Iterator iter;
        File manifestFile;
        MavenProject workingProject = new MavenProject(project);
        boolean forced = archiveConfiguration.isForced();
        if (archiveConfiguration.isAddMavenDescriptor()) {
            if (workingProject.getArtifact().isSnapshot()) {
                workingProject.setVersion(workingProject.getArtifact().getVersion());
            }
            String groupId = workingProject.getGroupId();
            String artifactId = workingProject.getArtifactId();
            this.archiver.addFile(project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            File pomPropertiesFile = archiveConfiguration.getPomPropertiesFile();
            if (pomPropertiesFile == null) {
                File dir = new File(workingProject.getBuild().getDirectory(), "maven-archiver");
                pomPropertiesFile = new File(dir, "pom.properties");
            }
            new PomPropertiesUtil().createPomProperties(workingProject, (Archiver)this.archiver, pomPropertiesFile, forced);
        }
        if ((manifestFile = archiveConfiguration.getManifestFile()) != null) {
            this.archiver.setManifest(manifestFile);
        }
        Manifest manifest = this.getManifest(workingProject, archiveConfiguration);
        if (!archiveConfiguration.isManifestSectionsEmpty()) {
            List sections = archiveConfiguration.getManifestSections();
            iter = sections.iterator();
            while (iter.hasNext()) {
                ManifestSection section = (ManifestSection)iter.next();
                Manifest.Section theSection = new Manifest.Section();
                theSection.setName(section.getName());
                if (!section.isManifestEntriesEmpty()) {
                    Map entries = section.getManifestEntries();
                    Set keys = entries.keySet();
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        String value = (String)entries.get(key);
                        Manifest.Attribute attr = new Manifest.Attribute(key, value);
                        theSection.addConfiguredAttribute(attr);
                    }
                }
                manifest.addConfiguredSection(theSection);
            }
        }
        this.archiver.addConfiguredManifest(manifest);
        this.archiver.setCompress(archiveConfiguration.isCompress());
        this.archiver.setIndex(archiveConfiguration.isIndex());
        this.archiver.setDestFile(this.archiveFile);
        if (archiveConfiguration.getManifest().isAddClasspath()) {
            List artifacts = project.getRuntimeClasspathElements();
            iter = artifacts.iterator();
            while (iter.hasNext()) {
                File f = new File((String)iter.next());
                this.archiver.addConfiguredIndexJars(f);
            }
        }
        this.archiver.setForced(forced);
        if (archiveConfiguration.isForced() || this.archiver.isSupportingForced()) {
            // empty if block
        }
        this.archiver.createArchive();
    }

    private Artifact findArtifactWithFile(Set artifacts, File file) {
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (artifact.getFile() == null || !artifact.getFile().equals(file)) continue;
            return artifact;
        }
        return null;
    }
}

