/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.maven.BuildFailureException;
import org.apache.maven.Maven;
import org.apache.maven.SettingsConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.Profile;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reactor.MavenExecutionException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.usability.SystemWarnings;
import org.apache.maven.usability.diagnostics.ErrorDiagnostics;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultMaven
extends AbstractLogEnabled
implements Maven,
Contextualizable {
    protected MavenProjectBuilder projectBuilder;
    protected LifecycleExecutor lifecycleExecutor;
    protected PlexusContainer container;
    protected ErrorDiagnostics errorDiagnostics;
    protected RuntimeInformation runtimeInformation;
    private static final long MB = 0x100000L;
    private static final int MS_PER_SEC = 1000;
    private static final int SEC_PER_MIN = 60;

    public void execute(MavenExecutionRequest request) throws MavenExecutionException {
        ReactorManager rm;
        EventDispatcher dispatcher = request.getEventDispatcher();
        String event = "reactor-execute";
        dispatcher.dispatchStart(event, request.getBaseDirectory());
        try {
            rm = this.doExecute(request, dispatcher);
        }
        catch (LifecycleExecutionException e) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), (Throwable)e);
            this.logError(e, request.isShowErrors());
            this.stats(request.getStartTime());
            this.line();
            throw new MavenExecutionException(e.getMessage(), e);
        }
        catch (BuildFailureException e) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), (Throwable)e);
            this.logFailure(e, request.isShowErrors());
            this.stats(request.getStartTime());
            this.line();
            throw new MavenExecutionException(e.getMessage(), e);
        }
        catch (Throwable t) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), t);
            this.logFatal(t);
            this.stats(request.getStartTime());
            this.line();
            throw new MavenExecutionException("Error executing project within the reactor", t);
        }
        this.logReactorSummary(rm);
        if (rm.hasBuildFailures()) {
            this.logErrors(rm, request.isShowErrors());
            if (!"fail-never".equals(rm.getFailureBehavior())) {
                dispatcher.dispatchError(event, request.getBaseDirectory(), null);
                this.getLogger().info("BUILD ERRORS");
                this.line();
                this.stats(request.getStartTime());
                this.line();
                throw new MavenExecutionException("Some builds failed");
            }
            this.getLogger().info(" + Ignoring failures");
        }
        this.logSuccess(rm);
        this.stats(request.getStartTime());
        this.line();
        dispatcher.dispatchEnd(event, request.getBaseDirectory());
    }

    private void logErrors(ReactorManager rm, boolean showErrors) {
        Iterator it = rm.getSortedProjects().iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            if (!rm.hasBuildFailure(project)) continue;
            BuildFailure buildFailure = rm.getBuildFailure(project);
            this.getLogger().info("Error for project: " + project.getName() + " (during " + buildFailure.getTask() + ")");
            this.line();
            this.logDiagnostics(buildFailure.getCause());
            this.logTrace(buildFailure.getCause(), showErrors);
        }
        if (!showErrors) {
            this.getLogger().info("For more information, run Maven with the -e switch");
            this.line();
        }
    }

    private ReactorManager doExecute(MavenExecutionRequest request, EventDispatcher dispatcher) throws MavenExecutionException, BuildFailureException, LifecycleExecutionException {
        ReactorManager rm;
        if (request.getSettings().isOffline()) {
            this.getLogger().info(SystemWarnings.getOfflineWarning());
            WagonManager wagonManager = null;
            try {
                wagonManager = (WagonManager)this.container.lookup(WagonManager.ROLE);
                wagonManager.setOnline(false);
            }
            catch (ComponentLookupException e) {
                throw new MavenExecutionException("Cannot retrieve WagonManager in order to set offline mode.", e);
            }
            finally {
                try {
                    this.container.release((Object)wagonManager);
                }
                catch (ComponentLifecycleException e) {
                    this.getLogger().warn("Cannot release WagonManager.", (Throwable)e);
                }
            }
        }
        try {
            this.resolveParameters(request.getSettings());
        }
        catch (ComponentLookupException e) {
            throw new MavenExecutionException("Unable to configure Maven for execution", e);
        }
        catch (ComponentLifecycleException e) {
            throw new MavenExecutionException("Unable to configure Maven for execution", e);
        }
        catch (SettingsConfigurationException e) {
            throw new MavenExecutionException("Unable to configure Maven for execution", e);
        }
        ProfileManager globalProfileManager = request.getGlobalProfileManager();
        globalProfileManager.loadSettingsProfiles(request.getSettings());
        this.getLogger().info("Scanning for projects...");
        boolean foundProjects = true;
        List projects = this.getProjects(request);
        if (projects.isEmpty()) {
            projects.add(this.getSuperProject(request));
            foundProjects = false;
        }
        try {
            rm = new ReactorManager(projects);
            String requestFailureBehavior = request.getFailureBehavior();
            if (requestFailureBehavior != null) {
                rm.setFailureBehavior(requestFailureBehavior);
            }
        }
        catch (CycleDetectedException e) {
            throw new BuildFailureException("The projects in the reactor contain a cyclic reference: " + e.getMessage(), e);
        }
        catch (DuplicateProjectException e) {
            throw new BuildFailureException(e.getMessage(), e);
        }
        this.validateActivatedProfiles(globalProfileManager, projects);
        if (rm.hasMultipleProjects()) {
            this.getLogger().info("Reactor build order: ");
            Iterator i = rm.getSortedProjects().iterator();
            while (i.hasNext()) {
                MavenProject project = (MavenProject)i.next();
                this.getLogger().info("  " + project.getName());
            }
        }
        MavenSession session = this.createSession(request, rm);
        session.setUsingPOMsFromFilesystem(foundProjects);
        this.lifecycleExecutor.execute(session, rm, dispatcher);
        return rm;
    }

    private void validateActivatedProfiles(ProfileManager globalProfileManager, List projects) {
        if (globalProfileManager != null) {
            HashSet<String> activeProfileIds = new HashSet<String>();
            Iterator i = projects.iterator();
            while (i.hasNext()) {
                MavenProject project = (MavenProject)i.next();
                do {
                    Iterator j = project.getActiveProfiles().iterator();
                    while (j.hasNext()) {
                        activeProfileIds.add(((Profile)j.next()).getId());
                    }
                } while ((project = project.getParent()) != null);
            }
            i = globalProfileManager.getExplicitlyActivatedIds().iterator();
            while (i.hasNext()) {
                String explicitProfileId = (String)i.next();
                if (activeProfileIds.contains(explicitProfileId)) continue;
                this.getLogger().warn("\n\tProfile with id: '" + explicitProfileId + "' has not been activated.\n");
            }
        }
    }

    private MavenProject getSuperProject(MavenExecutionRequest request) throws MavenExecutionException {
        MavenProject superProject;
        try {
            superProject = this.projectBuilder.buildStandaloneSuperProject(request.getLocalRepository(), request.getGlobalProfileManager());
        }
        catch (ProjectBuildingException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
        return superProject;
    }

    private List getProjects(MavenExecutionRequest request) throws MavenExecutionException, BuildFailureException {
        List projects;
        try {
            List files = this.getProjectFiles(request);
            projects = this.collectProjects(files, request, !request.isReactorActive());
        }
        catch (IOException e) {
            throw new MavenExecutionException("Error processing projects for the reactor: " + e.getMessage(), e);
        }
        catch (ArtifactResolutionException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
        catch (ProjectBuildingException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
        catch (ProfileActivationException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
        return projects;
    }

    private void logReactorSummaryLine(String name, String status) {
        this.logReactorSummaryLine(name, status, -1L);
    }

    private void logReactorSummaryLine(String name, String status, long time) {
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append(name);
        int dotCount = 54;
        dotCount -= name.length();
        messageBuffer.append(" ");
        for (int i = 0; i < dotCount; ++i) {
            messageBuffer.append('.');
        }
        messageBuffer.append(" ");
        messageBuffer.append(status);
        if (time >= 0L) {
            messageBuffer.append(" [");
            messageBuffer.append(DefaultMaven.getFormattedTime(time));
            messageBuffer.append("]");
        }
        this.getLogger().info(messageBuffer.toString());
    }

    private static String getFormattedTime(long time) {
        String pattern = "s.SSS's'";
        if (time / 60000L > 0L) {
            pattern = "m:s" + pattern;
            if (time / 3600000L > 0L) {
                pattern = "H:m" + pattern;
            }
        }
        SimpleDateFormat fmt = new SimpleDateFormat(pattern);
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(new Date(time));
    }

    private List collectProjects(List files, MavenExecutionRequest request, boolean isRoot) throws ArtifactResolutionException, ProjectBuildingException, ProfileActivationException, MavenExecutionException, BuildFailureException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>(files.size());
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            boolean usingReleasePom = false;
            if ("release-pom.xml".equals(file.getName())) {
                this.getLogger().info("NOTE: Using release-pom: " + file + " in reactor build.");
                usingReleasePom = true;
            }
            MavenProject project = this.getProject(file, request);
            if (isRoot) {
                project.setExecutionRoot(true);
            }
            if (project.getPrerequisites() != null && project.getPrerequisites().getMaven() != null) {
                DefaultArtifactVersion version = new DefaultArtifactVersion(project.getPrerequisites().getMaven());
                if (this.runtimeInformation.getApplicationVersion().compareTo((Object)version) < 0) {
                    throw new BuildFailureException("Unable to build project '" + project.getFile() + "; it requires Maven version " + version.toString());
                }
            }
            if (project.getModules() != null && !project.getModules().isEmpty() && request.isRecursive()) {
                project.setPackaging("pom");
                File basedir = file.getParentFile();
                ArrayList<File> moduleFiles = new ArrayList<File>(project.getModules().size());
                Iterator i = project.getModules().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    if (StringUtils.isEmpty((String)StringUtils.trim((String)name))) {
                        this.getLogger().warn("Empty module detected. Please check you don't have any empty module definitions in your POM.");
                        continue;
                    }
                    File moduleFile = new File(basedir, name);
                    if (moduleFile.exists() && moduleFile.isDirectory()) {
                        moduleFile = usingReleasePom ? new File(basedir, name + "/" + "release-pom.xml") : new File(basedir, name + "/" + "pom.xml");
                    }
                    if (Os.isFamily((String)"windows")) {
                        try {
                            moduleFile = moduleFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            throw new MavenExecutionException("Unable to canonicalize file name " + moduleFile, e);
                        }
                    } else {
                        moduleFile = new File(moduleFile.toURI().normalize());
                    }
                    moduleFiles.add(moduleFile);
                }
                List collectedProjects = this.collectProjects(moduleFiles, request, false);
                projects.addAll(collectedProjects);
                project.setCollectedProjects(collectedProjects);
            }
            projects.add(project);
        }
        return projects;
    }

    public MavenProject getProject(File pom, ArtifactRepository localRepository, Settings settings, Properties userProperties, ProfileManager globalProfileManager) throws ProjectBuildingException, ArtifactResolutionException, ProfileActivationException {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest(localRepository, settings, (EventDispatcher)new DefaultEventDispatcher(), Collections.EMPTY_LIST, pom.getParentFile().getAbsolutePath(), globalProfileManager, globalProfileManager.getRequestProperties(), new Properties(), false);
        return this.getProject(pom, request);
    }

    public MavenProject getProject(File pom, MavenExecutionRequest request) throws ProjectBuildingException, ArtifactResolutionException, ProfileActivationException {
        if (pom.exists() && pom.length() == 0L) {
            throw new ProjectBuildingException("unknown", "The file " + pom.getAbsolutePath() + " you specified has zero length.");
        }
        DefaultProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration();
        config.setLocalRepository(request.getLocalRepository()).setGlobalProfileManager(request.getGlobalProfileManager()).setUserProperties(request.getUserProperties());
        return this.projectBuilder.build(pom, (ProjectBuilderConfiguration)config);
    }

    protected MavenSession createSession(MavenExecutionRequest request, ReactorManager rpm) {
        return new MavenSession(this.container, request.getSettings(), request.getLocalRepository(), request.getEventDispatcher(), rpm, request.getGoals(), request.getBaseDirectory(), request.getExecutionProperties(), request.getStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveParameters(Settings settings) throws ComponentLookupException, ComponentLifecycleException, SettingsConfigurationException {
        WagonManager wagonManager = (WagonManager)this.container.lookup(WagonManager.ROLE);
        try {
            Proxy proxy = settings.getActiveProxy();
            if (proxy != null) {
                if (proxy.getHost() == null) {
                    throw new SettingsConfigurationException("Proxy in settings.xml has no host");
                }
                wagonManager.addProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword(), proxy.getNonProxyHosts());
            }
            Iterator i = settings.getServers().iterator();
            while (i.hasNext()) {
                Server server = (Server)i.next();
                wagonManager.addAuthenticationInfo(server.getId(), server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
                wagonManager.addPermissionInfo(server.getId(), server.getFilePermissions(), server.getDirectoryPermissions());
                if (server.getConfiguration() == null) continue;
                wagonManager.addConfiguration(server.getId(), (Xpp3Dom)server.getConfiguration());
            }
            RepositoryPermissions defaultPermissions = new RepositoryPermissions();
            defaultPermissions.setDirectoryMode("775");
            defaultPermissions.setFileMode("664");
            wagonManager.setDefaultRepositoryPermissions(defaultPermissions);
            Iterator i2 = settings.getMirrors().iterator();
            while (i2.hasNext()) {
                Mirror mirror = (Mirror)i2.next();
                wagonManager.addMirror(mirror.getId(), mirror.getMirrorOf(), mirror.getUrl());
            }
        }
        finally {
            this.container.release((Object)wagonManager);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected void logFatal(Throwable error) {
        this.line();
        this.getLogger().error("FATAL ERROR");
        this.line();
        this.logDiagnostics(error);
        this.logTrace(error, true);
    }

    protected void logError(Exception e, boolean showErrors) {
        this.line();
        this.getLogger().error("BUILD ERROR");
        this.line();
        this.logDiagnostics(e);
        this.logTrace(e, showErrors);
        if (!showErrors) {
            this.getLogger().info("For more information, run Maven with the -e switch");
            this.line();
        }
    }

    protected void logFailure(BuildFailureException e, boolean showErrors) {
        this.line();
        this.getLogger().error("BUILD FAILURE");
        this.line();
        this.logDiagnostics(e);
        this.logTrace(e, showErrors);
        if (!showErrors) {
            this.getLogger().info("For more information, run Maven with the -e switch");
            this.line();
        }
    }

    private void logTrace(Throwable t, boolean showErrors) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trace", t);
            this.line();
        } else if (showErrors) {
            this.getLogger().info("Trace", t);
            this.line();
        }
    }

    private void logDiagnostics(Throwable t) {
        String message = null;
        if (this.errorDiagnostics != null) {
            message = this.errorDiagnostics.diagnose(t);
        }
        if (message == null) {
            message = t.getMessage();
        }
        this.getLogger().info(message);
        this.line();
    }

    protected void logSuccess(ReactorManager rm) {
        this.line();
        this.getLogger().info("BUILD SUCCESSFUL");
        this.line();
    }

    private void logReactorSummary(ReactorManager rm) {
        if (rm.hasMultipleProjects() && rm.executedMultipleProjects()) {
            this.getLogger().info("");
            this.getLogger().info("");
            this.line();
            this.getLogger().info("Reactor Summary:");
            this.line();
            Iterator it = rm.getSortedProjects().iterator();
            while (it.hasNext()) {
                MavenProject project = (MavenProject)it.next();
                if (rm.hasBuildFailure(project)) {
                    this.logReactorSummaryLine(project.getName(), "FAILED", rm.getBuildFailure(project).getTime());
                    continue;
                }
                if (rm.isBlackListed(project)) {
                    this.logReactorSummaryLine(project.getName(), "SKIPPED (dependency build failed or was skipped)");
                    continue;
                }
                if (rm.hasBuildSuccess(project)) {
                    this.logReactorSummaryLine(project.getName(), "SUCCESS", rm.getBuildSuccess(project).getTime());
                    continue;
                }
                this.logReactorSummaryLine(project.getName(), "NOT BUILT");
            }
            this.line();
        }
    }

    protected void stats(Date start) {
        Date finish = new Date();
        long time = finish.getTime() - start.getTime();
        this.getLogger().info("Total time: " + DefaultMaven.formatTime(time));
        this.getLogger().info("Finished at: " + finish);
        System.gc();
        Runtime r = Runtime.getRuntime();
        this.getLogger().info("Final Memory: " + (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M");
    }

    protected void line() {
        this.getLogger().info("------------------------------------------------------------------------");
    }

    protected static String formatTime(long ms) {
        long secs = ms / 1000L;
        long min = secs / 60L;
        secs %= 60L;
        String msg = "";
        if (min > 1L) {
            msg = min + " minutes ";
        } else if (min == 1L) {
            msg = "1 minute ";
        }
        if (secs > 1L) {
            msg = msg + secs + " seconds";
        } else if (secs == 1L) {
            msg = msg + "1 second";
        } else if (min == 0L) {
            msg = msg + "< 1 second";
        }
        return msg;
    }

    private List getProjectFiles(MavenExecutionRequest request) throws IOException {
        List<File> files = Collections.EMPTY_LIST;
        File userDir = new File(System.getProperty("user.dir"));
        if (request.isReactorActive()) {
            String includes = System.getProperty("maven.reactor.includes", "**/pom.xml,**/release-pom.xml");
            String excludes = System.getProperty("maven.reactor.excludes", "pom.xml,release-pom.xml");
            files = FileUtils.getFiles((File)userDir, (String)includes, (String)excludes);
            this.filterOneProjectFilePerDirectory(files);
            Collections.sort(files);
        } else if (request.getPomFile() != null) {
            File projectFile = new File(request.getPomFile()).getAbsoluteFile();
            if (projectFile.exists()) {
                files = Collections.singletonList(projectFile);
            }
        } else {
            File projectFile = new File(userDir, "release-pom.xml");
            if (!projectFile.exists()) {
                projectFile = new File(userDir, "pom.xml");
            }
            if (projectFile.exists()) {
                files = Collections.singletonList(projectFile);
            }
        }
        return files;
    }

    private void filterOneProjectFilePerDirectory(List files) {
        File projectFile;
        ArrayList<File> releaseDirs = new ArrayList<File>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            projectFile = (File)it.next();
            if (!"release-pom.xml".equals(projectFile.getName())) continue;
            releaseDirs.add(projectFile.getParentFile());
        }
        it = files.iterator();
        while (it.hasNext()) {
            projectFile = (File)it.next();
            if ("release-pom.xml".equals(projectFile.getName()) || !releaseDirs.contains(projectFile.getParentFile())) continue;
            it.remove();
        }
    }
}

