/*
 * $Id$
 */

package org.apache.maven.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A download mirror for a given repository.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Mirror extends IdentifiableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The server ID of the repository being mirrored,
     * eg
     *             "central". This MUST NOT match the mirror id.
     *           
     */
    private String mirrorOf;

    /**
     * 
     *             The optional name that describes the mirror.
     *           
     */
    private String name;

    /**
     * The URL of the mirror repository.
     */
    private String url;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The server ID of the repository being mirrored,
     * eg
     *             "central". This MUST NOT match the mirror id.
     *           
     * 
     * @return String
     */
    public String getMirrorOf()
    {
        return this.mirrorOf;
    } //-- String getMirrorOf() 

    /**
     * Get 
     *             The optional name that describes the mirror.
     *           
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get the URL of the mirror repository.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Set 
     *             The server ID of the repository being mirrored,
     * eg
     *             "central". This MUST NOT match the mirror id.
     *           
     * 
     * @param mirrorOf
     */
    public void setMirrorOf( String mirrorOf )
    {
        this.mirrorOf = mirrorOf;
    } //-- void setMirrorOf( String ) 

    /**
     * Set 
     *             The optional name that describes the mirror.
     *           
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String ) 

    /**
     * Set the URL of the mirror repository.
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String ) 


            

    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        sb.append( "Mirror[" );
        sb.append( "id=" ).append( this.getId() );
        sb.append( ",mirrorOf=" ).append( mirrorOf );
        sb.append( ",url=" ).append( this.url );
        sb.append( ",name=" ).append( this.name );
        sb.append( "]" );
        return sb.toString();
    }
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
