/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.BuildFailureException;
import org.apache.maven.InvalidTaskException;
import org.apache.maven.Maven;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.DuplicateProjectException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.TaskValidationResult;
import org.apache.maven.monitor.event.DeprecationEventDispatcher;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.event.MavenEvents;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reactor.MavenExecutionException;
import org.apache.maven.reactor.MissingModuleException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;

@Component(role=Maven.class)
public class DefaultMaven
implements Maven,
LogEnabled {
    @Requirement
    protected MavenProjectBuilder projectBuilder;
    @Requirement
    protected LifecycleExecutor lifecycleExecutor;
    @Requirement
    protected PlexusContainer container;
    @Requirement
    protected RuntimeInformation runtimeInformation;
    private Logger logger;

    public ReactorManager createReactorManager(MavenExecutionRequest request, MavenExecutionResult result) {
        ReactorManager reactorManager;
        List projects;
        try {
            projects = this.getProjects(request);
            if (projects.isEmpty()) {
                projects.add(this.projectBuilder.buildStandaloneSuperProject(request.getProjectBuildingConfiguration()));
                request.setProjectPresent(false);
            }
        }
        catch (ProjectBuildingException e) {
            result.addException(e);
            return null;
        }
        catch (MavenExecutionException e) {
            result.addException(e);
            return null;
        }
        try {
            reactorManager = new ReactorManager(projects, request.getReactorFailureBehavior());
            result.setReactorManager(reactorManager);
        }
        catch (CycleDetectedException e) {
            String message = "The projects in the reactor contain a cyclic reference: " + e.getMessage();
            ProjectCycleException error = new ProjectCycleException(projects, message, e);
            result.addException(error);
            return null;
        }
        catch (DuplicateProjectException e) {
            result.addException(e);
            return null;
        }
        return reactorManager;
    }

    public MavenExecutionResult execute(MavenExecutionRequest request) {
        request.setStartTime(new Date());
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        ReactorManager reactorManager = this.createReactorManager(request, result);
        if (result.hasExceptions()) {
            return result;
        }
        DeprecationEventDispatcher dispatcher = new DeprecationEventDispatcher(MavenEvents.DEPRECATIONS, request.getEventMonitors());
        String event = "maven-execute";
        dispatcher.dispatchStart(event, request.getBaseDirectory());
        MavenSession session = this.createSession(request, reactorManager, dispatcher);
        if (request.getGoals() != null) {
            Iterator i = request.getGoals().iterator();
            while (i.hasNext()) {
                String goal = (String)i.next();
                if (goal == null) {
                    i.remove();
                    continue;
                }
                TaskValidationResult tvr = this.lifecycleExecutor.isTaskValid(goal, session, reactorManager.getTopLevelProject());
                if (tvr.isTaskValid()) continue;
                InvalidTaskException e = tvr.generateInvalidTaskException();
                result.addException(e);
                dispatcher.dispatchError(event, request.getBaseDirectory(), e);
                return result;
            }
        }
        this.getLogger().info("Scanning for projects...");
        if (reactorManager.hasMultipleProjects()) {
            this.getLogger().info("Reactor build order: ");
            for (MavenProject project : reactorManager.getSortedProjects()) {
                this.getLogger().info("  " + project.getName());
            }
        }
        try {
            this.lifecycleExecutor.execute(session, reactorManager, dispatcher);
        }
        catch (LifecycleExecutionException e) {
            result.addException(e);
            dispatcher.dispatchError(event, request.getBaseDirectory(), e);
            return result;
        }
        catch (BuildFailureException e) {
            result.addException(e);
            dispatcher.dispatchError(event, request.getBaseDirectory(), e);
            return result;
        }
        result.setTopologicallySortedProjects(reactorManager.getSortedProjects());
        result.setProject(reactorManager.getTopLevelProject());
        result.setBuildPlans(session.getBuildPlans());
        dispatcher.dispatchEnd(event, request.getBaseDirectory());
        return result;
    }

    protected List getProjects(MavenExecutionRequest request) throws MavenExecutionException {
        List files;
        try {
            files = this.getProjectFiles(request);
        }
        catch (IOException e) {
            throw new MavenExecutionException("Error selecting project files for the reactor: " + e.getMessage(), e);
        }
        List projects = this.collectProjects(files, request, !request.useReactor());
        return projects;
    }

    private List collectProjects(List files, MavenExecutionRequest request, boolean isRoot) throws MavenExecutionException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>(files.size());
        if (!files.isEmpty()) {
            for (File file : files) {
                MavenProject project;
                boolean usingReleasePom = false;
                if ("release-pom.xml".equals(file.getName())) {
                    this.getLogger().info("NOTE: Using release-pom: " + file + " in reactor build.");
                    usingReleasePom = true;
                }
                try {
                    project = this.projectBuilder.build(file, request.getProjectBuildingConfiguration());
                }
                catch (ProjectBuildingException e) {
                    throw new MavenExecutionException("Failed to build MavenProject instance for: " + file, file, e);
                }
                if (isRoot) {
                    project.setExecutionRoot(true);
                }
                if (project.getPrerequisites() != null && project.getPrerequisites().getMaven() != null) {
                    DefaultArtifactVersion version = new DefaultArtifactVersion(project.getPrerequisites().getMaven());
                    if (this.runtimeInformation.getApplicationInformation().getVersion().compareTo((Object)version) < 0) {
                        throw new MavenExecutionException("Unable to build project '" + file + "; it requires Maven version " + version.toString(), file);
                    }
                }
                if (project.getModules() != null && !project.getModules().isEmpty() && request.isRecursive()) {
                    project.setPackaging("pom");
                    File basedir = file.getParentFile();
                    ArrayList<File> moduleFiles = new ArrayList<File>(project.getModules().size());
                    for (String name : project.getModules()) {
                        if (StringUtils.isEmpty((String)StringUtils.trim((String)name))) {
                            this.getLogger().warn("Empty module detected. Please check you don't have any empty module definitions in your POM.");
                            continue;
                        }
                        File moduleFile = new File(basedir, name);
                        if (!moduleFile.exists()) {
                            throw new MissingModuleException(name, moduleFile, file);
                        }
                        if (moduleFile.isDirectory()) {
                            moduleFile = usingReleasePom ? new File(basedir, name + "/" + "release-pom.xml") : new File(basedir, name + "/" + "pom.xml");
                        }
                        if (Os.isFamily((String)"windows")) {
                            try {
                                moduleFile = moduleFile.getCanonicalFile();
                            }
                            catch (IOException e) {
                                throw new MavenExecutionException("Unable to canonicalize file name " + moduleFile, e);
                            }
                        } else {
                            moduleFile = new File(moduleFile.toURI().normalize());
                        }
                        moduleFiles.add(moduleFile);
                    }
                    List collectedProjects = this.collectProjects(moduleFiles, request, false);
                    projects.addAll(collectedProjects);
                    project.setCollectedProjects(collectedProjects);
                }
                projects.add(project);
            }
        }
        return projects;
    }

    protected MavenSession createSession(MavenExecutionRequest request, ReactorManager reactorManager, EventDispatcher dispatcher) {
        MavenSession session = new MavenSession(this.container, request, dispatcher, reactorManager);
        return session;
    }

    private List getProjectFiles(MavenExecutionRequest request) throws IOException {
        List<File> files = Collections.EMPTY_LIST;
        File userDir = new File(request.getBaseDirectory());
        if (request.useReactor()) {
            String includes = System.getProperty("maven.reactor.includes", "**/pom.xml,**/release-pom.xml");
            String excludes = System.getProperty("maven.reactor.excludes", "pom.xml,release-pom.xml");
            files = FileUtils.getFiles((File)userDir, (String)includes, (String)excludes);
            this.filterOneProjectFilePerDirectory(files);
            Collections.sort(files);
        } else if (request.getPom() != null) {
            File projectFile = request.getPom().getAbsoluteFile();
            if (projectFile.exists()) {
                files = Collections.singletonList(projectFile);
            }
        } else {
            File projectFile = new File(userDir, "release-pom.xml");
            if (!projectFile.exists()) {
                projectFile = new File(userDir, "pom.xml");
            }
            if (projectFile.exists()) {
                files = Collections.singletonList(projectFile);
            }
        }
        return files;
    }

    private void filterOneProjectFilePerDirectory(List files) {
        ArrayList<File> releaseDirs = new ArrayList<File>();
        for (File projectFile : files) {
            if (!"release-pom.xml".equals(projectFile.getName())) continue;
            releaseDirs.add(projectFile.getParentFile());
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File projectFile;
            projectFile = (File)it.next();
            if ("release-pom.xml".equals(projectFile.getName()) || !releaseDirs.contains(projectFile.getParentFile())) continue;
            it.remove();
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

