/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.errors.CoreErrorReporter;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.realm.MavenRealmManager;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.events.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenExecutionRequest
implements MavenExecutionRequest {
    private ArtifactRepository localRepository;
    private File localRepositoryPath;
    private boolean offline = false;
    private boolean interactiveMode = true;
    private List proxies;
    private List servers;
    private List mirrors;
    private List profiles;
    private List pluginGroups = new ArrayList();
    private boolean usePluginUpdateOverride;
    private boolean isProjectPresent = true;
    private File userSettingsFile;
    private File globalSettingsFile;
    private File basedir;
    private List goals;
    private boolean useReactor = false;
    private boolean recursive = true;
    private File pom;
    private String reactorFailureBehavior = "fail-fast";
    private Properties properties;
    private Properties userProperties;
    private Date startTime;
    private boolean showErrors = false;
    private List eventMonitors;
    private List activeProfiles;
    private List inactiveProfiles;
    private TransferListener transferListener;
    private int loggingLevel = 1;
    private String globalChecksumPolicy = "warn";
    private boolean updateSnapshots = false;
    private ProfileManager profileManager;
    private List<ArtifactRepository> remoteRepositories;
    private boolean noSnapshotUpdates;
    private MavenRealmManager realmManager;
    private Settings settings;
    private CoreErrorReporter errorReporter;
    private ProfileActivationContext profileActivationContext;
    private ProjectBuilderConfiguration projectBuildingConfiguration;

    public static MavenExecutionRequest copy(MavenExecutionRequest original) {
        DefaultMavenExecutionRequest copy = new DefaultMavenExecutionRequest();
        copy.setLocalRepository(original.getLocalRepository());
        copy.setLocalRepositoryPath(original.getLocalRepositoryPath());
        copy.setOffline(original.isOffline());
        copy.setInteractiveMode(original.isInteractiveMode());
        copy.setProxies(original.getProxies());
        copy.setServers(original.getServers());
        copy.setMirrors(original.getMirrors());
        copy.setProfiles(original.getProfiles());
        copy.setPluginGroups(original.getPluginGroups());
        copy.setUsePluginUpdateOverride(original.isUsePluginUpdateOverride());
        copy.setProjectPresent(original.isProjectPresent());
        copy.setUserSettingsFile(original.getUserSettingsFile());
        copy.setGlobalSettingsFile(original.getGlobalSettingsFile());
        copy.setBaseDirectory(new File(original.getBaseDirectory()));
        copy.setGoals(original.getGoals());
        copy.setUseReactor(original.useReactor());
        copy.setRecursive(original.isRecursive());
        copy.setPom(original.getPom());
        copy.setReactorFailureBehavior(original.getReactorFailureBehavior());
        copy.setProperties(original.getProperties());
        copy.setStartTime(original.getStartTime());
        copy.setShowErrors(original.isShowErrors());
        copy.setEventMonitors(original.getEventMonitors());
        copy.setActiveProfiles(original.getActiveProfiles());
        copy.setInactiveProfiles(original.getInactiveProfiles());
        copy.setTransferListener(original.getTransferListener());
        copy.setLoggingLevel(original.getLoggingLevel());
        copy.setGlobalChecksumPolicy(original.getGlobalChecksumPolicy());
        copy.setUpdateSnapshots(original.isUpdateSnapshots());
        copy.setProfileManager(original.getProfileManager());
        copy.setRemoteRepositories(original.getRemoteRepositories());
        copy.setNoSnapshotUpdates(original.isNoSnapshotUpdates());
        copy.setRealmManager(original.getRealmManager());
        return original;
    }

    @Override
    public String getBaseDirectory() {
        if (this.basedir == null) {
            return null;
        }
        return this.basedir.getAbsolutePath();
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public File getLocalRepositoryPath() {
        return this.localRepositoryPath;
    }

    @Override
    public List getGoals() {
        return this.goals;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getPomFile() {
        return this.pom.getAbsolutePath();
    }

    @Override
    public File getPom() {
        return this.pom;
    }

    @Override
    public String getReactorFailureBehavior() {
        return this.reactorFailureBehavior;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isShowErrors() {
        return this.showErrors;
    }

    @Override
    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    @Override
    public List getEventMonitors() {
        return this.eventMonitors;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setEventMonitors(List eventMonitors) {
        this.eventMonitors = eventMonitors;
    }

    public void setActiveProfiles(List activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void setInactiveProfiles(List inactiveProfiles) {
        this.inactiveProfiles = inactiveProfiles;
    }

    public void setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public void setProjectBuildingConfiguration(ProjectBuilderConfiguration projectBuildingConfiguration) {
        this.projectBuildingConfiguration = projectBuildingConfiguration;
    }

    @Override
    public List getActiveProfiles() {
        if (this.activeProfiles == null) {
            this.activeProfiles = new ArrayList();
        }
        return this.activeProfiles;
    }

    @Override
    public List getInactiveProfiles() {
        if (this.inactiveProfiles == null) {
            this.inactiveProfiles = new ArrayList();
        }
        return this.inactiveProfiles;
    }

    @Override
    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    @Override
    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    @Override
    public boolean isNoSnapshotUpdates() {
        return this.noSnapshotUpdates;
    }

    @Override
    public String getGlobalChecksumPolicy() {
        return this.globalChecksumPolicy;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public MavenExecutionRequest setBaseDirectory(File basedir) {
        this.basedir = basedir;
        return this;
    }

    @Override
    public MavenExecutionRequest setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @Override
    public MavenExecutionRequest setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
        return this;
    }

    @Override
    public MavenExecutionRequest setGoals(List goals) {
        this.goals = goals;
        return this;
    }

    @Override
    public MavenExecutionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    @Override
    public MavenExecutionRequest setLocalRepositoryPath(File localRepository) {
        this.localRepositoryPath = localRepository;
        return this;
    }

    @Override
    public MavenExecutionRequest setLocalRepositoryPath(String localRepository) {
        this.localRepositoryPath = new File(localRepository);
        return this;
    }

    @Override
    public MavenExecutionRequest setProperties(Properties properties) {
        if (this.properties == null) {
            this.properties = properties;
        } else {
            this.properties.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    @Override
    public MavenExecutionRequest setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
        if (this.userProperties == null) {
            this.userProperties = new Properties();
        }
        this.userProperties.setProperty(key, value);
        return this;
    }

    @Override
    public MavenExecutionRequest setReactorFailureBehavior(String failureBehavior) {
        this.reactorFailureBehavior = failureBehavior;
        return this;
    }

    @Override
    public MavenExecutionRequest addActiveProfile(String profile) {
        this.getActiveProfiles().add(profile);
        return this;
    }

    @Override
    public MavenExecutionRequest addInactiveProfile(String profile) {
        this.getInactiveProfiles().add(profile);
        return this;
    }

    @Override
    public MavenExecutionRequest addActiveProfiles(List profiles) {
        this.getActiveProfiles().addAll(profiles);
        return this;
    }

    @Override
    public MavenExecutionRequest addInactiveProfiles(List profiles) {
        this.getInactiveProfiles().addAll(profiles);
        return this;
    }

    @Override
    public MavenExecutionRequest addEventMonitor(EventMonitor monitor) {
        if (this.eventMonitors == null) {
            this.eventMonitors = new ArrayList();
        }
        this.eventMonitors.add(monitor);
        return this;
    }

    @Override
    public MavenExecutionRequest setUseReactor(boolean reactorActive) {
        this.useReactor = reactorActive;
        return this;
    }

    @Override
    public boolean useReactor() {
        return this.useReactor;
    }

    @Override
    public MavenExecutionRequest setPomFile(String pomFilename) {
        if (pomFilename != null) {
            this.pom = new File(pomFilename);
        }
        return this;
    }

    @Override
    public MavenExecutionRequest setPom(File pom) {
        this.pom = pom;
        return this;
    }

    @Override
    public MavenExecutionRequest setInteractiveMode(boolean interactive) {
        this.interactiveMode = interactive;
        return this;
    }

    @Override
    public MavenExecutionRequest setTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    @Override
    public MavenExecutionRequest setLoggingLevel(int loggingLevel) {
        this.loggingLevel = loggingLevel;
        return this;
    }

    @Override
    public MavenExecutionRequest setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    @Override
    public MavenExecutionRequest setUpdateSnapshots(boolean updateSnapshots) {
        this.updateSnapshots = updateSnapshots;
        return this;
    }

    @Override
    public MavenExecutionRequest setNoSnapshotUpdates(boolean noSnapshotUpdates) {
        this.noSnapshotUpdates = noSnapshotUpdates;
        return this;
    }

    @Override
    public MavenExecutionRequest setGlobalChecksumPolicy(String globalChecksumPolicy) {
        this.globalChecksumPolicy = globalChecksumPolicy;
        return this;
    }

    @Override
    public List getProxies() {
        return this.proxies;
    }

    @Override
    public MavenExecutionRequest setProxies(List proxies) {
        this.proxies = proxies;
        return this;
    }

    @Override
    public List getServers() {
        return this.servers;
    }

    @Override
    public MavenExecutionRequest setServers(List servers) {
        this.servers = servers;
        return this;
    }

    @Override
    public List getMirrors() {
        return this.mirrors;
    }

    @Override
    public MavenExecutionRequest setMirrors(List mirrors) {
        this.mirrors = mirrors;
        return this;
    }

    @Override
    public List getProfiles() {
        return this.profiles;
    }

    @Override
    public MavenExecutionRequest setProfiles(List profiles) {
        this.profiles = profiles;
        return this;
    }

    @Override
    public List getPluginGroups() {
        return this.pluginGroups;
    }

    @Override
    public MavenExecutionRequest setPluginGroups(List pluginGroups) {
        this.pluginGroups = pluginGroups;
        return this;
    }

    @Override
    public boolean isUsePluginUpdateOverride() {
        return this.usePluginUpdateOverride;
    }

    @Override
    public MavenExecutionRequest setUsePluginUpdateOverride(boolean usePluginUpdateOverride) {
        this.usePluginUpdateOverride = usePluginUpdateOverride;
        return this;
    }

    @Override
    public MavenExecutionRequest setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @Override
    public MavenExecutionRequest setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @Override
    public MavenExecutionRequest setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
        return this;
    }

    @Override
    public boolean isProjectPresent() {
        return this.isProjectPresent;
    }

    @Override
    public MavenExecutionRequest setProjectPresent(boolean projectPresent) {
        this.isProjectPresent = projectPresent;
        return this;
    }

    @Override
    public File getUserSettingsFile() {
        return this.userSettingsFile;
    }

    @Override
    public MavenExecutionRequest setUserSettingsFile(File userSettingsFile) {
        this.userSettingsFile = userSettingsFile;
        return this;
    }

    @Override
    public File getGlobalSettingsFile() {
        return this.globalSettingsFile;
    }

    @Override
    public MavenExecutionRequest setGlobalSettingsFile(File globalSettingsFile) {
        this.globalSettingsFile = globalSettingsFile;
        return this;
    }

    @Override
    public MavenExecutionRequest addRemoteRepository(ArtifactRepository repository) {
        if (this.remoteRepositories == null) {
            this.remoteRepositories = new ArrayList<ArtifactRepository>();
        }
        this.remoteRepositories.add(repository);
        return this;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public MavenExecutionRequest setRealmManager(MavenRealmManager realmManager) {
        this.realmManager = realmManager;
        return this;
    }

    @Override
    public MavenRealmManager getRealmManager() {
        return this.realmManager;
    }

    @Override
    public MavenExecutionRequest clearAccumulatedBuildState() {
        this.realmManager.clear();
        return this;
    }

    @Override
    public CoreErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    @Override
    public MavenExecutionRequest setErrorReporter(CoreErrorReporter reporter) {
        this.errorReporter = reporter;
        return this;
    }

    @Override
    public ProfileActivationContext getProfileActivationContext() {
        return this.profileActivationContext;
    }

    @Override
    public MavenExecutionRequest setProfileActivationContext(ProfileActivationContext profileActivationContext) {
        this.profileActivationContext = profileActivationContext;
        return this;
    }

    @Override
    public Properties getUserProperties() {
        return this.userProperties;
    }

    @Override
    public MavenExecutionRequest setUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    @Override
    public ProjectBuilderConfiguration getProjectBuildingConfiguration() {
        if (this.projectBuildingConfiguration == null) {
            this.projectBuildingConfiguration = new DefaultProjectBuilderConfiguration();
            this.projectBuildingConfiguration.setLocalRepository(this.getLocalRepository());
            this.projectBuildingConfiguration.setExecutionProperties(this.getProperties());
            this.projectBuildingConfiguration.setGlobalProfileManager(this.getProfileManager());
            this.projectBuildingConfiguration.setUserProperties(this.getUserProperties());
            this.projectBuildingConfiguration.setBuildStartTime(this.getStartTime());
            this.projectBuildingConfiguration.setRemoteRepositories(this.getRemoteRepositories());
        }
        return this.projectBuildingConfiguration;
    }
}

