/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.plan.BuildPlan;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.realm.MavenRealmManager;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenSession {
    private PlexusContainer container;
    private EventDispatcher eventDispatcher;
    private ReactorManager reactorManager;
    private boolean usingPOMsFromFilesystem = true;
    private MavenExecutionRequest request;
    private MavenProject currentProject;
    private Stack forkedProjectStack = new Stack();
    private Map reports = new LinkedHashMap();
    private Map buildPlans = new HashMap();

    public MavenSession(PlexusContainer container, MavenExecutionRequest request, EventDispatcher eventDispatcher, ReactorManager reactorManager) {
        this.container = container;
        this.request = request;
        this.eventDispatcher = eventDispatcher;
        this.reactorManager = reactorManager;
    }

    public MavenRealmManager getRealmManager() {
        return this.request.getRealmManager();
    }

    public Map getPluginContext(PluginDescriptor pluginDescriptor, MavenProject project) {
        return this.reactorManager.getPluginContext(pluginDescriptor, project);
    }

    public PlexusContainer getContainer() {
        return this.container;
    }

    public ArtifactRepository getLocalRepository() {
        return this.request.getLocalRepository();
    }

    public List getGoals() {
        return this.request.getGoals();
    }

    public Properties getExecutionProperties() {
        return this.request.getProperties();
    }

    public Object lookup(String role) throws ComponentLookupException {
        return this.container.lookup(role);
    }

    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.container.lookup(role, roleHint);
    }

    public <T> T lookup(Class<T> type) throws ComponentLookupException {
        return (T)this.container.lookup(type);
    }

    public <T> T lookup(Class<T> type, String roleHint) throws ComponentLookupException {
        return (T)this.container.lookup(type, roleHint);
    }

    public List lookupList(String role) throws ComponentLookupException {
        return this.container.lookupList(role);
    }

    public Map lookupMap(String role) throws ComponentLookupException {
        return this.container.lookupMap(role);
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public Settings getSettings() {
        return this.request.getSettings();
    }

    public List getSortedProjects() {
        return this.reactorManager.getSortedProjects();
    }

    public String getExecutionRootDirectory() {
        return this.request.getBaseDirectory();
    }

    public boolean isUsingPOMsFromFilesystem() {
        return this.request.isProjectPresent();
    }

    public Date getStartTime() {
        return this.request.getStartTime();
    }

    public MavenExecutionRequest getRequest() {
        return this.request;
    }

    public void addForkedProject(MavenProject project) {
        this.forkedProjectStack.push(this.currentProject);
        this.currentProject = project;
    }

    public MavenProject removeForkedProject() {
        if (!this.forkedProjectStack.isEmpty()) {
            MavenProject lastCurrent = this.currentProject;
            this.currentProject = (MavenProject)this.forkedProjectStack.pop();
            return lastCurrent;
        }
        return null;
    }

    public void setCurrentProject(MavenProject currentProject) {
        this.currentProject = currentProject;
    }

    public MavenProject getCurrentProject() {
        return this.currentProject;
    }

    public List getReports() {
        if (this.reports == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.reports.values());
    }

    public void clearReports() {
        this.reports.clear();
    }

    public void addReport(MojoDescriptor mojoDescriptor, MavenReport report) {
        this.reports.put(mojoDescriptor, report);
    }

    public Set getReportMojoDescriptors() {
        if (this.reports == null) {
            return Collections.EMPTY_SET;
        }
        return this.reports.keySet();
    }

    public BuildPlan getBuildPlan(String projectId) {
        return (BuildPlan)this.buildPlans.get(projectId);
    }

    public BuildPlan getBuildPlan(MavenProject project) {
        return (BuildPlan)this.buildPlans.get(project.getId());
    }

    public void setBuildPlan(MavenProject project, BuildPlan buildPlan) {
        this.buildPlans.put(project.getId(), buildPlan);
    }

    public Map getBuildPlans() {
        return this.buildPlans;
    }

    public ProjectBuilderConfiguration getProjectBuilderConfiguration() {
        return this.request.getProjectBuildingConfiguration();
    }

    public List<String> getPluginGroups() {
        return this.request.getPluginGroups();
    }

    public boolean isOffline() {
        return this.request.isOffline();
    }
}

