/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.DuplicateProjectException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;

public class ReactorManager {
    public static final String FAIL_FAST = "fail-fast";
    public static final String FAIL_AT_END = "fail-at-end";
    public static final String FAIL_NEVER = "fail-never";
    private List blackList = new ArrayList();
    private Map buildFailuresByProject = new HashMap();
    private Map pluginContextsByProjectAndPluginKey = new HashMap();
    private String failureBehavior = "fail-fast";
    private final ProjectSorter sorter;
    private Map buildSuccessesByProject = new HashMap();

    public ReactorManager(List projects, String failureBehavior) throws CycleDetectedException, DuplicateProjectException {
        this.sorter = new ProjectSorter(projects);
        this.failureBehavior = failureBehavior == null ? FAIL_FAST : failureBehavior;
    }

    public Map getPluginContext(PluginDescriptor plugin, MavenProject project) {
        HashMap pluginContext;
        HashMap pluginContextsByKey = (HashMap)this.pluginContextsByProjectAndPluginKey.get(project.getId());
        if (pluginContextsByKey == null) {
            pluginContextsByKey = new HashMap();
            this.pluginContextsByProjectAndPluginKey.put(project.getId(), pluginContextsByKey);
        }
        if ((pluginContext = (HashMap)pluginContextsByKey.get(plugin.getPluginLookupKey())) == null) {
            pluginContext = new HashMap();
            pluginContextsByKey.put(plugin.getPluginLookupKey(), pluginContext);
        }
        return pluginContext;
    }

    public String getFailureBehavior() {
        return this.failureBehavior;
    }

    public void blackList(MavenProject project) {
        this.blackList(ReactorManager.getProjectKey(project));
    }

    private void blackList(String id) {
        if (!this.blackList.contains(id)) {
            this.blackList.add(id);
            List dependents = this.sorter.getDependents(id);
            if (dependents != null && !dependents.isEmpty()) {
                for (String dependentId : dependents) {
                    if (this.buildSuccessesByProject.containsKey(dependentId) || this.buildFailuresByProject.containsKey(dependentId)) continue;
                    this.blackList(dependentId);
                }
            }
        }
    }

    public boolean isBlackListed(MavenProject project) {
        return this.blackList.contains(ReactorManager.getProjectKey(project));
    }

    private static String getProjectKey(MavenProject project) {
        return ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
    }

    public void registerBuildFailure(MavenProject project, Exception error, String task, long time) {
        this.buildFailuresByProject.put(ReactorManager.getProjectKey(project), new BuildFailure(error, task, time));
    }

    public boolean hasBuildFailures() {
        return !this.buildFailuresByProject.isEmpty();
    }

    public boolean hasBuildFailure(MavenProject project) {
        return this.buildFailuresByProject.containsKey(ReactorManager.getProjectKey(project));
    }

    public boolean hasMultipleProjects() {
        return this.sorter.hasMultipleProjects();
    }

    public List getSortedProjects() {
        return this.sorter.getSortedProjects();
    }

    public MavenProject getTopLevelProject() {
        return this.sorter.getTopLevelProject();
    }

    public boolean hasBuildSuccess(MavenProject project) {
        return this.buildSuccessesByProject.containsKey(ReactorManager.getProjectKey(project));
    }

    public void registerBuildSuccess(MavenProject project, long time) {
        this.buildSuccessesByProject.put(ReactorManager.getProjectKey(project), new BuildSuccess(project, time));
    }

    public BuildFailure getBuildFailure(MavenProject project) {
        return (BuildFailure)this.buildFailuresByProject.get(ReactorManager.getProjectKey(project));
    }

    public BuildSuccess getBuildSuccess(MavenProject project) {
        return (BuildSuccess)this.buildSuccessesByProject.get(ReactorManager.getProjectKey(project));
    }

    public boolean executedMultipleProjects() {
        return this.buildFailuresByProject.size() + this.buildSuccessesByProject.size() > 1;
    }

    protected static class ProjectSorter {
        private final DAG dag = new DAG();
        private final List sortedProjects;
        private MavenProject topLevelProject;

        public ProjectSorter(List projects) throws CycleDetectedException, DuplicateProjectException {
            String id2;
            HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
            for (MavenProject project : projects) {
                id2 = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                if (this.dag.getVertex(id2) != null) {
                    MavenProject conflictingProject = (MavenProject)projectMap.get(id2);
                    throw new DuplicateProjectException(id2, conflictingProject.getFile(), project.getFile(), "Project '" + id2 + "' is duplicated in the reactor");
                }
                this.dag.addVertex(id2);
                projectMap.put(id2, project);
            }
            for (MavenProject project : projects) {
                List reportPlugins;
                List buildPlugins;
                String parentId;
                id2 = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                for (Dependency dependency : project.getDependencies()) {
                    String dependencyId = ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId());
                    if (this.dag.getVertex(dependencyId) == null) continue;
                    project.addProjectReference((MavenProject)projectMap.get(dependencyId));
                    this.dag.addEdge(id2, dependencyId);
                }
                MavenProject parent = project.getParent();
                if (parent != null && this.dag.getVertex(parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId())) != null) {
                    if (this.dag.hasEdge(parentId, id2)) {
                        this.dag.removeEdge(parentId, id2);
                    }
                    this.dag.addEdge(id2, parentId);
                }
                if ((buildPlugins = project.getBuildPlugins()) != null) {
                    for (Plugin plugin : buildPlugins) {
                        String pluginId = ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId());
                        if (this.dag.getVertex(pluginId) == null || pluginId.equals(id2)) continue;
                        this.addEdgeWithParentCheck(projectMap, pluginId, project, id2);
                    }
                }
                if ((reportPlugins = project.getReportPlugins()) != null) {
                    for (ReportPlugin plugin : reportPlugins) {
                        String pluginId = ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId());
                        if (this.dag.getVertex(pluginId) == null || pluginId.equals(id2)) continue;
                        this.addEdgeWithParentCheck(projectMap, pluginId, project, id2);
                    }
                }
                for (Extension extension : project.getBuildExtensions()) {
                    String extensionId = ArtifactUtils.versionlessKey((String)extension.getGroupId(), (String)extension.getArtifactId());
                    if (this.dag.getVertex(extensionId) == null) continue;
                    this.addEdgeWithParentCheck(projectMap, extensionId, project, id2);
                }
            }
            ArrayList sortedProjects = new ArrayList();
            for (String id2 : TopologicalSorter.sort((DAG)this.dag)) {
                sortedProjects.add(projectMap.get(id2));
            }
            this.sortedProjects = Collections.unmodifiableList(sortedProjects);
        }

        private void addEdgeWithParentCheck(Map projectMap, String projectRefId, MavenProject project, String id) throws CycleDetectedException {
            MavenProject extProject = (MavenProject)projectMap.get(projectRefId);
            if (extProject == null) {
                return;
            }
            project.addProjectReference(extProject);
            MavenProject extParent = extProject.getParent();
            if (extParent != null) {
                String parentId = ArtifactUtils.versionlessKey((String)extParent.getGroupId(), (String)extParent.getArtifactId());
                if (!this.dag.hasEdge(projectRefId, id) || !parentId.equals(id)) {
                    this.dag.addEdge(id, projectRefId);
                }
            }
        }

        public MavenProject getTopLevelProject() {
            if (this.topLevelProject == null) {
                Iterator i = this.sortedProjects.iterator();
                while (i.hasNext() && this.topLevelProject == null) {
                    MavenProject project = (MavenProject)i.next();
                    if (!project.isExecutionRoot()) continue;
                    this.topLevelProject = project;
                }
            }
            return this.topLevelProject;
        }

        public List getSortedProjects() {
            return this.sortedProjects;
        }

        public boolean hasMultipleProjects() {
            return this.sortedProjects.size() > 1;
        }

        private List getDependents(String id) {
            return this.dag.getParentLabels(id);
        }
    }
}

