/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.maven.AggregatedBuildFailureException;
import org.apache.maven.BuildFailureException;
import org.apache.maven.NoGoalsSpecifiedException;
import org.apache.maven.ProjectBuildFailureException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleException;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.LifecycleLoaderException;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.MojoBindingUtils;
import org.apache.maven.lifecycle.TaskValidationResult;
import org.apache.maven.lifecycle.binding.LifecycleBindingManager;
import org.apache.maven.lifecycle.binding.MojoBindingFactory;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.plan.BuildPlan;
import org.apache.maven.lifecycle.plan.BuildPlanUtils;
import org.apache.maven.lifecycle.plan.BuildPlanner;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.loader.PluginLoader;
import org.apache.maven.plugin.loader.PluginLoaderException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=LifecycleExecutor.class)
public class DefaultLifecycleExecutor
extends AbstractLogEnabled
implements LifecycleExecutor {
    @Requirement
    private PluginManager pluginManager;
    @Requirement
    private PluginLoader pluginLoader;
    @Requirement
    private BuildPlanner buildPlanner;
    @Requirement
    private MojoBindingFactory mojoBindingFactory;
    @Requirement
    private LifecycleBindingManager lifecycleBindingManager;
    @Requirement
    private PlexusContainer container;

    public void execute(MavenSession session, ReactorManager reactorManager, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException {
        String goal;
        MavenProject rootProject = reactorManager.getTopLevelProject();
        List<String> goals = session.getGoals();
        if ((goals == null || goals.isEmpty()) && rootProject != null && (goal = rootProject.getDefaultGoal()) != null) {
            goals = Collections.singletonList(goal);
        }
        if (goals == null || goals.isEmpty()) {
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append("\n\n");
            buffer.append("You must specify at least one goal or lifecycle phase to perform build steps.\n");
            buffer.append("The following list illustrates some commonly used build commands:\n\n");
            buffer.append("  mvn clean\n");
            buffer.append("    Deletes any build output (e.g. class files or JARs).\n");
            buffer.append("  mvn test\n");
            buffer.append("    Runs the unit tests for the project.\n");
            buffer.append("  mvn install\n");
            buffer.append("    Copies the project artifacts into your local repository.\n");
            buffer.append("  mvn deploy\n");
            buffer.append("    Copies the project artifacts into the remote repository.\n");
            buffer.append("  mvn site\n");
            buffer.append("    Creates project documentation (e.g. reports or Javadoc).\n\n");
            buffer.append("Please see\n");
            buffer.append("http://maven.apache.org/guides/introduction/introduction-to-the-lifecycle.html\n");
            buffer.append("for a complete description of available lifecycle phases.\n\n");
            buffer.append("Use \"mvn --help\" to show general usage information about Maven's command line.\n\n");
            throw new NoGoalsSpecifiedException(buffer.toString());
        }
        List taskSegments = this.segmentTaskListByAggregationNeeds(goals, session, rootProject);
        try {
            this.buildPlanner.constructInitialProjectBuildPlans(session);
        }
        catch (LifecycleException e) {
            throw new LifecycleExecutionException("Failed to construct one or more initial build plans. Reason: " + e.getMessage(), e);
        }
        this.executeTaskSegments(taskSegments, reactorManager, session, rootProject, dispatcher);
    }

    private void executeTaskSegments(List taskSegments, ReactorManager reactorManager, MavenSession session, MavenProject rootProject, EventDispatcher dispatcher) throws LifecycleExecutionException, BuildFailureException {
        for (TaskSegment segment : taskSegments) {
            if (segment.aggregate()) {
                this.executeTaskSegmentForProject(segment, rootProject, reactorManager, dispatcher, session);
                continue;
            }
            List sortedProjects = session.getSortedProjects();
            for (MavenProject currentProject : sortedProjects) {
                this.executeTaskSegmentForProject(segment, currentProject, reactorManager, dispatcher, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTaskSegmentForProject(TaskSegment segment, MavenProject project, ReactorManager reactorManager, EventDispatcher dispatcher, MavenSession session) throws LifecycleExecutionException, BuildFailureException {
        if (!reactorManager.isBlackListed(project)) {
            String target = project.getName() + "\nId: " + project.getId() + "\n" + segment;
            this.getLogger().debug("Constructing build plan for " + target);
            String event = "project-execute";
            long buildStartTime = System.currentTimeMillis();
            dispatcher.dispatchStart(event, target);
            ClassRealm oldLookupRealm = this.setProjectLookupRealm(session, project);
            try {
                session.setCurrentProject(project);
                List mojoBindings = this.getLifecycleBindings(segment.getTasks(), project, session, target);
                String currentPhase = null;
                for (MojoBinding binding : mojoBindings) {
                    String phase;
                    String string = phase = binding.getPhase() == null ? null : binding.getPhase().getName();
                    if (currentPhase != null && !currentPhase.equals(phase)) {
                        dispatcher.dispatchEnd("phase-execute", currentPhase);
                        currentPhase = null;
                    }
                    if (currentPhase == null && phase != null) {
                        currentPhase = phase;
                        dispatcher.dispatchStart("phase-execute", currentPhase);
                    }
                    try {
                        this.executeGoalAndHandleFailures(binding, session, dispatcher, event, reactorManager, buildStartTime, target, segment.aggregate());
                    }
                    catch (MojoFailureException e) {
                        BuildFailureException error;
                        if (segment.aggregate()) {
                            error = new AggregatedBuildFailureException(session.getExecutionRootDirectory(), binding, e);
                            dispatcher.dispatchError(event, target, error);
                            if (!this.handleExecutionFailure(reactorManager, project, error, binding, buildStartTime)) continue;
                            throw error;
                        }
                        error = new ProjectBuildFailureException(project.getId(), binding, e);
                        dispatcher.dispatchError(event, target, error);
                        if (!this.handleExecutionFailure(reactorManager, project, error, binding, buildStartTime)) continue;
                        throw error;
                    }
                }
                if (currentPhase != null) {
                    dispatcher.dispatchEnd("phase-execute", currentPhase);
                }
            }
            finally {
                session.setCurrentProject(null);
                this.restoreLookupRealm(oldLookupRealm);
            }
            reactorManager.registerBuildSuccess(project, System.currentTimeMillis() - buildStartTime);
            dispatcher.dispatchEnd(event, target);
        } else {
            this.line();
            this.getLogger().info("SKIPPING " + project.getName());
            this.getLogger().info("  " + segment);
            this.getLogger().info("This project has been banned from further executions due to previous failures.");
            this.line();
        }
    }

    private void restoreLookupRealm(ClassRealm oldLookupRealm) {
        if (oldLookupRealm != null) {
            this.container.setLookupRealm(oldLookupRealm);
        }
    }

    private ClassRealm setProjectLookupRealm(MavenSession session, MavenProject rootProject) throws LifecycleExecutionException {
        ClassRealm projectRealm = session.getRealmManager().getProjectRealm(rootProject.getGroupId(), rootProject.getArtifactId(), rootProject.getVersion());
        if (projectRealm != null) {
            return this.container.setLookupRealm(projectRealm);
        }
        return this.container.getLookupRealm();
    }

    private List getLifecycleBindings(List tasks, MavenProject project, MavenSession session, String targetDescription) throws LifecycleExecutionException {
        List mojoBindings;
        try {
            BuildPlan plan = this.buildPlanner.constructBuildPlan(tasks, project, session, false);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\n\nOur build plan is:\n" + BuildPlanUtils.listBuildPlan(plan, false) + "\n\nfor task-segment: " + targetDescription);
            }
            mojoBindings = plan.renderExecutionPlan(new Stack());
        }
        catch (LifecycleException e) {
            throw new LifecycleExecutionException("Failed to construct build plan for: " + targetDescription + ". Reason: " + e.getMessage(), project, e);
        }
        return mojoBindings;
    }

    private void executeGoalAndHandleFailures(MojoBinding mojoBinding, MavenSession session, EventDispatcher dispatcher, String event, ReactorManager rm, long buildStartTime, String target, boolean allowAggregators) throws LifecycleExecutionException, MojoFailureException {
        block11: {
            MavenProject project = session.getCurrentProject();
            try {
                PluginDescriptor pluginDescriptor;
                try {
                    pluginDescriptor = this.pluginLoader.loadPlugin(mojoBinding, project, session);
                }
                catch (PluginLoaderException e) {
                    if (mojoBinding.isOptional()) {
                        this.getLogger().debug("Skipping optional mojo execution: " + MojoBindingUtils.toString((MojoBinding)mojoBinding), (Throwable)e);
                        return;
                    }
                    throw new LifecycleExecutionException("Failed to load plugin for: " + MojoBindingUtils.toString((MojoBinding)mojoBinding) + ". Reason: " + e.getMessage(), project, e);
                }
                MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(mojoBinding.getGoal());
                this.validateMojoExecution(mojoBinding, mojoDescriptor, project, allowAggregators);
                MojoExecution mojoExecution = new MojoExecution(mojoDescriptor);
                mojoExecution.setConfiguration((Xpp3Dom)mojoBinding.getConfiguration());
                try {
                    this.pluginManager.executeMojo(project, mojoExecution, session);
                }
                catch (PluginManagerException e) {
                    throw new LifecycleExecutionException("Internal error in the plugin manager executing goal '" + mojoDescriptor.getId() + "': " + e.getMessage(), project, e);
                }
                catch (ArtifactNotFoundException e) {
                    throw new LifecycleExecutionException(e.getMessage(), project, e);
                }
                catch (InvalidDependencyVersionException e) {
                    throw new LifecycleExecutionException(e.getMessage(), project, e);
                }
                catch (ArtifactResolutionException e) {
                    throw new LifecycleExecutionException(e.getMessage(), project, e);
                }
                catch (PluginConfigurationException e) {
                    throw new LifecycleExecutionException(e.getMessage(), project, e);
                }
            }
            catch (LifecycleExecutionException e) {
                dispatcher.dispatchError(event, target, e);
                if (!this.handleExecutionFailure(rm, project, e, mojoBinding, buildStartTime)) break block11;
                throw e;
            }
        }
    }

    private void validateMojoExecution(MojoBinding mojoBinding, MojoDescriptor mojoDescriptor, MavenProject project, boolean allowAggregators) throws LifecycleExecutionException {
        if (mojoDescriptor.isAggregator() && !allowAggregators) {
            if ("POM".equals(mojoBinding.getOrigin())) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("\n\nDEPRECATED: Binding aggregator mojos to lifecycle phases in the POM is considered dangerous.");
                buffer.append("\nThis feature has been deprecated. Please adjust your POM files accordingly.");
                buffer.append("\n\nOffending mojo:\n\n");
                buffer.append(MojoBindingUtils.toString((MojoBinding)mojoBinding));
                buffer.append("\n\nProject: ").append(project.getId());
                buffer.append("\nPOM File: ").append(String.valueOf(project.getFile()));
                buffer.append("\n");
                this.getLogger().warn(buffer.toString());
            } else {
                StringBuffer buffer = new StringBuffer();
                buffer.append("\n\nDEPRECATED: An aggregator mojo has been bound to your project's build lifecycle.");
                buffer.append("\nThis feature is dangerous, and has been deprecated.");
                buffer.append("\n\nOffending mojo:\n\n");
                buffer.append(MojoBindingUtils.toString((MojoBinding)mojoBinding));
                buffer.append("\n\nDirect binding of aggregator mojos to the lifecycle is not allowed, but this binding was not configured from within in your POM.");
                buffer.append("\n\nIts origin was: ").append(mojoBinding.getOrigin());
                if (mojoBinding.getOriginDescription() != null) {
                    buffer.append(" (").append(mojoBinding.getOriginDescription()).append(")");
                }
                buffer.append("\n");
                this.getLogger().warn(buffer.toString());
            }
        } else if (mojoDescriptor.isDirectInvocationOnly() && !"Direct invocation".equals(mojoBinding.getOrigin())) {
            if ("POM".equals(mojoBinding.getOrigin())) {
                throw new LifecycleExecutionException("Mojo:\n\n" + MojoBindingUtils.toString((MojoBinding)mojoBinding) + "\n\ncan only be invoked directly by the user. Binding it to lifecycle phases in the POM is not allowed.", project);
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("\n\nSKIPPING execution of mojo:\n\n").append(MojoBindingUtils.toString((MojoBinding)mojoBinding));
            buffer.append("\n\nIt specifies direct-invocation only, but has been bound to the build lifecycle.");
            buffer.append("\n\nDirect-invocation mojos can only be called by the user. This binding was not configured from within in your POM.");
            buffer.append("\n\nIts origin was: ").append(mojoBinding.getOrigin());
            if (mojoBinding.getOriginDescription() != null) {
                buffer.append(" (").append(mojoBinding.getOriginDescription()).append(")");
            }
            buffer.append("\n");
            this.getLogger().error(buffer.toString());
        }
    }

    private boolean handleExecutionFailure(ReactorManager rm, MavenProject project, Exception e, MojoBinding mojoBinding, long buildStartTime) {
        rm.registerBuildFailure(project, e, MojoBindingUtils.toString((MojoBinding)mojoBinding), System.currentTimeMillis() - buildStartTime);
        if ("fail-fast".equals(rm.getFailureBehavior())) {
            return true;
        }
        if ("fail-at-end".equals(rm.getFailureBehavior())) {
            rm.blackList(project);
        }
        return false;
    }

    public TaskValidationResult isTaskValid(String task, MavenSession session, MavenProject rootProject) {
        if (rootProject != null && !LifecycleUtils.isValidPhaseName((String)task)) {
            try {
                this.getMojoDescriptorForDirectInvocation(task, session, rootProject);
                return new TaskValidationResult();
            }
            catch (PluginLoaderException e) {
                return new TaskValidationResult(task, "Cannot find mojo descriptor for: '" + task + "' - Treating as non-aggregator.", e);
            }
            catch (LifecycleSpecificationException e) {
                String message = "Invalid task '" + task + "': you must specify a valid lifecycle phase, or" + " a goal in the format plugin:goal or pluginGroupId:pluginArtifactId:pluginVersion:goal";
                return new TaskValidationResult(task, message, e);
            }
            catch (LifecycleLoaderException e) {
                String message = "Failed to load one or more lifecycle definitions which may contain task: '" + task + "'.";
                return new TaskValidationResult(task, message, e);
            }
            catch (InvalidPluginException e) {
                return new TaskValidationResult(task, e.getMessage(), e);
            }
        }
        return new TaskValidationResult();
    }

    private List segmentTaskListByAggregationNeeds(List tasks, MavenSession session, MavenProject rootProject) {
        ArrayList<TaskSegment> segments = new ArrayList<TaskSegment>();
        if (rootProject != null) {
            TaskSegment currentSegment = null;
            for (String task : tasks) {
                if (LifecycleUtils.isValidPhaseName((String)task)) {
                    if (currentSegment != null && currentSegment.aggregate()) {
                        segments.add(currentSegment);
                        currentSegment = null;
                    }
                    if (currentSegment == null) {
                        currentSegment = new TaskSegment();
                    }
                    currentSegment.add(task);
                    continue;
                }
                MojoDescriptor mojo = null;
                try {
                    mojo = this.getMojoDescriptorForDirectInvocation(task, session, rootProject);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (mojo != null && (mojo.isAggregator() || !mojo.isProjectRequired())) {
                    if (currentSegment != null && !currentSegment.aggregate()) {
                        segments.add(currentSegment);
                        currentSegment = null;
                    }
                    if (currentSegment == null) {
                        currentSegment = new TaskSegment(true);
                    }
                    currentSegment.add(task);
                    continue;
                }
                if (currentSegment != null && currentSegment.aggregate()) {
                    segments.add(currentSegment);
                    currentSegment = null;
                }
                if (currentSegment == null) {
                    currentSegment = new TaskSegment();
                }
                currentSegment.add(task);
            }
            segments.add(currentSegment);
        } else {
            TaskSegment segment = new TaskSegment(false);
            Iterator i = tasks.iterator();
            while (i.hasNext()) {
                segment.add((String)i.next());
            }
            segments.add(segment);
        }
        return segments;
    }

    private MojoDescriptor getMojoDescriptorForDirectInvocation(String task, MavenSession session, MavenProject project) throws LifecycleSpecificationException, PluginLoaderException, LifecycleLoaderException, InvalidPluginException {
        MojoBinding binding = this.mojoBindingFactory.parseMojoBinding(task, project, session, true);
        PluginDescriptor descriptor = this.pluginLoader.loadPlugin(binding, project, session);
        MojoDescriptor mojoDescriptor = descriptor.getMojo(binding.getGoal());
        if (mojoDescriptor == null) {
            throw new InvalidPluginException("Plugin: " + descriptor.getId() + " does not contain referenced mojo: " + binding.getGoal());
        }
        return mojoDescriptor;
    }

    protected void line() {
        this.getLogger().info("------------------------------------------------------------------------");
    }

    public List getLifecycles() {
        return this.lifecycleBindingManager.getLifecycles();
    }

    private static class TaskSegment {
        private boolean aggregate;
        private final List tasks = new ArrayList();

        TaskSegment() {
        }

        TaskSegment(boolean aggregate) {
            this.aggregate = aggregate;
        }

        public String toString() {
            StringBuffer message = new StringBuffer();
            message.append("task-segment: [");
            Iterator it = this.tasks.iterator();
            while (it.hasNext()) {
                String task = (String)it.next();
                message.append(task);
                if (!it.hasNext()) continue;
                message.append(", ");
            }
            message.append("]");
            if (this.aggregate) {
                message.append(" (aggregator-style)");
            }
            return message.toString();
        }

        boolean aggregate() {
            return this.aggregate;
        }

        void add(String task) {
            this.tasks.add(task);
        }

        List getTasks() {
            return this.tasks;
        }
    }
}

