/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.binding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleBindingLoader;
import org.apache.maven.lifecycle.LifecycleLoaderException;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.MojoBindingUtils;
import org.apache.maven.lifecycle.binding.BindingUtils;
import org.apache.maven.lifecycle.binding.LegacyLifecycleMappingParser;
import org.apache.maven.lifecycle.binding.Lifecycle;
import org.apache.maven.lifecycle.binding.LifecycleBindingManager;
import org.apache.maven.lifecycle.binding.MojoBindingFactory;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Phase;
import org.apache.maven.plugin.loader.PluginLoader;
import org.apache.maven.plugin.loader.PluginLoaderException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultLifecycleBindingManager
implements LifecycleBindingManager,
LogEnabled {
    @Requirement
    private PluginLoader pluginLoader;
    @Requirement
    private MojoBindingFactory mojoBindingFactory;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private LegacyLifecycleMappingParser legacyLifecycleMappingParser;
    private Map bindingsByPackaging;
    private Map legacyMappingsByPackaging;
    private Logger logger;
    private List<Lifecycle> lifecycles;
    private List defaultReports;

    public List getLifecycles() {
        return this.lifecycles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LifecycleBindings getBindingsForPackaging(MavenProject project, MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException {
        String packaging = project.getPackaging();
        LifecycleBindings bindings = null;
        ClassRealm projectRealm = session.getRealmManager().getProjectRealm(project.getGroupId(), project.getArtifactId(), project.getVersion());
        ClassRealm oldRealm = this.container.setLookupRealm(projectRealm);
        try {
            LifecycleMapping mapping;
            LifecycleBindingLoader loader = (LifecycleBindingLoader)this.bindingsByPackaging.get(packaging);
            if (loader != null) {
                bindings = loader.getBindings();
            }
            if (bindings == null && (mapping = (LifecycleMapping)this.legacyMappingsByPackaging.get(packaging)) != null) {
                bindings = this.legacyLifecycleMappingParser.parseMappings(mapping, packaging);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.container.setLookupRealm(oldRealm);
            throw throwable;
        }
        this.container.setLookupRealm(oldRealm);
        if (bindings != null) {
            BindingUtils.injectProjectConfiguration(bindings, project);
        }
        if (bindings == null) {
            bindings = this.getDefaultBindings(project);
        }
        return bindings;
    }

    public LifecycleBindings getDefaultBindings(MavenProject project) throws LifecycleSpecificationException {
        LifecycleBindings bindings = this.legacyLifecycleMappingParser.parseDefaultMappings(this.lifecycles);
        BindingUtils.injectProjectConfiguration(bindings, project);
        return bindings;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public LifecycleBindings getProjectCustomBindings(MavenProject project, MavenSession session, Set unbindableMojos) throws LifecycleLoaderException, LifecycleSpecificationException {
        LifecycleBindings bindings = new LifecycleBindings();
        bindings.setPackaging(project.getPackaging());
        List plugins = project.getBuildPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                BindingUtils.injectPluginManagementInfo(plugin, project);
                PluginDescriptor pluginDescriptor = null;
                List executions = plugin.getExecutions();
                if (executions == null) continue;
                for (PluginExecution execution : executions) {
                    List goals = execution.getGoals();
                    if (goals == null || goals.isEmpty()) continue;
                    for (String goal : goals) {
                        if (goal == null) {
                            this.logger.warn("Execution: " + execution.getId() + " in plugin: " + plugin.getKey() + " in the POM has a null goal.");
                            continue;
                        }
                        MojoBinding mojoBinding = new MojoBinding();
                        mojoBinding.setGroupId(plugin.getGroupId());
                        mojoBinding.setArtifactId(plugin.getArtifactId());
                        mojoBinding.setVersion(plugin.getVersion());
                        mojoBinding.setGoal(goal);
                        mojoBinding.setConfiguration(BindingUtils.mergeConfigurations(plugin, execution));
                        mojoBinding.setExecutionId(execution.getId());
                        mojoBinding.setOrigin("POM");
                        this.logger.debug("Mojo: " + MojoBindingUtils.toString((MojoBinding)mojoBinding) + ": determining binding phase.");
                        String phase = execution.getPhase();
                        this.logger.debug("Phase from <execution/> section (merged with outer <plugin/> section) is: " + phase);
                        boolean pluginResolved = false;
                        if (phase == null) {
                            if (pluginDescriptor == null) {
                                try {
                                    pluginDescriptor = this.pluginLoader.loadPlugin(plugin, project, session);
                                    pluginResolved = true;
                                }
                                catch (PluginLoaderException e) {
                                    unbindableMojos.add(mojoBinding);
                                    String message = "Failed to load plugin descriptor for: " + plugin + ". Assigning this plugin to be resolved again just prior to its execution. " + "NOTE, This may affect assignment of the mojo: " + mojoBinding.getGoal() + " if its default phase (given in the plugin descriptor) is used.";
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug(message, (Throwable)e);
                                    }
                                    this.logger.warn(message + " Check debug output (-X) for more information.");
                                }
                            }
                            if (pluginDescriptor != null) {
                                if (pluginDescriptor.getMojos() == null) {
                                    this.logger.error("Somehow, the PluginDescriptor for plugin: " + plugin.getKey() + " contains no mojos. This is highly irregular. Ignoring...");
                                    unbindableMojos.add(mojoBinding);
                                    continue;
                                }
                                MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
                                phase = mojoDescriptor.getPhase();
                                this.logger.debug("Phase from plugin descriptor: " + mojoDescriptor.getFullGoalName() + " is: " + phase);
                            }
                            if (phase == null) {
                                if (pluginResolved) {
                                    StringBuffer message = new StringBuffer();
                                    message.append("\n\nNo lifecycle phase binding can be found for goal: " + goal);
                                    message.append(",\nspecified as a part of the execution: " + execution.getId());
                                    message.append("in plugin: ");
                                    message.append(pluginDescriptor.getPluginLookupKey());
                                    message.append("\n\nThis plugin was resolved successfully.");
                                    message.append("\nHowever, the mojo metadata it contains does not specify a default lifecycle phase binding.");
                                    message.append("\n\nPlease provide a valid <phase/> specification for execution: ").append(execution.getId()).append("\nin plugin: ").append(plugin.getKey());
                                    message.append("\n\n");
                                    throw new LifecycleSpecificationException(message.toString());
                                }
                                this.logger.warn("\n\nSkipping addition to build-plan for goal: " + goal + " in execution: " + execution.getId() + " of plugin: " + plugin.getKey() + " because no phase information was available (either through the mojo descriptor, which is currently missing, or in the POM itself).\n\n");
                                unbindableMojos.add(mojoBinding);
                                continue;
                            }
                        }
                        LifecycleUtils.addMojoBinding((String)phase, (MojoBinding)mojoBinding, (LifecycleBindings)bindings);
                    }
                }
            }
        }
        LifecycleUtils.setOrigin((LifecycleBindings)bindings, (String)"POM");
        return bindings;
    }

    public LifecycleBindings getPluginLifecycleOverlay(PluginDescriptor pluginDescriptor, String lifecycleId, MavenProject project) throws LifecycleLoaderException, LifecycleSpecificationException {
        org.apache.maven.plugin.lifecycle.Lifecycle lifecycleOverlay = null;
        try {
            lifecycleOverlay = pluginDescriptor.getLifecycleMapping(lifecycleId);
        }
        catch (IOException e) {
            throw new LifecycleLoaderException("Unable to read lifecycle mapping file: " + e.getMessage(), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new LifecycleLoaderException("Unable to parse lifecycle mapping file: " + e.getMessage(), (Throwable)e);
        }
        if (lifecycleOverlay == null) {
            throw new LifecycleLoaderException("Lifecycle '" + lifecycleId + "' not found in plugin");
        }
        LifecycleBindings bindings = new LifecycleBindings();
        for (Phase phase : lifecycleOverlay.getPhases()) {
            ArrayList<MojoBinding> phaseBindings = new ArrayList<MojoBinding>();
            for (Execution exec : phase.getExecutions()) {
                for (String goal : exec.getGoals()) {
                    MojoBinding binding;
                    if (goal.indexOf(":") > 0) {
                        binding = this.mojoBindingFactory.parseMojoBinding(goal, project);
                    } else {
                        binding = new MojoBinding();
                        binding.setGroupId(pluginDescriptor.getGroupId());
                        binding.setArtifactId(pluginDescriptor.getArtifactId());
                        binding.setVersion(pluginDescriptor.getVersion());
                        binding.setGoal(goal);
                    }
                    Xpp3Dom configuration = (Xpp3Dom)exec.getConfiguration();
                    if (phase.getConfiguration() != null) {
                        configuration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)new Xpp3Dom((Xpp3Dom)phase.getConfiguration()), (Xpp3Dom)configuration);
                    }
                    binding.setConfiguration((Object)configuration);
                    binding.setOrigin("Lifecycle mapping");
                    binding.setOriginDescription("Lifecycle overlay: " + lifecycleId);
                    LifecycleUtils.addMojoBinding((String)phase.getId(), (MojoBinding)binding, (LifecycleBindings)bindings);
                    phaseBindings.add(binding);
                }
            }
            if (phase.getConfiguration() == null) continue;
            for (MojoBinding binding : phaseBindings) {
                Xpp3Dom configuration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)new Xpp3Dom((Xpp3Dom)phase.getConfiguration()), (Xpp3Dom)((Xpp3Dom)binding.getConfiguration()));
                binding.setConfiguration((Object)configuration);
            }
        }
        return bindings;
    }

    public List getReportBindings(MavenProject project, MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException {
        if (project.getModel().getReports() != null) {
            this.logger.warn("Plugin contains a <reports/> section: this is IGNORED - please use <reporting/> instead.");
        }
        List reportPlugins = this.getReportPluginsForProject(project);
        ArrayList reports = new ArrayList();
        if (reportPlugins != null) {
            for (ReportPlugin reportPlugin : reportPlugins) {
                List reportSets = reportPlugin.getReportSets();
                if (reportSets == null || reportSets.isEmpty()) {
                    reports.addAll(this.getReportsForPlugin(reportPlugin, null, project, session));
                    continue;
                }
                for (ReportSet reportSet : reportSets) {
                    reports.addAll(this.getReportsForPlugin(reportPlugin, reportSet, project, session));
                }
            }
        }
        return reports;
    }

    private List getReportPluginsForProject(MavenProject project) {
        ArrayList<Object> reportPlugins = project.getReportPlugins();
        if (project.getReporting() == null || !project.getReporting().isExcludeDefaults()) {
            reportPlugins = reportPlugins == null ? new ArrayList<ReportPlugin>() : new ArrayList(reportPlugins);
            for (String report : this.defaultReports) {
                StringTokenizer tok = new StringTokenizer(report, ":");
                int count = tok.countTokens();
                if (count != 2 && count != 3) {
                    this.logger.warn("Invalid default report ignored: '" + report + "' (must be groupId:artifactId[:version])");
                    continue;
                }
                String groupId = tok.nextToken();
                String artifactId = tok.nextToken();
                String version = tok.hasMoreTokens() ? tok.nextToken() : null;
                boolean found = false;
                Iterator j = reportPlugins.iterator();
                while (j.hasNext() && !found) {
                    ReportPlugin reportPlugin = (ReportPlugin)j.next();
                    if (!reportPlugin.getGroupId().equals(groupId) || !reportPlugin.getArtifactId().equals(artifactId)) continue;
                    found = true;
                }
                if (found) continue;
                ReportPlugin reportPlugin = new ReportPlugin();
                reportPlugin.setGroupId(groupId);
                reportPlugin.setArtifactId(artifactId);
                reportPlugin.setVersion(version);
                reportPlugins.add(reportPlugin);
            }
        }
        return reportPlugins;
    }

    private List getReportsForPlugin(ReportPlugin reportPlugin, ReportSet reportSet, MavenProject project, MavenSession session) throws LifecycleLoaderException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginLoader.loadReportPlugin(reportPlugin, project, session);
        }
        catch (PluginLoaderException e) {
            throw new LifecycleLoaderException("Failed to load report plugin: " + reportPlugin.getKey() + ". Reason: " + e.getMessage(), (Throwable)e);
        }
        ArrayList<MojoBinding> reports = new ArrayList<MojoBinding>();
        for (MojoDescriptor mojoDescriptor : pluginDescriptor.getMojos()) {
            try {
                if (!this.isReport(mojoDescriptor)) {
                    continue;
                }
            }
            catch (ClassNotFoundException e) {
                throw new LifecycleLoaderException("Failed while verifying that mojo: " + mojoDescriptor.getId() + " is a report mojo. Reason: " + e.getMessage(), (Throwable)e);
            }
            if (reportSet != null && !reportSet.getReports().contains(mojoDescriptor.getGoal())) continue;
            String id = null;
            if (reportSet != null) {
                id = reportSet.getId();
            }
            MojoBinding binding = new MojoBinding();
            binding.setGroupId(pluginDescriptor.getGroupId());
            binding.setArtifactId(pluginDescriptor.getArtifactId());
            binding.setVersion(pluginDescriptor.getVersion());
            binding.setGoal(mojoDescriptor.getGoal());
            binding.setExecutionId(id);
            binding.setOrigin("POM");
            BindingUtils.injectProjectConfiguration(binding, project);
            reports.add(binding);
        }
        return reports;
    }

    private boolean isReport(MojoDescriptor mojoDescriptor) throws ClassNotFoundException {
        ClassRealm classRealm = mojoDescriptor.getPluginDescriptor().getClassRealm();
        String impl = mojoDescriptor.getImplementation();
        Class mojoClass = classRealm.loadClass(impl);
        Class reportClass = classRealm.loadClass(MavenReport.class.getName());
        return reportClass.isAssignableFrom(mojoClass);
    }

    public void resolveUnbindableMojos(Set unbindableMojos, MavenProject project, MavenSession session, LifecycleBindings lifecycleBindings) throws LifecycleSpecificationException {
        for (MojoBinding binding : unbindableMojos) {
            PluginDescriptor pluginDescriptor;
            try {
                pluginDescriptor = this.pluginLoader.loadPlugin(binding, project, session);
            }
            catch (PluginLoaderException e) {
                String message = "Failed to load plugin descriptor for: " + MojoBindingUtils.toString((MojoBinding)binding) + ". Cannot discover it's default phase, specified in its plugin descriptor.";
                throw new LifecycleSpecificationException(message, (Throwable)e);
            }
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(binding.getGoal());
            if (mojoDescriptor == null) {
                throw new LifecycleSpecificationException("Cannot find mojo descriptor for goal: " + binding.getGoal() + " in plugin: " + pluginDescriptor.getPluginLookupKey());
            }
            String phase = mojoDescriptor.getPhase();
            if (phase == null) {
                throw new LifecycleSpecificationException("Mojo descriptor: " + mojoDescriptor.getFullGoalName() + " doesn't have a default lifecycle phase. Please specify a <phase/> for this goal in your POM.");
            }
            LifecycleUtils.addMojoBinding((String)phase, (MojoBinding)binding, (LifecycleBindings)lifecycleBindings);
        }
    }
}

