/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.plan;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleLoaderException;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.MojoBindingUtils;
import org.apache.maven.lifecycle.binding.LifecycleBindingManager;
import org.apache.maven.lifecycle.binding.MojoBindingFactory;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.plan.BuildPlan;
import org.apache.maven.lifecycle.plan.BuildPlanner;
import org.apache.maven.lifecycle.plan.LifecyclePlannerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.loader.PluginLoader;
import org.apache.maven.plugin.loader.PluginLoaderException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=BuildPlanner.class)
public class DefaultBuildPlanner
implements BuildPlanner,
LogEnabled {
    @Requirement
    private PluginLoader pluginLoader;
    @Requirement
    private LifecycleBindingManager lifecycleBindingManager;
    @Requirement
    private MojoBindingFactory mojoBindingFactory;
    private Logger logger;

    public void constructInitialProjectBuildPlans(MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException, LifecyclePlannerException {
        for (MavenProject project : session.getSortedProjects()) {
            this.constructInitialProjectBuildPlan(project, session);
        }
    }

    public BuildPlan constructInitialProjectBuildPlan(MavenProject project, MavenSession session) throws LifecycleLoaderException, LifecycleSpecificationException, LifecyclePlannerException {
        BuildPlan plan = session.getBuildPlan(project);
        if (plan == null) {
            plan = this.constructBuildPlan(Collections.EMPTY_LIST, project, session, true);
            session.setBuildPlan(project, plan);
        }
        return plan;
    }

    public BuildPlan constructBuildPlan(List tasks, MavenProject project, MavenSession session, boolean allowUnbindableMojos) throws LifecycleLoaderException, LifecycleSpecificationException, LifecyclePlannerException {
        BuildPlan plan = session.getBuildPlan(project);
        boolean pluginResolutionAttempted = false;
        if (plan != null) {
            plan = plan.copy(tasks);
        } else {
            LifecycleBindings defaultBindings = this.lifecycleBindingManager.getDefaultBindings(project);
            LifecycleBindings packagingBindings = this.lifecycleBindingManager.getBindingsForPackaging(project, session);
            HashSet unbindableMojos = new HashSet();
            LifecycleBindings projectBindings = this.lifecycleBindingManager.getProjectCustomBindings(project, session, unbindableMojos);
            plan = new BuildPlan(packagingBindings, projectBindings, defaultBindings, unbindableMojos, tasks);
            pluginResolutionAttempted = true;
        }
        if (!(pluginResolutionAttempted && allowUnbindableMojos || !plan.hasUnbindableMojos())) {
            this.lifecycleBindingManager.resolveUnbindableMojos(plan.getUnbindableMojos(), project, session, plan.getLifecycleBindings());
            plan.clearUnbindableMojos();
        }
        this.initializeDirectInvocations(plan, project, session);
        this.addForkedLifecycleModifiers(plan, project, session, new LinkedList(), allowUnbindableMojos);
        this.addReportingLifecycleModifiers(plan, project, session, new LinkedList(), allowUnbindableMojos);
        plan.markFullyResolved();
        return plan;
    }

    private void initializeDirectInvocations(BuildPlan plan, MavenProject project, MavenSession session) throws LifecycleSpecificationException, LifecycleLoaderException {
        List tasks = plan.getTasks();
        for (String task : tasks) {
            if (LifecycleUtils.isValidPhaseName((String)task)) continue;
            MojoBinding binding = this.mojoBindingFactory.parseMojoBinding(task, project, session, true);
            binding.setOrigin("Direct invocation");
            binding.setOriginDescription("Original reference from user: " + task);
            plan.addDirectInvocationBinding(task, binding);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    private void addForkedLifecycleModifiers(BuildPlan plan, MavenProject project, MavenSession session, LinkedList callStack, boolean allowUnbindableMojos) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        List planBindings = plan.renderExecutionPlan(new Stack());
        plan.resetExecutionProgress();
        for (MojoBinding mojoBinding : planBindings) {
            if (plan.isFullyResolved(mojoBinding)) continue;
            this.findForkModifiers(mojoBinding, plan, project, session, callStack, allowUnbindableMojos);
        }
    }

    private void findForkModifiers(MojoBinding mojoBinding, BuildPlan plan, MavenProject project, MavenSession session, LinkedList callStack, boolean allowUnbindableMojos) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        PluginDescriptor pluginDescriptor = this.loadPluginDescriptor(mojoBinding, plan, project, session, allowUnbindableMojos);
        if (pluginDescriptor == null) {
            return;
        }
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(mojoBinding.getGoal());
        if (mojoDescriptor == null) {
            throw new LifecyclePlannerException("Mojo: " + mojoBinding.getGoal() + " does not exist in plugin: " + pluginDescriptor.getId() + ".");
        }
        this.findForkModifiers(mojoBinding, pluginDescriptor, plan, project, session, callStack, false, allowUnbindableMojos);
    }

    private void addReportingLifecycleModifiers(BuildPlan plan, MavenProject project, MavenSession session, LinkedList callStack, boolean allowUnbindableMojos) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        if (plan.isIncludingReports()) {
            this.logger.debug("Report modifiers are already present in the build plan.");
            return;
        }
        List planBindings = plan.renderExecutionPlan(new Stack());
        plan.resetExecutionProgress();
        for (MojoBinding mojoBinding : planBindings) {
            if (plan.isFullyResolved(mojoBinding)) {
                this.logger.debug("Skipping report-discovery for mojo: " + MojoBindingUtils.toString((MojoBinding)mojoBinding) + "; it is already fully resolved in the build plan.");
                continue;
            }
            PluginDescriptor pluginDescriptor = this.loadPluginDescriptor(mojoBinding, plan, project, session, allowUnbindableMojos);
            if (pluginDescriptor == null) {
                this.logger.debug("Plugin descriptor not found for mojo: " + MojoBindingUtils.toString((MojoBinding)mojoBinding) + "; skipping for report-discovery.");
                continue;
            }
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(mojoBinding.getGoal());
            if (mojoDescriptor == null) {
                throw new LifecyclePlannerException("Mojo: " + mojoBinding.getGoal() + " does not exist in plugin: " + pluginDescriptor.getId() + ".");
            }
            if (!mojoDescriptor.isRequiresReports()) continue;
            this.logger.debug("Mojo: " + MojoBindingUtils.toString((MojoBinding)mojoBinding) + " requires reports; running report-discovery.");
            List reportBindings = this.lifecycleBindingManager.getReportBindings(project, session);
            if (reportBindings != null) {
                plan.addForkedExecution(mojoBinding, reportBindings);
                for (MojoBinding reportBinding : reportBindings) {
                    PluginDescriptor pd;
                    if (plan.isFullyResolved(reportBinding) || (pd = this.loadPluginDescriptor(reportBinding, plan, project, session, allowUnbindableMojos)) == null) continue;
                    this.findForkModifiers(reportBinding, pd, plan, project, session, callStack, true, allowUnbindableMojos);
                }
            }
            plan.markAsIncludingReports();
            break;
        }
    }

    private PluginDescriptor loadPluginDescriptor(MojoBinding mojoBinding, BuildPlan plan, MavenProject project, MavenSession session, boolean allowUnbindableMojos) throws LifecyclePlannerException {
        PluginDescriptor pluginDescriptor = null;
        try {
            pluginDescriptor = this.pluginLoader.loadPlugin(mojoBinding, project, session);
        }
        catch (PluginLoaderException e) {
            if (allowUnbindableMojos) {
                String message = "Failed to load plugin: " + MojoBindingUtils.createPluginKey((MojoBinding)mojoBinding) + ". Adding to late-bound plugins list.\nReason: " + e.getMessage();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(message, (Throwable)e);
                } else {
                    this.logger.warn(message);
                }
                plan.addUnbindableMojo(mojoBinding);
            }
            throw new LifecyclePlannerException("Failed to resolve plugin for mojo binding: " + MojoBindingUtils.toString((MojoBinding)mojoBinding), e);
        }
        return pluginDescriptor;
    }

    private void findForkModifiers(MojoBinding mojoBinding, PluginDescriptor pluginDescriptor, BuildPlan plan, MavenProject project, MavenSession session, LinkedList callStack, boolean includeReportConfig, boolean allowUnbindableMojos) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        String referencingGoal = mojoBinding.getGoal();
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(referencingGoal);
        if (mojoDescriptor == null) {
            throw new LifecyclePlannerException("Cannot find mojo descriptor for: " + referencingGoal + " in plugin: " + pluginDescriptor.getId());
        }
        if (mojoDescriptor.getExecuteGoal() != null) {
            this.recurseSingleMojoFork(mojoBinding, pluginDescriptor, plan, project, includeReportConfig);
        } else if (mojoDescriptor.getExecutePhase() != null) {
            this.recursePhaseMojoFork(mojoBinding, pluginDescriptor, plan, project, session, callStack, includeReportConfig, allowUnbindableMojos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recursePhaseMojoFork(MojoBinding mojoBinding, PluginDescriptor pluginDescriptor, BuildPlan plan, MavenProject project, MavenSession session, LinkedList callStack, boolean includeReportConfig, boolean allowUnbindableMojos) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        callStack.addFirst(mojoBinding);
        try {
            String referencingGoal = mojoBinding.getGoal();
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(referencingGoal);
            String phase = mojoDescriptor.getExecutePhase();
            if (phase == null) {
                Object var17_12 = null;
                callStack.removeFirst();
                return;
            }
            if (!LifecycleUtils.isValidPhaseName((String)phase)) {
                throw new LifecyclePlannerException("Cannot find lifecycle for phase: " + phase);
            }
            BuildPlan clonedPlan = plan.copy(phase);
            clonedPlan.removeAll(callStack);
            String executeLifecycle = mojoDescriptor.getExecuteLifecycle();
            if (executeLifecycle != null) {
                LifecycleBindings overlayBindings;
                try {
                    overlayBindings = this.lifecycleBindingManager.getPluginLifecycleOverlay(pluginDescriptor, executeLifecycle, project);
                }
                catch (LifecycleLoaderException e) {
                    throw new LifecyclePlannerException("Failed to load overlay lifecycle: " + executeLifecycle + ". Reason: " + e.getMessage(), e);
                }
                clonedPlan.addLifecycleOverlay(overlayBindings);
            }
            plan.addForkedExecution(mojoBinding, clonedPlan);
            this.addForkedLifecycleModifiers(clonedPlan, project, session, callStack, allowUnbindableMojos);
        }
        catch (Throwable throwable) {
            Object var17_14 = null;
            callStack.removeFirst();
            throw throwable;
        }
        Object var17_13 = null;
        callStack.removeFirst();
    }

    private void recurseSingleMojoFork(MojoBinding mojoBinding, PluginDescriptor pluginDescriptor, BuildPlan plan, MavenProject project, boolean includeReportConfig) throws LifecyclePlannerException, LifecycleSpecificationException, LifecycleLoaderException {
        String referencingGoal = mojoBinding.getGoal();
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(referencingGoal);
        String executeGoal = mojoDescriptor.getExecuteGoal();
        if (executeGoal == null) {
            return;
        }
        MojoDescriptor otherDescriptor = pluginDescriptor.getMojo(executeGoal);
        if (otherDescriptor == null) {
            throw new LifecyclePlannerException("Mojo: " + executeGoal + " (referenced by: " + referencingGoal + ") does not exist in plugin: " + pluginDescriptor.getId() + ".");
        }
        MojoBinding binding = this.mojoBindingFactory.createMojoBinding(pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), pluginDescriptor.getVersion(), executeGoal, project);
        binding.setOrigin("Direct forking reference");
        binding.setOriginDescription("Forked from: " + MojoBindingUtils.toString((MojoBinding)mojoBinding));
        plan.addForkedExecution(mojoBinding, Collections.singletonList(binding));
    }
}

