/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.listeners.MavenModelEventListener;
import org.apache.maven.project.builder.ArtifactModelContainerFactory;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.shared.model.DataSourceException;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelContainerFactory;
import org.apache.maven.shared.model.ModelProperty;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.plexus.plugin.manager.PlexusPluginManager;
import org.sonatype.plexus.plugin.manager.PluginMetadata;
import org.sonatype.plexus.plugin.manager.PluginResolutionRequest;
import org.sonatype.plexus.plugin.manager.PluginResolutionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MavenModelEventListener.class, hint="extensions", instantiationStrategy="per-lookup")
public class BuildExtensionListener
implements MavenModelEventListener {
    @Configuration(value="true")
    private boolean inBuild = true;
    @Requirement
    PlexusPluginManager pluginManager;
    private List<BuildExtension> buildExtensions = new ArrayList<BuildExtension>();

    public void fire(List<? extends ModelContainer> modelContainers) throws DataSourceException {
        if (!this.inBuild) {
            return;
        }
        for (ModelContainer modelContainer : modelContainers) {
            if (!BuildExtensionListener.hasExtension(modelContainer)) continue;
            this.buildExtensions.add(new BuildExtension(modelContainer.getProperties()));
        }
    }

    public List<String> getUris() {
        return Arrays.asList(ProjectUri.Build.Extensions.Extension.xUri);
    }

    public Collection<ModelContainerFactory> getModelContainerFactories() {
        return Arrays.asList(new ArtifactModelContainerFactory());
    }

    private static boolean hasExtension(ModelContainer container) {
        for (ModelProperty mp : container.getProperties()) {
            if (!mp.getUri().equals(ProjectUri.Build.Extensions.Extension.xUri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processModelContainers(MavenSession session) {
        for (BuildExtension be : this.buildExtensions) {
            PluginResolutionRequest request = new PluginResolutionRequest().setPluginMetadata(new PluginMetadata(be.groupId, be.artifactId, be.version)).addLocalRepository(session.getRequest().getLocalRepositoryPath()).setRemoteRepositories(this.convertToMercuryRepositories(session.getRequest().getRemoteRepositories()));
            PluginResolutionResult result = null;
            try {
                result = this.pluginManager.resolve(request);
                ClassRealm realm = this.pluginManager.createClassRealm(result.getArtifacts());
                realm.display();
                List components = this.pluginManager.discoverComponents(realm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    List<String> convertToMercuryRepositories(List<ArtifactRepository> repositories) {
        ArrayList<String> repos = new ArrayList<String>();
        if (repositories != null) {
            for (ArtifactRepository r : repositories) {
                repos.add(r.getUrl());
            }
        } else {
            repos.add("http://repo1.maven.org/maven2");
        }
        return repos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildExtension {
        private String groupId;
        private String artifactId;
        private String version;

        public BuildExtension(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        BuildExtension(List<ModelProperty> modelProperties) {
            for (ModelProperty mp : modelProperties) {
                if (mp.getUri().equals(ProjectUri.Build.Extensions.Extension.groupId)) {
                    this.groupId = mp.getValue();
                    continue;
                }
                if (mp.getUri().equals(ProjectUri.Build.Extensions.Extension.artifactId)) {
                    this.artifactId = mp.getValue();
                    continue;
                }
                if (!mp.getUri().equals(ProjectUri.Build.Extensions.Extension.version)) continue;
                this.version = mp.getValue();
            }
        }
    }
}

