/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.monitor.event;

import org.apache.maven.monitor.event.AbstractSelectiveEventMonitor;
import org.apache.maven.monitor.event.MavenEvents;
import org.codehaus.plexus.logging.Logger;

public class DefaultEventMonitor
extends AbstractSelectiveEventMonitor {
    private static final String[] START_EVENTS = new String[]{"project-execute", "phase-execute", "mojo-execute"};
    private static final String[] END_EVENTS = new String[]{"phase-execute"};
    private final Logger logger;

    public DefaultEventMonitor(Logger logger) {
        super(START_EVENTS, END_EVENTS, MavenEvents.NO_EVENTS);
        this.logger = logger;
    }

    protected void doStartEvent(String event, String target, long time) {
        if ("mojo-execute".equals(event)) {
            this.logger.info("[" + target + "]");
        } else if ("phase-execute".equals(event)) {
            this.logger.debug(this.line());
            this.logger.debug("Entering lifecycle phase: " + target);
            this.logger.debug(this.line());
        } else if ("project-execute".equals(event)) {
            this.logger.info(this.line());
            String[] targetParts = target.split("\n");
            this.logger.info("Building " + targetParts[0]);
            if (targetParts.length > 0) {
                this.logger.info("");
                for (int i = 1; i < targetParts.length; ++i) {
                    this.logger.info(targetParts[i]);
                }
            }
            this.logger.info(this.line());
        }
    }

    protected void doEndEvent(String event, String target, long timestamp) {
        this.logger.debug(this.line());
        this.logger.debug("Completed lifecycle phase: " + target);
        this.logger.debug(this.line());
    }

    private String line() {
        return "------------------------------------------------------------------------";
    }
}

