/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.ArtifactFilterManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.DebugConfigurationListener;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MavenPluginCollector;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginManagerSupport;
import org.apache.maven.plugin.PluginMappingManager;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginParameterException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.version.PluginVersionManager;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.project.builder.Interpolator;
import org.apache.maven.project.builder.PomInterpolatorTag;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.realm.MavenRealmManager;
import org.apache.maven.realm.RealmManagementException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginManager.class)
public class DefaultPluginManager
extends AbstractLogEnabled
implements PluginManager {
    private static final List RESERVED_GROUP_IDS;
    @Requirement
    protected PlexusContainer container;
    protected PluginDescriptorBuilder pluginDescriptorBuilder = new PluginDescriptorBuilder();
    @Requirement
    protected ArtifactFilterManager coreArtifactFilterManager;
    @Requirement
    protected PathTranslator pathTranslator;
    @Requirement
    protected MavenPluginCollector pluginCollector;
    @Requirement
    protected PluginVersionManager pluginVersionManager;
    @Requirement
    protected ArtifactFactory artifactFactory;
    @Requirement
    protected ArtifactResolver artifactResolver;
    @Requirement
    protected ArtifactMetadataSource artifactMetadataSource;
    @Requirement
    protected RuntimeInformation runtimeInformation;
    @Requirement
    protected MavenProjectBuilder mavenProjectBuilder;
    @Requirement
    protected PluginMappingManager pluginMappingManager;
    @Requirement
    private PluginManagerSupport pluginManagerSupport;

    @Override
    public Plugin getPluginDefinitionForPrefix(String prefix, MavenSession session, MavenProject project) {
        return this.pluginMappingManager.getByPrefix(prefix, session.getPluginGroups(), project.getRemoteArtifactRepositories(), session.getLocalRepository());
    }

    @Override
    public PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, MavenSession session) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        String pluginVersion = plugin.getVersion();
        this.getLogger().debug("Resolving plugin: " + plugin.getKey() + " with version: " + pluginVersion);
        if (pluginVersion == null || "LATEST".equals(pluginVersion) || "RELEASE".equals(pluginVersion)) {
            this.getLogger().debug("Resolving version for plugin: " + plugin.getKey());
            pluginVersion = this.pluginVersionManager.resolvePluginVersion(plugin.getGroupId(), plugin.getArtifactId(), project, session);
            plugin.setVersion(pluginVersion);
            this.getLogger().debug("Resolved to version: " + pluginVersion);
        }
        return this.verifyVersionedPlugin(plugin, project, session);
    }

    private PluginDescriptor verifyVersionedPlugin(Plugin plugin, MavenProject project, MavenSession session) throws PluginVersionResolutionException, ArtifactNotFoundException, ArtifactResolutionException, InvalidPluginException, PluginManagerException, PluginNotFoundException {
        this.getLogger().debug("In verifyVersionedPlugin for: " + plugin.getKey());
        ArtifactRepository localRepository = session.getLocalRepository();
        try {
            if (!RESERVED_GROUP_IDS.contains(plugin.getGroupId())) {
                Artifact pluginArtifact = this.pluginManagerSupport.resolvePluginArtifact(plugin, project, session);
                this.addPlugin(plugin, pluginArtifact, project, session);
            } else {
                this.getLogger().debug("Skipping resolution for Maven built-in plugin: " + plugin.getKey());
            }
            project.addPlugin(plugin);
        }
        catch (ArtifactNotFoundException e) {
            String groupId = plugin.getGroupId();
            String artifactId = plugin.getArtifactId();
            String version = plugin.getVersion();
            if (groupId == null || artifactId == null || version == null) {
                throw new PluginNotFoundException(plugin, e);
            }
            if (groupId.equals(e.getGroupId()) && artifactId.equals(e.getArtifactId()) && version.equals(e.getVersion()) && "maven-plugin".equals(e.getType())) {
                throw new PluginNotFoundException(plugin, e);
            }
            throw e;
        }
        PluginDescriptor pluginDescriptor = this.pluginCollector.getPluginDescriptor(plugin);
        this.setDescriptorClassAndArtifactInfo(pluginDescriptor, project, session, new ArrayList());
        return pluginDescriptor;
    }

    protected void addPlugin(Plugin plugin, Artifact pluginArtifact, MavenProject project, MavenSession session) throws ArtifactNotFoundException, ArtifactResolutionException, PluginManagerException, InvalidPluginException {
        Plugin projectPlugin = project.getPlugin(plugin.getKey());
        if (projectPlugin == null) {
            projectPlugin = plugin;
        } else if (projectPlugin.getVersion() == null || "RELEASE".equals(projectPlugin.getVersion()) || "LATEST".equals(projectPlugin.getVersion())) {
            projectPlugin.setVersion(plugin.getVersion());
        }
        Set<Artifact> artifactSet = this.getPluginArtifacts(pluginArtifact, projectPlugin, project, session.getLocalRepository());
        ArrayList<Artifact> artifacts = artifactSet == null || artifactSet.isEmpty() ? new ArrayList<Artifact>() : new ArrayList<Artifact>(artifactSet);
        this.getLogger().debug("Got plugin artifacts:\n\n" + artifacts);
        MavenRealmManager realmManager = session.getRealmManager();
        ClassRealm pluginRealm = realmManager.getPluginRealm(projectPlugin);
        if (pluginRealm == null) {
            try {
                pluginRealm = realmManager.createPluginRealm(projectPlugin, pluginArtifact, artifacts, this.coreArtifactFilterManager.getArtifactFilter());
                this.getLogger().debug("Created realm: " + pluginRealm + " for plugin: " + projectPlugin.getKey());
            }
            catch (RealmManagementException e) {
                throw new PluginContainerException(plugin, "Failed to create realm for plugin '" + projectPlugin, e);
            }
            try {
                this.getLogger().debug("Discovering components in realm: " + pluginRealm);
                this.container.discoverComponents(pluginRealm);
            }
            catch (PlexusConfigurationException e) {
                throw new PluginContainerException(plugin, pluginRealm, "Error scanning plugin realm for components.", e);
            }
            catch (ComponentRepositoryException e) {
                throw new PluginContainerException(plugin, pluginRealm, "Error scanning plugin realm for components.", e);
            }
            this.getLogger().debug("Checking for plugin descriptor for: " + projectPlugin.getKey() + " with version: " + projectPlugin.getVersion() + " in collector: " + this.pluginCollector);
            PluginDescriptor pluginDescriptor = this.pluginCollector.getPluginDescriptor(projectPlugin);
            if (pluginDescriptor == null) {
                if (pluginRealm != null && this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Plugin Realm: ");
                    pluginRealm.display();
                }
                this.getLogger().debug("Removing invalid plugin realm.");
                realmManager.disposePluginRealm(projectPlugin);
                throw new PluginManagerException(projectPlugin, "The PluginDescriptor for the plugin " + projectPlugin.getKey() + " was not found. Should have been in realm: " + pluginRealm, project);
            }
            pluginDescriptor.setPluginArtifact(pluginArtifact);
            this.getLogger().debug("Realm for plugin: " + plugin.getKey() + ":\n" + pluginRealm);
        } else {
            List managedPluginArtifacts = realmManager.getPluginArtifacts(projectPlugin);
            if (managedPluginArtifacts == null || managedPluginArtifacts.isEmpty() && !artifacts.isEmpty()) {
                realmManager.setPluginArtifacts(projectPlugin, artifacts);
            }
        }
    }

    private Set<Artifact> getPluginArtifacts(Artifact pluginArtifact, Plugin plugin, MavenProject project, ArtifactRepository localRepository) throws InvalidPluginException, ArtifactNotFoundException, ArtifactResolutionException {
        ResolutionGroup resolutionGroup;
        Set projectPluginDependencies;
        ScopeArtifactFilter filter = new ScopeArtifactFilter(Artifact.SCOPE_RUNTIME_PLUS_SYSTEM);
        try {
            projectPluginDependencies = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)plugin.getDependencies(), null, (ArtifactFilter)this.coreArtifactFilterManager.getCoreArtifactFilter(), (MavenProject)project);
        }
        catch (InvalidDependencyVersionException e) {
            throw new InvalidPluginException("Plugin '" + plugin + "' is invalid: " + e.getMessage(), e);
        }
        try {
            resolutionGroup = this.artifactMetadataSource.retrieve(pluginArtifact, localRepository, project.getRemoteArtifactRepositories());
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new ArtifactResolutionException("Unable to download metadata from repository for plugin '" + pluginArtifact.getId() + "': " + e.getMessage(), pluginArtifact, e);
        }
        Map pluginManagedDependencies = new HashMap();
        try {
            MavenProject pluginProject = this.mavenProjectBuilder.buildFromRepository(pluginArtifact, project.getRemoteArtifactRepositories(), localRepository);
            if (pluginProject != null) {
                pluginManagedDependencies = pluginProject.getManagedVersionMap();
            }
        }
        catch (ProjectBuildingException e) {
            // empty catch block
        }
        LinkedHashSet dependencies = new LinkedHashSet();
        dependencies.addAll(projectPluginDependencies);
        dependencies.addAll(resolutionGroup.getArtifacts());
        LinkedHashSet repositories = new LinkedHashSet();
        repositories.addAll(resolutionGroup.getResolutionRepositories());
        repositories.addAll(project.getRemoteArtifactRepositories());
        ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencies, pluginArtifact, pluginManagedDependencies, localRepository, repositories.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(repositories), this.artifactMetadataSource, (ArtifactFilter)filter);
        LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>();
        for (Artifact artifact : result.getArtifacts()) {
            if (!artifact.equals(pluginArtifact)) {
                artifact = project.replaceWithActiveArtifact(artifact);
            }
            resolved.add(artifact);
        }
        this.getLogger().debug("Using the following artifacts for classpath of: " + pluginArtifact.getId() + ":\n\n" + ((Object)resolved).toString().replace(',', '\n'));
        return resolved;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public void executeMojo(MavenProject project, MojoExecution mojoExecution, MavenSession session) throws ArtifactResolutionException, MojoFailureException, ArtifactNotFoundException, InvalidDependencyVersionException, PluginManagerException, PluginConfigurationException {
        ClassLoader oldClassLoader;
        block31: {
            ArrayList realmActions;
            ClassRealm oldLookupRealm;
            String goalExecId;
            String event;
            PluginDescriptor pluginDescriptor;
            Mojo mojo;
            MojoDescriptor mojoDescriptor;
            block30: {
                mojoDescriptor = mojoExecution.getMojoDescriptor();
                if (mojoDescriptor.isProjectRequired() && !session.isUsingPOMsFromFilesystem()) {
                    throw new PluginExecutionException(mojoExecution, project, "Cannot execute mojo: " + mojoDescriptor.getGoal() + ". It requires a project with an existing pom.xml, but the build is not using one.");
                }
                if (mojoDescriptor.isOnlineRequired() && session.isOffline()) {
                    throw new PluginExecutionException(mojoExecution, project, "Mojo: " + mojoDescriptor.getGoal() + " requires online mode for execution. Maven is currently offline.");
                }
                if (mojoDescriptor.getDeprecated() != null) {
                    this.getLogger().warn("Mojo: " + mojoDescriptor.getGoal() + " is deprecated.\n" + mojoDescriptor.getDeprecated());
                }
                Model model = project.getModel();
                this.pathTranslator.alignToBaseDirectory(model, project.getBasedir());
                project.setBuild(model.getBuild());
                if (mojoDescriptor.isDependencyResolutionRequired() != null) {
                    Collection<Object> projects = mojoDescriptor.isAggregator() ? session.getSortedProjects() : Collections.singleton(project);
                    for (MavenProject p : projects) {
                        this.resolveTransitiveDependencies(session, this.artifactResolver, mojoDescriptor.isDependencyResolutionRequired(), this.artifactFactory, p, mojoDescriptor.isAggregator());
                    }
                    this.downloadDependencies(project, session, this.artifactResolver);
                }
                String goalName = mojoDescriptor.getFullGoalName();
                mojo = null;
                pluginDescriptor = mojoDescriptor.getPluginDescriptor();
                Xpp3Dom dom = mojoExecution.getConfiguration();
                if (dom != null) {
                    try {
                        ArrayList interpolatorProperties = new ArrayList();
                        interpolatorProperties.addAll(InterpolatorProperty.toInterpolatorProperties((Properties)session.getProjectBuilderConfiguration().getExecutionProperties(), (String)PomInterpolatorTag.EXECUTION_PROPERTIES.name()));
                        interpolatorProperties.addAll(InterpolatorProperty.toInterpolatorProperties((Properties)session.getProjectBuilderConfiguration().getUserProperties(), (String)PomInterpolatorTag.USER_PROPERTIES.name()));
                        String interpolatedDom = Interpolator.interpolateXmlString((String)String.valueOf(dom), interpolatorProperties);
                        dom = Xpp3DomBuilder.build((Reader)new StringReader(interpolatedDom));
                    }
                    catch (XmlPullParserException e) {
                        throw new PluginManagerException(mojoDescriptor, project, "Failed to calculate concrete state for configuration of: " + mojoDescriptor.getHumanReadableKey(), (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new PluginManagerException(mojoDescriptor, project, "Failed to calculate concrete state for configuration of: " + mojoDescriptor.getHumanReadableKey(), (Throwable)e);
                    }
                }
                event = "mojo-execute";
                EventDispatcher dispatcher = session.getEventDispatcher();
                goalExecId = goalName;
                if (mojoExecution.getExecutionId() != null) {
                    goalExecId = goalExecId + " {execution: " + mojoExecution.getExecutionId() + "}";
                }
                ClassRealm pluginRealm = null;
                oldLookupRealm = this.container.getLookupRealm();
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                realmActions = new ArrayList();
                mojo = this.getConfiguredMojo(session, dom, project, false, mojoExecution, realmActions);
                dispatcher.dispatchStart(event, goalExecId);
                pluginRealm = pluginDescriptor.getClassRealm();
                this.getLogger().debug("Setting context classloader for plugin to: " + pluginRealm.getId() + " (instance is: " + pluginRealm + ")");
                Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
                try {
                    mojo.execute();
                }
                catch (DuplicateArtifactAttachmentException e) {
                    session.getEventDispatcher().dispatchError(event, goalExecId, e);
                    throw new PluginExecutionException(mojoExecution, project, e);
                }
                if (mojo instanceof MavenReport) {
                    session.addReport(mojoDescriptor, (MavenReport)mojo);
                }
                dispatcher.dispatchEnd(event, goalExecId);
                Object var22_23 = null;
                if (mojo == null) break block30;
                try {
                    this.container.release((Object)mojo);
                }
                catch (ComponentLifecycleException e) {
                    this.getLogger().debug("Error releasing mojo for: " + goalExecId, (Throwable)e);
                }
            }
            pluginDescriptor.setClassRealm(null);
            pluginDescriptor.setArtifacts(null);
            for (PluginRealmAction action : realmActions) {
                action.undo();
            }
            if (oldLookupRealm != null) {
                this.container.setLookupRealm(null);
            }
            break block31;
            {
                catch (MojoExecutionException e) {
                    session.getEventDispatcher().dispatchError(event, goalExecId, e);
                    throw new PluginExecutionException(mojoExecution, project, e);
                }
                catch (MojoFailureException e) {
                    session.getEventDispatcher().dispatchError(event, goalExecId, e);
                    throw e;
                }
                catch (LinkageError e) {
                    if (this.getLogger().isFatalErrorEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(mojoDescriptor.getImplementation()).append("#execute() caused a linkage error (");
                        sb.append(e.getClass().getName()).append("). Check the realms:");
                        ClassRealm r = pluginDescriptor.getClassRealm();
                        sb.append("\n\nNOTE:\nPlugin realm is: ").append(r.getId());
                        sb.append("\nContainer realm is: ").append(this.container.getContainerRealm().getId());
                        sb.append("\n\n");
                        do {
                            sb.append("Realm ID: ").append(r.getId()).append('\n');
                            for (int i = 0; i < r.getURLs().length; ++i) {
                                sb.append("urls[").append(i).append("] = ").append(r.getURLs()[i]);
                                if (i == r.getURLs().length - 1) continue;
                                sb.append('\n');
                            }
                            sb.append("\n\n");
                        } while ((r = r.getParentRealm()) != null);
                        this.getLogger().fatalError(sb.toString(), (Throwable)e);
                    }
                    session.getEventDispatcher().dispatchError(event, goalExecId, e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var22_24 = null;
                if (mojo != null) {
                    try {
                        this.container.release((Object)mojo);
                    }
                    catch (ComponentLifecycleException e) {
                        this.getLogger().debug("Error releasing mojo for: " + goalExecId, (Throwable)e);
                    }
                }
                pluginDescriptor.setClassRealm(null);
                pluginDescriptor.setArtifacts(null);
                for (PluginRealmAction action : realmActions) {
                    action.undo();
                }
                if (oldLookupRealm != null) {
                    this.container.setLookupRealm(null);
                }
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                throw throwable;
            }
        }
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    private Plugin createDummyPlugin(PluginDescriptor pluginDescriptor) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(pluginDescriptor.getGroupId());
        plugin.setArtifactId(pluginDescriptor.getArtifactId());
        plugin.setVersion(pluginDescriptor.getVersion());
        return plugin;
    }

    @Override
    public MavenReport getReport(MavenProject project, MojoExecution mojoExecution, MavenSession session) throws ArtifactNotFoundException, PluginConfigurationException, PluginManagerException, ArtifactResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor descriptor = mojoDescriptor.getPluginDescriptor();
        Xpp3Dom dom = project.getReportConfiguration(descriptor.getGroupId(), descriptor.getArtifactId(), mojoExecution.getExecutionId());
        if (mojoExecution.getConfiguration() != null) {
            dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)dom, (Xpp3Dom)mojoExecution.getConfiguration());
        }
        return (MavenReport)this.getConfiguredMojo(session, dom, project, true, mojoExecution, new ArrayList());
    }

    @Override
    public PluginDescriptor verifyReportPlugin(ReportPlugin reportPlugin, MavenProject project, MavenSession session) throws PluginVersionResolutionException, ArtifactResolutionException, ArtifactNotFoundException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        String version = reportPlugin.getVersion();
        if (version == null) {
            version = this.pluginVersionManager.resolveReportPluginVersion(reportPlugin.getGroupId(), reportPlugin.getArtifactId(), project, session);
            reportPlugin.setVersion(version);
        }
        Plugin forLookup = new Plugin();
        forLookup.setGroupId(reportPlugin.getGroupId());
        forLookup.setArtifactId(reportPlugin.getArtifactId());
        forLookup.setVersion(version);
        return this.verifyVersionedPlugin(forLookup, project, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mojo getConfiguredMojo(MavenSession session, Xpp3Dom dom, MavenProject project, boolean report, MojoExecution mojoExecution, List realmActions) throws PluginConfigurationException, PluginManagerException {
        Mojo mojo;
        ClassLoader oldClassLoader;
        PluginDescriptor pluginDescriptor;
        MojoDescriptor mojoDescriptor;
        block10: {
            Set reportDescriptors;
            mojoDescriptor = mojoExecution.getMojoDescriptor();
            pluginDescriptor = mojoDescriptor.getPluginDescriptor();
            this.setDescriptorClassAndArtifactInfo(pluginDescriptor, project, session, realmActions);
            ClassRealm pluginRealm = pluginDescriptor.getClassRealm();
            if (mojoDescriptor.isRequiresReports() && (reportDescriptors = session.getReportMojoDescriptors()) != null && !reportDescriptors.isEmpty()) {
                for (MojoDescriptor reportDescriptor : reportDescriptors) {
                    this.setDescriptorClassAndArtifactInfo(reportDescriptor.getPluginDescriptor(), project, session, realmActions);
                }
            }
            this.container.setLookupRealm(pluginRealm);
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
            try {
                this.getLogger().debug("Looking up mojo " + mojoDescriptor.getRoleHint() + " in realm " + pluginRealm.getId() + " - descRealmId=" + mojoDescriptor.getRealm());
                try {
                    mojo = (Mojo)this.container.lookup(Mojo.class, mojoDescriptor.getRoleHint());
                }
                catch (ComponentLookupException e) {
                    throw new PluginContainerException(mojoDescriptor, pluginRealm, "Unable to find the mojo '" + mojoDescriptor.getRoleHint() + "' in the plugin '" + pluginDescriptor.getPluginLookupKey() + "'", e);
                }
                if (mojo != null) {
                    this.getLogger().debug("Looked up - " + mojo + " - " + mojo.getClass().getClassLoader());
                } else {
                    this.getLogger().warn("No luck.");
                }
                if (!report || mojo instanceof MavenReport) break block10;
                Mojo e = null;
                Object var18_14 = null;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                return e;
            }
            catch (Throwable throwable) {
                Object var18_16 = null;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                throw throwable;
            }
        }
        if (mojo instanceof ContextEnabled) {
            Map pluginContext = session.getPluginContext(pluginDescriptor, project);
            pluginContext.put("project", project);
            pluginContext.put("pluginDescriptor", pluginDescriptor);
            ((ContextEnabled)mojo).setPluginContext(pluginContext);
        }
        mojo.setLog((Log)new DefaultLog(this.getLogger()));
        XmlPlexusConfiguration pomConfiguration = dom == null ? new XmlPlexusConfiguration("configuration") : new XmlPlexusConfiguration(dom);
        this.validatePomConfiguration(mojoDescriptor, (PlexusConfiguration)pomConfiguration);
        PlexusConfiguration mergedConfiguration = this.mergeMojoConfiguration(pomConfiguration, mojoDescriptor);
        PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution, this.pathTranslator, this.getLogger(), session.getExecutionProperties());
        PlexusConfiguration extractedMojoConfiguration = this.extractMojoConfiguration(mergedConfiguration, mojoDescriptor);
        this.checkDeprecatedParameters(mojoDescriptor, (PlexusConfiguration)pomConfiguration);
        this.checkRequiredParameters(mojoDescriptor, extractedMojoConfiguration, expressionEvaluator);
        this.populatePluginFields(mojo, mojoDescriptor, extractedMojoConfiguration, expressionEvaluator);
        Mojo mojo2 = mojo;
        Object var18_15 = null;
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        return mojo2;
    }

    private void checkDeprecatedParameters(MojoDescriptor mojoDescriptor, PlexusConfiguration extractedMojoConfiguration) {
        if (extractedMojoConfiguration == null || extractedMojoConfiguration.getChildCount() < 1) {
            return;
        }
        List parameters = mojoDescriptor.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            for (Parameter param : parameters) {
                if (param.getDeprecated() == null) continue;
                boolean warnOfDeprecation = false;
                PlexusConfiguration child = extractedMojoConfiguration.getChild(param.getName());
                try {
                    if (child != null && child.getValue() != null) {
                        warnOfDeprecation = true;
                    } else if (param.getAlias() != null && (child = extractedMojoConfiguration.getChild(param.getAlias())) != null && child.getValue() != null) {
                        warnOfDeprecation = true;
                    }
                }
                catch (PlexusConfigurationException e) {
                    // empty catch block
                }
                if (!warnOfDeprecation) continue;
                StringBuffer buffer = new StringBuffer();
                buffer.append("In mojo: ").append(mojoDescriptor.getGoal()).append(", parameter: ").append(param.getName());
                if (param.getAlias() != null) {
                    buffer.append(" (alias: ").append(param.getAlias()).append(")");
                }
                buffer.append(" is deprecated:").append("\n\n").append(param.getDeprecated()).append("\n");
                this.getLogger().warn(buffer.toString());
            }
        }
    }

    private void setDescriptorClassAndArtifactInfo(PluginDescriptor pluginDescriptor, MavenProject project, MavenSession session, List realmActions) {
        ClassRealm pluginRealm;
        Plugin plugin;
        MavenRealmManager realmManager = session.getRealmManager();
        ClassRealm projectRealm = realmManager.getProjectRealm(project.getGroupId(), project.getArtifactId(), project.getVersion());
        if (projectRealm == null) {
            this.getLogger().debug("Realm for project: " + project.getId() + " not found. Using container realm instead.");
            projectRealm = this.container.getContainerRealm();
        }
        if ((plugin = project.getPlugin(pluginDescriptor.getPluginLookupKey())) == null) {
            plugin = this.createDummyPlugin(pluginDescriptor);
        }
        if ((pluginRealm = realmManager.getPluginRealm(plugin)) == null) {
            this.getLogger().debug("Realm for plugin: " + pluginDescriptor.getId() + " not found. Using project realm instead.");
            pluginRealm = projectRealm;
            realmActions.add(new PluginRealmAction(pluginDescriptor));
        } else {
            pluginRealm.setParentRealm(projectRealm);
            realmActions.add(new PluginRealmAction(pluginDescriptor, pluginRealm));
        }
        this.getLogger().debug("Setting realm for plugin descriptor: " + pluginDescriptor.getId() + " to: " + pluginRealm);
        pluginDescriptor.setClassRealm(pluginRealm);
        pluginDescriptor.setArtifacts(realmManager.getPluginArtifacts(plugin));
    }

    private PlexusConfiguration extractMojoConfiguration(PlexusConfiguration mergedConfiguration, MojoDescriptor mojoDescriptor) {
        Map parameterMap = mojoDescriptor.getParameterMap();
        PlexusConfiguration[] mergedChildren = mergedConfiguration.getChildren();
        XmlPlexusConfiguration extractedConfiguration = new XmlPlexusConfiguration("configuration");
        for (int i = 0; i < mergedChildren.length; ++i) {
            PlexusConfiguration child = mergedChildren[i];
            if (parameterMap.containsKey(child.getName())) {
                extractedConfiguration.addChild(DefaultPluginManager.copyConfiguration(child));
                continue;
            }
            this.getLogger().debug("*** WARNING: Configuration '" + child.getName() + "' is not used in goal '" + mojoDescriptor.getFullGoalName() + "; this may indicate a typo... ***");
        }
        return extractedConfiguration;
    }

    private void checkRequiredParameters(MojoDescriptor goal, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        List parameters = goal.getParameters();
        if (parameters == null) {
            return;
        }
        ArrayList<Parameter> invalidParameters = new ArrayList<Parameter>();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            if (!parameter.isRequired()) continue;
            String key = parameter.getName();
            Object fieldValue = null;
            String expression = null;
            PlexusConfiguration value = configuration.getChild(key, false);
            try {
                if (value != null && (fieldValue = expressionEvaluator.evaluate(expression = value.getValue(null))) == null) {
                    fieldValue = value.getAttribute("default-value", null);
                }
                if (fieldValue == null && StringUtils.isNotEmpty((String)parameter.getAlias()) && (value = configuration.getChild(parameter.getAlias(), false)) != null && (fieldValue = expressionEvaluator.evaluate(expression = value.getValue(null))) == null) {
                    fieldValue = value.getAttribute("default-value", null);
                }
            }
            catch (ExpressionEvaluationException e) {
                throw new PluginConfigurationException(goal.getPluginDescriptor(), e.getMessage(), e);
            }
            if (fieldValue != null || value != null && value.getChildCount() != 0) continue;
            parameter.setExpression(expression);
            invalidParameters.add(parameter);
        }
        if (!invalidParameters.isEmpty()) {
            throw new PluginParameterException(goal, invalidParameters);
        }
    }

    private void validatePomConfiguration(MojoDescriptor goal, PlexusConfiguration pomConfiguration) throws PluginConfigurationException {
        List parameters = goal.getParameters();
        if (parameters == null) {
            return;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            String key = parameter.getName();
            PlexusConfiguration value = pomConfiguration.getChild(key, false);
            if (value == null && StringUtils.isNotEmpty((String)parameter.getAlias())) {
                key = parameter.getAlias();
                value = pomConfiguration.getChild(key, false);
            }
            if (value == null) continue;
            if (!parameter.isEditable()) {
                StringBuffer errorMessage = new StringBuffer().append("ERROR: Cannot override read-only parameter: ");
                errorMessage.append(key);
                errorMessage.append(" in goal: ").append(goal.getFullGoalName());
                throw new PluginConfigurationException(goal.getPluginDescriptor(), errorMessage.toString());
            }
            String deprecated = parameter.getDeprecated();
            if (!StringUtils.isNotEmpty((String)deprecated)) continue;
            this.getLogger().warn("DEPRECATED [" + parameter.getName() + "]: " + deprecated);
        }
    }

    private PlexusConfiguration mergeMojoConfiguration(XmlPlexusConfiguration fromPom, MojoDescriptor mojoDescriptor) {
        XmlPlexusConfiguration result = new XmlPlexusConfiguration(fromPom.getName());
        result.setValue(fromPom.getValue(null));
        if (mojoDescriptor.getParameters() != null) {
            PlexusConfiguration fromMojo = mojoDescriptor.getMojoConfiguration();
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                String paramName = parameter.getName();
                String alias = parameter.getAlias();
                String implementation = parameter.getImplementation();
                PlexusConfiguration pomConfig = fromPom.getChild(paramName);
                PlexusConfiguration aliased = null;
                if (alias != null) {
                    aliased = fromPom.getChild(alias);
                }
                PlexusConfiguration mojoConfig = fromMojo.getChild(paramName, false);
                if (aliased != null) {
                    if (pomConfig == null) {
                        pomConfig = new XmlPlexusConfiguration(paramName);
                    }
                    pomConfig = this.buildTopDownMergedConfiguration(pomConfig, aliased);
                }
                PlexusConfiguration toAdd = null;
                if (pomConfig != null && (StringUtils.isNotEmpty((String)(pomConfig = this.buildTopDownMergedConfiguration(pomConfig, mojoConfig)).getValue(null)) || pomConfig.getChildCount() > 0)) {
                    toAdd = pomConfig;
                }
                if (toAdd == null && mojoConfig != null) {
                    toAdd = DefaultPluginManager.copyConfiguration(mojoConfig);
                }
                if (toAdd == null) continue;
                if (implementation != null && toAdd.getAttribute("implementation", null) == null) {
                    XmlPlexusConfiguration implementationConf = new XmlPlexusConfiguration(paramName);
                    implementationConf.setAttribute("implementation", parameter.getImplementation());
                    toAdd = this.buildTopDownMergedConfiguration(toAdd, (PlexusConfiguration)implementationConf);
                }
                result.addChild(toAdd);
            }
        }
        return result;
    }

    private XmlPlexusConfiguration buildTopDownMergedConfiguration(PlexusConfiguration dominant, PlexusConfiguration recessive) {
        String attributeValue;
        int i;
        XmlPlexusConfiguration result = new XmlPlexusConfiguration(dominant.getName());
        String value = dominant.getValue(null);
        if (StringUtils.isEmpty((String)value) && recessive != null) {
            value = recessive.getValue(null);
        }
        if (StringUtils.isNotEmpty((String)value)) {
            result.setValue(value);
        }
        String[] attributeNames = dominant.getAttributeNames();
        for (i = 0; i < attributeNames.length; ++i) {
            attributeValue = dominant.getAttribute(attributeNames[i], null);
            result.setAttribute(attributeNames[i], attributeValue);
        }
        if (recessive != null) {
            attributeNames = recessive.getAttributeNames();
            for (i = 0; i < attributeNames.length; ++i) {
                attributeValue = recessive.getAttribute(attributeNames[i], null);
                result.setAttribute(attributeNames[i], attributeValue);
            }
        }
        PlexusConfiguration[] children = dominant.getChildren();
        for (int i2 = 0; i2 < children.length; ++i2) {
            PlexusConfiguration childRec;
            PlexusConfiguration childDom = children[i2];
            PlexusConfiguration plexusConfiguration = childRec = recessive == null ? null : recessive.getChild(childDom.getName(), false);
            if (childRec != null) {
                result.addChild((PlexusConfiguration)this.buildTopDownMergedConfiguration(childDom, childRec));
                continue;
            }
            result.addChild(DefaultPluginManager.copyConfiguration(childDom));
        }
        return result;
    }

    public static PlexusConfiguration copyConfiguration(PlexusConfiguration src) {
        XmlPlexusConfiguration dom = new XmlPlexusConfiguration(src.getName());
        dom.setValue(src.getValue(null));
        String[] attributeNames = src.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            dom.setAttribute(attributeName, src.getAttribute(attributeName, null));
        }
        PlexusConfiguration[] children = src.getChildren();
        for (int i = 0; i < children.length; ++i) {
            dom.addChild(DefaultPluginManager.copyConfiguration(children[i]));
        }
        return dom;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populatePluginFields(Mojo plugin, MojoDescriptor mojoDescriptor, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        ComponentConfigurator configurator = null;
        ClassRealm realm = mojoDescriptor.getPluginDescriptor().getClassRealm();
        String configuratorId = mojoDescriptor.getComponentConfigurator();
        configurator = StringUtils.isNotEmpty((String)configuratorId) ? (ComponentConfigurator)this.container.lookup(ComponentConfigurator.class, configuratorId) : (ComponentConfigurator)this.container.lookup(ComponentConfigurator.class, "basic");
        DebugConfigurationListener listener = new DebugConfigurationListener(this.getLogger());
        this.getLogger().debug("Configuring mojo '" + mojoDescriptor.getId() + "' with " + (configuratorId == null ? "basic" : configuratorId) + " configurator -->");
        configurator.configureComponent((Object)plugin, configuration, expressionEvaluator, realm, (ConfigurationListener)listener);
        this.getLogger().debug("-- end configuration --");
        Object var13_13 = null;
        if (configurator == null) return;
        try {
            this.container.release((Object)configurator);
            return;
        }
        catch (ComponentLifecycleException e) {
            this.getLogger().debug("Failed to release plugin container - ignoring.");
        }
        return;
        {
            catch (ComponentConfigurationException e) {
                throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), "Unable to parse the created DOM for plugin configuration", e);
            }
            catch (ComponentLookupException e) {
                throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), "Unable to retrieve component configurator for plugin configuration", e);
            }
            catch (LinkageError e) {
                if (!this.getLogger().isFatalErrorEnabled()) throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), e.getClass().getName() + ": " + e.getMessage(), new ComponentConfigurationException((Throwable)e));
                this.getLogger().fatalError(configurator.getClass().getName() + "#configureComponent(...) caused a linkage error (" + e.getClass().getName() + ") and may be out-of-date. Check the realms:");
                ClassRealm pluginRealm = mojoDescriptor.getPluginDescriptor().getClassRealm();
                StringBuffer sb = new StringBuffer();
                sb.append("Plugin realm = " + pluginRealm.getId()).append('\n');
                for (int i = 0; i < pluginRealm.getURLs().length; ++i) {
                    sb.append("urls[" + i + "] = " + pluginRealm.getURLs()[i]);
                    if (i == pluginRealm.getURLs().length - 1) continue;
                    sb.append('\n');
                }
                this.getLogger().fatalError(sb.toString());
                ClassRealm containerRealm = this.container.getContainerRealm();
                sb = new StringBuffer();
                sb.append("Container realm = " + containerRealm.getId()).append('\n');
                for (int i = 0; i < containerRealm.getURLs().length; ++i) {
                    sb.append("urls[" + i + "] = " + containerRealm.getURLs()[i]);
                    if (i == containerRealm.getURLs().length - 1) continue;
                    sb.append('\n');
                }
                this.getLogger().fatalError(sb.toString());
                throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), e.getClass().getName() + ": " + e.getMessage(), new ComponentConfigurationException((Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (configurator == null) throw throwable;
            try {
                this.container.release(configurator);
                throw throwable;
            }
            catch (ComponentLifecycleException e) {
                this.getLogger().debug("Failed to release plugin container - ignoring.");
            }
            throw throwable;
        }
    }

    public static String createPluginParameterRequiredMessage(MojoDescriptor mojo, Parameter parameter, String expression) {
        StringBuffer message = new StringBuffer();
        message.append("The '");
        message.append(parameter.getName());
        message.append("' parameter is required for the execution of the ");
        message.append(mojo.getFullGoalName());
        message.append(" mojo and cannot be null.");
        if (expression != null) {
            message.append(" The retrieval expression was: ").append(expression);
        }
        return message.toString();
    }

    protected void resolveTransitiveDependencies(MavenSession context, ArtifactResolver artifactResolver, String scope, ArtifactFactory artifactFactory, MavenProject project, boolean isAggregator) throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        Set resolvedArtifacts;
        ScopeArtifactFilter filter = new ScopeArtifactFilter(scope);
        Artifact artifact = artifactFactory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
        if (project.getDependencyArtifacts() == null) {
            project.setDependencyArtifacts(project.createArtifacts(artifactFactory, null, null));
        }
        try {
            ArtifactResolutionResult result = artifactResolver.resolveTransitively(project.getDependencyArtifacts(), artifact, project.getManagedVersionMap(), context.getLocalRepository(), project.getRemoteArtifactRepositories(), this.artifactMetadataSource, (ArtifactFilter)filter);
            resolvedArtifacts = result.getArtifacts();
        }
        catch (MultipleArtifactsNotFoundException e) {
            if (isAggregator && this.checkMissingArtifactsInReactor(context.getSortedProjects(), e.getMissingArtifacts())) {
                resolvedArtifacts = new LinkedHashSet(e.getResolvedArtifacts());
            }
            throw e;
        }
        project.setArtifacts(resolvedArtifacts);
    }

    private boolean checkMissingArtifactsInReactor(Collection projects, Collection missing) {
        HashSet<MavenProject> foundInReactor = new HashSet<MavenProject>();
        block0: for (Artifact mArtifact : missing) {
            for (MavenProject p : projects) {
                if (!p.getArtifactId().equals(mArtifact.getArtifactId()) || !p.getGroupId().equals(mArtifact.getGroupId()) || !p.getVersion().equals(mArtifact.getVersion())) continue;
                this.getLogger().warn("The dependency: " + p.getId() + " can't be resolved but has been found in the reactor.\nThis dependency has been excluded from the plugin execution. You should rerun this mojo after executing mvn install.\n");
                foundInReactor.add(p);
                continue block0;
            }
        }
        return foundInReactor.size() == missing.size();
    }

    private void downloadDependencies(MavenProject project, MavenSession context, ArtifactResolver artifactResolver) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactRepository localRepository = context.getLocalRepository();
        List remoteArtifactRepositories = project.getRemoteArtifactRepositories();
        for (Artifact artifact : project.getArtifacts()) {
            artifactResolver.resolve(artifact, remoteArtifactRepositories, localRepository);
        }
    }

    public static void checkPlexusUtils(ResolutionGroup resolutionGroup, ArtifactFactory artifactFactory) {
        VersionRange vr = null;
        try {
            vr = VersionRange.createFromVersionSpec((String)"[1.1,)");
        }
        catch (InvalidVersionSpecificationException e) {
            // empty catch block
        }
        boolean plexusUtilsPresent = false;
        for (Artifact a : resolutionGroup.getArtifacts()) {
            if (!a.getArtifactId().equals("plexus-utils") || !vr.containsVersion((ArtifactVersion)new DefaultArtifactVersion(a.getVersion()))) continue;
            plexusUtilsPresent = true;
            break;
        }
        if (!plexusUtilsPresent) {
            resolutionGroup.getArtifacts().add(artifactFactory.createArtifact("org.codehaus.plexus", "plexus-utils", "1.1", Artifact.SCOPE_RUNTIME, "jar"));
        }
    }

    static {
        ArrayList<String> rgids = new ArrayList<String>();
        rgids.add("org.apache.maven.plugins.internal");
        RESERVED_GROUP_IDS = rgids;
    }

    private static final class PluginRealmAction {
        private final PluginDescriptor pluginDescriptor;
        private final ClassRealm realmWithTransientParent;

        PluginRealmAction(PluginDescriptor pluginDescriptor) {
            this.pluginDescriptor = pluginDescriptor;
            this.realmWithTransientParent = null;
        }

        PluginRealmAction(PluginDescriptor pluginDescriptor, ClassRealm realmWithTransientParent) {
            this.pluginDescriptor = pluginDescriptor;
            this.realmWithTransientParent = realmWithTransientParent;
        }

        void undo() {
            this.pluginDescriptor.setArtifacts(null);
            this.pluginDescriptor.setClassRealm(null);
            if (this.realmWithTransientParent != null) {
                this.realmWithTransientParent.setParentRealm(null);
            }
        }
    }
}

