/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MavenPluginDiscoverer;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginManagerSupport;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionManager;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.realm.RealmManagementException;
import org.apache.maven.realm.RealmScanningUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=PluginManagerSupport.class)
public class DefaultPluginManagerSupport
implements PluginManagerSupport,
LogEnabled,
Contextualizable {
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private MavenProjectBuilder mavenProjectBuilder;
    @Requirement
    private RuntimeInformation runtimeInformation;
    @Requirement
    private PluginVersionManager pluginVersionManager;
    private Logger logger;
    private Context containerContext;

    public Artifact resolvePluginArtifact(Plugin plugin, MavenProject project, MavenSession session) throws PluginManagerException, InvalidPluginException, PluginVersionResolutionException, ArtifactResolutionException, ArtifactNotFoundException {
        VersionRange versionRange;
        ArtifactRepository localRepository = session.getLocalRepository();
        try {
            versionRange = VersionRange.createFromVersionSpec((String)plugin.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new PluginManagerException(plugin, e);
        }
        ArrayList remoteRepositories = new ArrayList();
        remoteRepositories.addAll(project.getRemoteArtifactRepositories());
        MavenProject pluginProject = null;
        for (MavenProject mp : session.getSortedProjects()) {
            if (!mp.getId().equals(project.getId())) continue;
            pluginProject = mp;
            break;
        }
        if (pluginProject == null) {
            pluginProject = this.buildPluginProject(plugin, localRepository, remoteRepositories);
        }
        this.checkRequiredMavenVersion(plugin, pluginProject, localRepository, remoteRepositories);
        this.checkPluginDependencySpec(plugin, pluginProject);
        Artifact pluginArtifact = this.artifactFactory.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
        pluginArtifact = project.replaceWithActiveArtifact(pluginArtifact);
        this.artifactResolver.resolve(pluginArtifact, remoteRepositories, localRepository);
        return pluginArtifact;
    }

    public MavenProject buildPluginProject(Plugin plugin, ArtifactRepository localRepository, List remoteRepositories) throws InvalidPluginException {
        Artifact artifact = this.artifactFactory.createProjectArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion());
        try {
            return this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepositories, localRepository);
        }
        catch (ProjectBuildingException e) {
            throw new InvalidPluginException("Unable to build project for plugin '" + plugin.getKey() + "': " + e.getMessage(), e);
        }
    }

    public void checkRequiredMavenVersion(Plugin plugin, MavenProject pluginProject, ArtifactRepository localRepository, List remoteRepositories) throws PluginVersionResolutionException, InvalidPluginException {
        if (pluginProject.getPrerequisites() != null && pluginProject.getPrerequisites().getMaven() != null) {
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(pluginProject.getPrerequisites().getMaven());
            if (this.runtimeInformation.getApplicationInformation().getVersion().compareTo((Object)requiredVersion) < 0) {
                throw new PluginVersionResolutionException(plugin.getGroupId(), plugin.getArtifactId(), "Plugin requires Maven version " + requiredVersion);
            }
        }
    }

    public void checkPluginDependencySpec(Plugin plugin, MavenProject pluginProject) throws InvalidPluginException {
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        try {
            pluginProject.createArtifacts(this.artifactFactory, null, (ArtifactFilter)filter);
        }
        catch (InvalidDependencyVersionException e) {
            throw new InvalidPluginException("Plugin: " + plugin.getKey() + " has a dependency with an invalid version.", e);
        }
    }

    public PluginDescriptor loadIsolatedPluginDescriptor(Plugin plugin, MavenProject project, MavenSession session) {
        if (plugin.getVersion() == null) {
            try {
                plugin.setVersion(this.pluginVersionManager.resolvePluginVersion(plugin.getGroupId(), plugin.getArtifactId(), project, session));
            }
            catch (PluginVersionResolutionException e) {
                this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), (Throwable)e);
            }
            catch (InvalidPluginException e) {
                this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), (Throwable)e);
            }
            catch (PluginVersionNotFoundException e) {
                this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), (Throwable)e);
            }
        }
        if (plugin.getVersion() == null) {
            return null;
        }
        Artifact artifact = null;
        try {
            artifact = this.resolvePluginArtifact(plugin, project, session);
        }
        catch (ArtifactResolutionException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), (Throwable)e);
        }
        catch (PluginManagerException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), (Throwable)e);
        }
        catch (InvalidPluginException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), (Throwable)e);
        }
        catch (PluginVersionResolutionException e) {
            this.logger.debug("Failed to load plugin descriptor for: " + plugin.getKey(), (Throwable)e);
        }
        if (artifact == null) {
            return null;
        }
        MavenPluginDiscoverer discoverer = new MavenPluginDiscoverer();
        discoverer.setManager(RealmScanningUtils.getDummyComponentDiscovererManager());
        try {
            List componentSetDescriptors = RealmScanningUtils.scanForComponentSetDescriptors(artifact, (ComponentDiscoverer)discoverer, this.containerContext, "Plugin: " + plugin.getKey());
            if (!componentSetDescriptors.isEmpty()) {
                return (PluginDescriptor)componentSetDescriptors.get(0);
            }
        }
        catch (RealmManagementException e) {
            this.logger.debug("Failed to scan plugin artifact: " + artifact.getId() + " for descriptors.", (Throwable)e);
        }
        return null;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void contextualize(Context context) throws ContextException {
        this.containerContext = context;
    }
}

