/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.plugin.PluginMappingManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=PluginMappingManager.class)
public class DefaultPluginMappingManager
extends AbstractLogEnabled
implements PluginMappingManager {
    @Requirement
    protected RepositoryMetadataManager repositoryMetadataManager;
    private Map pluginDefinitionsByPrefix = new HashMap();

    public org.apache.maven.model.Plugin getByPrefix(String pluginPrefix, List groupIds, List pluginRepositories, ArtifactRepository localRepository) {
        org.apache.maven.model.Plugin result;
        if (!this.pluginDefinitionsByPrefix.containsKey(pluginPrefix)) {
            this.getLogger().info("Searching repository for plugin with prefix: '" + pluginPrefix + "'.");
            this.loadPluginMappings(groupIds, pluginRepositories, localRepository);
        }
        if ((result = (org.apache.maven.model.Plugin)this.pluginDefinitionsByPrefix.get(pluginPrefix)) == null) {
            this.getLogger().debug("Failed to resolve plugin from prefix: " + pluginPrefix, new Throwable());
        }
        return result;
    }

    private void loadPluginMappings(List groupIds, List pluginRepositories, ArtifactRepository localRepository) {
        ArrayList<String> pluginGroupIds = new ArrayList<String>(groupIds);
        if (!pluginGroupIds.contains("org.apache.maven.plugins")) {
            pluginGroupIds.add("org.apache.maven.plugins");
        }
        if (!pluginGroupIds.contains("org.codehaus.mojo")) {
            pluginGroupIds.add("org.codehaus.mojo");
        }
        for (String groupId : pluginGroupIds) {
            this.getLogger().debug("Loading plugin prefixes from group: " + groupId);
            try {
                this.loadPluginMappings(groupId, pluginRepositories, localRepository);
            }
            catch (RepositoryMetadataResolutionException e) {
                this.getLogger().warn("Cannot resolve plugin-mapping metadata for groupId: " + groupId + " - IGNORING.");
                this.getLogger().debug("Error resolving plugin-mapping metadata for groupId: " + groupId + ".", (Throwable)e);
            }
        }
    }

    private void loadPluginMappings(String groupId, List pluginRepositories, ArtifactRepository localRepository) throws RepositoryMetadataResolutionException {
        GroupRepositoryMetadata metadata = new GroupRepositoryMetadata(groupId);
        this.getLogger().debug("Checking repositories:\n" + pluginRepositories + "\n\nfor plugin prefix metadata: " + groupId);
        this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, pluginRepositories, localRepository);
        Metadata repoMetadata = metadata.getMetadata();
        if (repoMetadata != null) {
            for (Plugin mapping : repoMetadata.getPlugins()) {
                this.getLogger().debug("Found plugin: " + mapping.getName() + " with prefix: " + mapping.getPrefix());
                String prefix = mapping.getPrefix();
                if (this.pluginDefinitionsByPrefix.containsKey(prefix)) continue;
                String artifactId = mapping.getArtifactId();
                org.apache.maven.model.Plugin plugin = new org.apache.maven.model.Plugin();
                plugin.setGroupId(metadata.getGroupId());
                plugin.setArtifactId(artifactId);
                this.pluginDefinitionsByPrefix.put(prefix, plugin);
            }
        }
    }
}

