/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class MavenPluginCollector
implements ComponentDiscoveryListener,
LogEnabled {
    private Set pluginsInProcess = new HashSet();
    private Map pluginDescriptors = new HashMap();
    private Map pluginIdsByPrefix = new HashMap();
    private Logger logger;

    public void componentDiscovered(ComponentDiscoveryEvent event) {
        PluginDescriptor pluginDescriptor;
        String key;
        ComponentSetDescriptor componentSetDescriptor = event.getComponentSetDescriptor();
        if (componentSetDescriptor instanceof PluginDescriptor && !this.pluginsInProcess.contains(key = this.constructPluginKey(pluginDescriptor = (PluginDescriptor)componentSetDescriptor))) {
            this.pluginsInProcess.add(key);
            this.pluginDescriptors.put(key, pluginDescriptor);
        }
    }

    public String getId() {
        return "maven-plugin-collector";
    }

    public PluginDescriptor getPluginDescriptor(Plugin plugin) {
        String key = this.constructPluginKey(plugin);
        return (PluginDescriptor)this.pluginDescriptors.get(key);
    }

    private String constructPluginKey(Plugin plugin) {
        String version = ArtifactUtils.toSnapshotVersion((String)plugin.getVersion());
        return plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + version;
    }

    private String constructPluginKey(PluginDescriptor pluginDescriptor) {
        String version = ArtifactUtils.toSnapshotVersion((String)pluginDescriptor.getVersion());
        return pluginDescriptor.getGroupId() + ":" + pluginDescriptor.getArtifactId() + ":" + version;
    }

    public boolean isPluginInstalled(Plugin plugin) {
        String key = this.constructPluginKey(plugin);
        return this.pluginDescriptors.containsKey(key);
    }

    public Set getPluginDescriptorsForPrefix(String prefix) {
        HashSet<PluginDescriptor> result = new HashSet<PluginDescriptor>();
        for (PluginDescriptor pd : this.pluginDescriptors.values()) {
            if (!pd.getGoalPrefix().equals(prefix)) continue;
            result.add(pd);
        }
        return result;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(1, "internal");
        }
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

