/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.loader;

import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MavenPluginCollector;
import org.apache.maven.plugin.PluginManagerSupport;
import org.apache.maven.plugin.PluginMappingManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.loader.PluginLoaderException;
import org.apache.maven.plugin.loader.PluginPrefixLoader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=PluginPrefixLoader.class)
public class DefaultPluginPrefixLoader
implements PluginPrefixLoader,
LogEnabled {
    private Logger logger;
    @Requirement
    private PluginMappingManager pluginMappingManager;
    @Requirement
    private MavenPluginCollector pluginCollector;
    @Requirement
    private PluginManagerSupport pluginManagerSupport;

    public Plugin findPluginForPrefix(String prefix, MavenProject project, MavenSession session) throws PluginLoaderException {
        PluginDescriptor pluginDescriptor;
        Set descriptors = this.pluginCollector.getPluginDescriptorsForPrefix(prefix);
        Map projectPluginMap = project.getBuild().getPluginsAsMap();
        Plugin plugin = null;
        if (descriptors != null) {
            pluginDescriptor = null;
            for (PluginDescriptor pd : descriptors) {
                Plugin projectPlugin = (Plugin)projectPluginMap.get(pd.getPluginLookupKey());
                if (projectPlugin == null || projectPlugin.getVersion() == null || !projectPlugin.getVersion().equals(pd.getVersion())) continue;
                pluginDescriptor = pd;
                break;
            }
            plugin = this.toPlugin(pluginDescriptor);
        }
        if (plugin == null) {
            pluginDescriptor = this.loadFromProjectForPrefixQuery(prefix, project, session);
            plugin = this.toPlugin(pluginDescriptor);
        }
        if (plugin == null) {
            plugin = this.loadFromPrefixMapper(prefix, project, session);
        }
        if (plugin == null) {
            plugin = new Plugin();
            plugin.setArtifactId(PluginDescriptor.getDefaultPluginArtifactId((String)prefix));
            pluginDescriptor = this.pluginManagerSupport.loadIsolatedPluginDescriptor(plugin, project, session);
            plugin = this.toPlugin(pluginDescriptor);
        }
        if (plugin == null) {
            throw new PluginLoaderException("Cannot find plugin with prefix: " + prefix);
        }
        return plugin;
    }

    private Plugin toPlugin(PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            return null;
        }
        Plugin plugin = new Plugin();
        plugin.setGroupId(pluginDescriptor.getGroupId());
        plugin.setArtifactId(pluginDescriptor.getArtifactId());
        plugin.setVersion(pluginDescriptor.getVersion());
        return plugin;
    }

    private PluginDescriptor loadFromProjectForPrefixQuery(String prefix, MavenProject project, MavenSession session) throws PluginLoaderException {
        PluginDescriptor result = null;
        for (Plugin plugin : project.getBuildPlugins()) {
            PluginDescriptor pluginDescriptor = this.pluginManagerSupport.loadIsolatedPluginDescriptor(plugin, project, session);
            if (pluginDescriptor == null || !prefix.equals(pluginDescriptor.getGoalPrefix())) continue;
            result = pluginDescriptor;
            break;
        }
        return result;
    }

    private Plugin loadFromPrefixMapper(String prefix, MavenProject project, MavenSession session) throws PluginLoaderException {
        Plugin projectPlugin;
        Plugin plugin = this.pluginMappingManager.getByPrefix(prefix, session.getPluginGroups(), project.getRemoteArtifactRepositories(), session.getLocalRepository());
        if (plugin != null && (projectPlugin = (Plugin)project.getBuild().getPluginsAsMap().get(plugin.getKey())) != null && projectPlugin.getVersion() != null) {
            plugin.setVersion(projectPlugin.getVersion());
        }
        return plugin;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

