/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.version;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.version.PluginVersionManager;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Component(role=PluginVersionManager.class)
public class DefaultPluginVersionManager
extends AbstractLogEnabled
implements PluginVersionManager {
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactMetadataSource artifactMetadataSource;
    @Requirement
    private MavenProjectBuilder mavenProjectBuilder;
    @Requirement
    private RuntimeInformation runtimeInformation;

    public String resolvePluginVersion(String groupId, String artifactId, MavenProject project, MavenSession session) throws PluginVersionResolutionException, InvalidPluginException, PluginVersionNotFoundException {
        return this.resolvePluginVersion(groupId, artifactId, project, session.getLocalRepository(), false);
    }

    public String resolveReportPluginVersion(String groupId, String artifactId, MavenProject project, MavenSession session) throws PluginVersionResolutionException, InvalidPluginException, PluginVersionNotFoundException {
        return this.resolvePluginVersion(groupId, artifactId, project, session.getLocalRepository(), true);
    }

    private String resolvePluginVersion(String groupId, String artifactId, MavenProject project, ArtifactRepository localRepository, boolean resolveAsReportPlugin) throws PluginVersionResolutionException, InvalidPluginException, PluginVersionNotFoundException {
        String version = this.getVersionFromPluginConfig(groupId, artifactId, project, resolveAsReportPlugin);
        this.getLogger().debug("Version from POM: " + version);
        if (version == null && project.getProjectReferences() != null) {
            String refId = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
            MavenProject ref = (MavenProject)project.getProjectReferences().get(refId);
            if (ref != null) {
                version = ref.getVersion();
            }
        }
        this.getLogger().debug("Version from another POM in the reactor: " + version);
        if (StringUtils.isEmpty((String)version) || "LATEST".equals(version)) {
            version = this.resolveMetaVersion(groupId, artifactId, project, localRepository, "LATEST");
            this.getLogger().debug("Version from LATEST metadata: " + version);
        }
        if (StringUtils.isEmpty((String)version) || "RELEASE".equals(version)) {
            version = this.resolveMetaVersion(groupId, artifactId, project, localRepository, "RELEASE");
            this.getLogger().debug("Version from RELEASE metadata: " + version);
        }
        if (StringUtils.isEmpty((String)version)) {
            throw new PluginVersionNotFoundException(groupId, artifactId);
        }
        return version;
    }

    private String getVersionFromPluginConfig(String groupId, String artifactId, MavenProject project, boolean resolveAsReportPlugin) {
        String version;
        block4: {
            block3: {
                version = null;
                if (!resolveAsReportPlugin) break block3;
                if (project.getReportPlugins() == null) break block4;
                Iterator it = project.getReportPlugins().iterator();
                while (it.hasNext() && version == null) {
                    ReportPlugin plugin = (ReportPlugin)it.next();
                    if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                    version = plugin.getVersion();
                }
                break block4;
            }
            if (project.getBuildPlugins() != null) {
                Iterator it = project.getBuildPlugins().iterator();
                while (it.hasNext() && version == null) {
                    Plugin plugin = (Plugin)it.next();
                    if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                    version = plugin.getVersion();
                }
            }
        }
        return version;
    }

    private String resolveMetaVersion(String groupId, String artifactId, MavenProject project, ArtifactRepository localRepository, String metaVersionId) throws PluginVersionResolutionException, InvalidPluginException {
        this.getLogger().info("Attempting to resolve a version for plugin: " + groupId + ":" + artifactId + " using meta-version: " + metaVersionId);
        Artifact artifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, metaVersionId);
        String key = artifact.getDependencyConflictId();
        String version = null;
        try {
            ResolutionGroup resolutionGroup = this.artifactMetadataSource.retrieve(artifact, localRepository, project.getRemoteArtifactRepositories());
            artifact = resolutionGroup.getPomArtifact();
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new PluginVersionResolutionException(groupId, artifactId, e.getMessage(), e);
        }
        String artifactVersion = artifact.getVersion();
        if (!metaVersionId.equals(artifactVersion) && artifact.getFile() != null) {
            boolean pluginValid = false;
            while (!pluginValid && artifactVersion != null) {
                VersionRange vr;
                MavenProject pluginProject;
                pluginValid = true;
                try {
                    artifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, artifactVersion);
                    pluginProject = this.mavenProjectBuilder.buildFromRepository(artifact, project.getRemoteArtifactRepositories(), localRepository);
                }
                catch (ProjectBuildingException e) {
                    throw new InvalidPluginException("Unable to build project information for plugin '" + ArtifactUtils.versionlessKey((String)groupId, (String)artifactId) + "': " + e.getMessage(), e);
                }
                if (pluginProject.getPrerequisites() == null || pluginProject.getPrerequisites().getMaven() == null) continue;
                String mavenVersion = pluginProject.getPrerequisites().getMaven();
                VersionRange mavenRange = null;
                try {
                    mavenRange = VersionRange.createFromVersionSpec((String)mavenVersion);
                    List restrictions = mavenRange.getRestrictions();
                    if (restrictions.size() == 1 && Restriction.EVERYTHING.equals(restrictions.get(0))) {
                        String range = "[" + mavenVersion + ",]";
                        this.getLogger().debug("Plugin: " + pluginProject.getId() + " specifies a simple prerequisite Maven version of: " + mavenVersion + ". This version has been translated into the range: " + range + " for plugin-version resolution purposes.");
                        mavenRange = VersionRange.createFromVersionSpec((String)range);
                    }
                }
                catch (InvalidVersionSpecificationException e) {
                    this.getLogger().debug("Invalid prerequisite Maven version: " + mavenVersion + " for plugin: " + pluginProject.getId() + e.getMessage());
                }
                if (mavenRange == null || mavenRange.containsVersion(this.runtimeInformation.getApplicationInformation().getVersion())) continue;
                this.getLogger().info("Ignoring available plugin version: " + artifactVersion + " for: " + groupId + ":" + artifactId + " as it requires Maven version matching: " + mavenVersion);
                try {
                    vr = VersionRange.createFromVersionSpec((String)("(," + artifactVersion + ")"));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new PluginVersionResolutionException(groupId, artifactId, "Error getting available plugin versions: " + e.getMessage(), e);
                }
                this.getLogger().debug("Trying " + vr);
                try {
                    List versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, localRepository, project.getRemoteArtifactRepositories());
                    ArtifactVersion v = vr.matchVersion(versions);
                    artifactVersion = v != null ? v.toString() : null;
                }
                catch (ArtifactMetadataRetrievalException e) {
                    throw new PluginVersionResolutionException(groupId, artifactId, "Error getting available plugin versions: " + e.getMessage(), e);
                }
                if (artifactVersion != null) {
                    this.getLogger().debug("Found " + artifactVersion);
                    continue;
                }
                pluginValid = false;
            }
            version = artifactVersion;
        }
        if (version == null) {
            version = artifactVersion;
        }
        this.getLogger().info("Using version: " + version + " of plugin: " + groupId + ":" + artifactId);
        return version;
    }
}

