/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.realm;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.realm.RealmManagementException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;

public class RealmScanningUtils {
    private static final String DISCOVERY_REALM_ID = "discovery realm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List scanForComponentSetDescriptors(Artifact artifact, ComponentDiscoverer discoverer, Context context, String discoveryContextId) throws RealmManagementException {
        List componentSetDescriptors;
        ClassWorld discoveryWorld = new ClassWorld();
        try {
            ClassRealm discoveryRealm;
            try {
                discoveryRealm = discoveryWorld.newRealm(DISCOVERY_REALM_ID);
            }
            catch (DuplicateRealmException e) {
                throw new RealmManagementException(discoveryContextId, "Unable to create temporary ClassRealm for local-component discovery.", e);
            }
            try {
                discoveryRealm.addURL(artifact.getFile().toURL());
            }
            catch (MalformedURLException e) {
                throw new RealmManagementException(discoveryContextId, artifact, "Unable to generate URL from artifact file: " + artifact.getFile() + " for local-component discovery.", e);
            }
            try {
                componentSetDescriptors = discoverer.findComponents(context, discoveryRealm);
            }
            catch (PlexusConfigurationException e) {
                throw new RealmManagementException(discoveryContextId, "Unable to discover components in artifact: " + artifact.getId(), e);
            }
        }
        finally {
            Collection realms = discoveryWorld.getRealms();
            for (ClassRealm realm : realms) {
                try {
                    discoveryWorld.disposeRealm(realm.getId());
                }
                catch (NoSuchRealmException e) {}
            }
        }
        return componentSetDescriptors;
    }

    public static ComponentDiscovererManager getDummyComponentDiscovererManager() {
        return new DummyDiscovererManager();
    }

    private static final class DummyDiscovererManager
    implements ComponentDiscovererManager {
        private DummyDiscovererManager() {
        }

        public void fireComponentDiscoveryEvent(ComponentDiscoveryEvent arg0) {
        }

        public List getComponentDiscoverers() {
            return null;
        }

        public Map getComponentDiscoveryListeners() {
            return null;
        }

        public List getListeners() {
            return null;
        }

        public void initialize() {
        }

        public void registerComponentDiscoveryListener(ComponentDiscoveryListener l) {
        }

        public void removeComponentDiscoveryListener(ComponentDiscoveryListener l) {
        }
    }
}

