/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.realm;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SequencedCollection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;

public final class RealmUtils {
    private RealmUtils() {
    }

    public static String createExtensionRealmId(Artifact extensionArtifact) {
        return "/extensions/" + extensionArtifact.getGroupId() + ":" + extensionArtifact.getArtifactId() + ":" + extensionArtifact.getVersion() + "/thread:" + Thread.currentThread().getId();
    }

    public static String createProjectId(String projectGroupId, String projectArtifactId, String projectVersion) {
        return "/projects/" + projectGroupId + ":" + projectArtifactId + ":" + projectVersion + "/thread:" + Thread.currentThread().getId();
    }

    public static String createPluginRealmId(Plugin plugin) {
        StringBuffer id = new StringBuffer().append("/plugins/").append(plugin.getGroupId()).append(':').append(plugin.getArtifactId()).append(':').append(plugin.getVersion());
        StringBuffer depId = new StringBuffer();
        SequencedCollection dependencies = plugin.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            dependencies = new LinkedHashSet(dependencies);
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                depId.append(dep.getGroupId()).append(':').append(dep.getArtifactId()).append(';').append(dep.getVersion());
                if (!it.hasNext()) continue;
                depId.append(',');
            }
        } else {
            depId.append('0');
        }
        id.append('@').append(depId.toString().hashCode()).append("/thread:").append(Thread.currentThread().getId());
        return id.toString();
    }
}

