/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryBase;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.TrackableBase;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class SettingsXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, Settings settings) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(settings.getModelEncoding(), null);
        this.writeSettings(settings, "settings", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer) throws IOException {
        if (activation != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activation.isActiveByDefault()) {
                serializer.startTag(this.NAMESPACE, "activeByDefault").text(String.valueOf(activation.isActiveByDefault())).endTag(this.NAMESPACE, "activeByDefault");
            }
            if (activation.getJdk() != null) {
                serializer.startTag(this.NAMESPACE, "jdk").text(activation.getJdk()).endTag(this.NAMESPACE, "jdk");
            }
            if (activation.getOs() != null) {
                this.writeActivationOS(activation.getOs(), "os", serializer);
            }
            if (activation.getProperty() != null) {
                this.writeActivationProperty(activation.getProperty(), "property", serializer);
            }
            if (activation.getFile() != null) {
                this.writeActivationFile(activation.getFile(), "file", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationFile(ActivationFile activationFile, String tagName, XmlSerializer serializer) throws IOException {
        if (activationFile != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationFile.getMissing() != null) {
                serializer.startTag(this.NAMESPACE, "missing").text(activationFile.getMissing()).endTag(this.NAMESPACE, "missing");
            }
            if (activationFile.getExists() != null) {
                serializer.startTag(this.NAMESPACE, "exists").text(activationFile.getExists()).endTag(this.NAMESPACE, "exists");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationOS(ActivationOS activationOS, String tagName, XmlSerializer serializer) throws IOException {
        if (activationOS != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationOS.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(activationOS.getName()).endTag(this.NAMESPACE, "name");
            }
            if (activationOS.getFamily() != null) {
                serializer.startTag(this.NAMESPACE, "family").text(activationOS.getFamily()).endTag(this.NAMESPACE, "family");
            }
            if (activationOS.getArch() != null) {
                serializer.startTag(this.NAMESPACE, "arch").text(activationOS.getArch()).endTag(this.NAMESPACE, "arch");
            }
            if (activationOS.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(activationOS.getVersion()).endTag(this.NAMESPACE, "version");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer) throws IOException {
        if (activationProperty != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationProperty.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(activationProperty.getName()).endTag(this.NAMESPACE, "name");
            }
            if (activationProperty.getValue() != null) {
                serializer.startTag(this.NAMESPACE, "value").text(activationProperty.getValue()).endTag(this.NAMESPACE, "value");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeIdentifiableBase(IdentifiableBase identifiableBase, String tagName, XmlSerializer serializer) throws IOException {
        if (identifiableBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (identifiableBase.getId() != null && !identifiableBase.getId().equals("default")) {
                serializer.startTag(this.NAMESPACE, "id").text(identifiableBase.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeMirror(Mirror mirror, String tagName, XmlSerializer serializer) throws IOException {
        if (mirror != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (mirror.getMirrorOf() != null) {
                serializer.startTag(this.NAMESPACE, "mirrorOf").text(mirror.getMirrorOf()).endTag(this.NAMESPACE, "mirrorOf");
            }
            if (mirror.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(mirror.getName()).endTag(this.NAMESPACE, "name");
            }
            if (mirror.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(mirror.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (mirror.getId() != null && !mirror.getId().equals("default")) {
                serializer.startTag(this.NAMESPACE, "id").text(mirror.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer) throws IOException {
        if (profile != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (profile.getActivation() != null) {
                this.writeActivation(profile.getActivation(), "activation", serializer);
            }
            if (profile.getProperties() != null && profile.getProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                for (String string : profile.getProperties().keySet()) {
                    String value = (String)profile.getProperties().get(string);
                    serializer.startTag(this.NAMESPACE, "" + string + "").text(value).endTag(this.NAMESPACE, "" + string + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            if (profile.getRepositories() != null && profile.getRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "repositories");
                for (Repository repository : profile.getRepositories()) {
                    this.writeRepository(repository, "repository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "repositories");
            }
            if (profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "pluginRepositories");
                for (Repository repository : profile.getPluginRepositories()) {
                    this.writeRepository(repository, "pluginRepository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "pluginRepositories");
            }
            if (profile.getId() != null && !profile.getId().equals("default")) {
                serializer.startTag(this.NAMESPACE, "id").text(profile.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProxy(Proxy proxy, String tagName, XmlSerializer serializer) throws IOException {
        if (proxy != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (proxy.isActive()) {
                serializer.startTag(this.NAMESPACE, "active").text(String.valueOf(proxy.isActive())).endTag(this.NAMESPACE, "active");
            }
            if (proxy.getProtocol() != null && !proxy.getProtocol().equals("http")) {
                serializer.startTag(this.NAMESPACE, "protocol").text(proxy.getProtocol()).endTag(this.NAMESPACE, "protocol");
            }
            if (proxy.getUsername() != null) {
                serializer.startTag(this.NAMESPACE, "username").text(proxy.getUsername()).endTag(this.NAMESPACE, "username");
            }
            if (proxy.getPassword() != null) {
                serializer.startTag(this.NAMESPACE, "password").text(proxy.getPassword()).endTag(this.NAMESPACE, "password");
            }
            if (proxy.getPort() != 8080) {
                serializer.startTag(this.NAMESPACE, "port").text(String.valueOf(proxy.getPort())).endTag(this.NAMESPACE, "port");
            }
            if (proxy.getHost() != null) {
                serializer.startTag(this.NAMESPACE, "host").text(proxy.getHost()).endTag(this.NAMESPACE, "host");
            }
            if (proxy.getNonProxyHosts() != null) {
                serializer.startTag(this.NAMESPACE, "nonProxyHosts").text(proxy.getNonProxyHosts()).endTag(this.NAMESPACE, "nonProxyHosts");
            }
            if (proxy.getId() != null && !proxy.getId().equals("default")) {
                serializer.startTag(this.NAMESPACE, "id").text(proxy.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (repository.getReleases() != null) {
                this.writeRepositoryPolicy(repository.getReleases(), "releases", serializer);
            }
            if (repository.getSnapshots() != null) {
                this.writeRepositoryPolicy(repository.getSnapshots(), "snapshots", serializer);
            }
            if (repository.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(repository.getId()).endTag(this.NAMESPACE, "id");
            }
            if (repository.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(repository.getName()).endTag(this.NAMESPACE, "name");
            }
            if (repository.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(repository.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (repository.getLayout() != null && !repository.getLayout().equals("default")) {
                serializer.startTag(this.NAMESPACE, "layout").text(repository.getLayout()).endTag(this.NAMESPACE, "layout");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepositoryBase(RepositoryBase repositoryBase, String tagName, XmlSerializer serializer) throws IOException {
        if (repositoryBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (repositoryBase.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(repositoryBase.getId()).endTag(this.NAMESPACE, "id");
            }
            if (repositoryBase.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(repositoryBase.getName()).endTag(this.NAMESPACE, "name");
            }
            if (repositoryBase.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(repositoryBase.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (repositoryBase.getLayout() != null && !repositoryBase.getLayout().equals("default")) {
                serializer.startTag(this.NAMESPACE, "layout").text(repositoryBase.getLayout()).endTag(this.NAMESPACE, "layout");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepositoryPolicy(RepositoryPolicy repositoryPolicy, String tagName, XmlSerializer serializer) throws IOException {
        if (repositoryPolicy != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (!repositoryPolicy.isEnabled()) {
                serializer.startTag(this.NAMESPACE, "enabled").text(String.valueOf(repositoryPolicy.isEnabled())).endTag(this.NAMESPACE, "enabled");
            }
            if (repositoryPolicy.getUpdatePolicy() != null) {
                serializer.startTag(this.NAMESPACE, "updatePolicy").text(repositoryPolicy.getUpdatePolicy()).endTag(this.NAMESPACE, "updatePolicy");
            }
            if (repositoryPolicy.getChecksumPolicy() != null) {
                serializer.startTag(this.NAMESPACE, "checksumPolicy").text(repositoryPolicy.getChecksumPolicy()).endTag(this.NAMESPACE, "checksumPolicy");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeServer(Server server, String tagName, XmlSerializer serializer) throws IOException {
        if (server != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (server.getUsername() != null) {
                serializer.startTag(this.NAMESPACE, "username").text(server.getUsername()).endTag(this.NAMESPACE, "username");
            }
            if (server.getPassword() != null) {
                serializer.startTag(this.NAMESPACE, "password").text(server.getPassword()).endTag(this.NAMESPACE, "password");
            }
            if (server.getPrivateKey() != null) {
                serializer.startTag(this.NAMESPACE, "privateKey").text(server.getPrivateKey()).endTag(this.NAMESPACE, "privateKey");
            }
            if (server.getPassphrase() != null) {
                serializer.startTag(this.NAMESPACE, "passphrase").text(server.getPassphrase()).endTag(this.NAMESPACE, "passphrase");
            }
            if (server.getFilePermissions() != null) {
                serializer.startTag(this.NAMESPACE, "filePermissions").text(server.getFilePermissions()).endTag(this.NAMESPACE, "filePermissions");
            }
            if (server.getDirectoryPermissions() != null) {
                serializer.startTag(this.NAMESPACE, "directoryPermissions").text(server.getDirectoryPermissions()).endTag(this.NAMESPACE, "directoryPermissions");
            }
            if (server.getConfiguration() != null) {
                ((Xpp3Dom)server.getConfiguration()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (server.getId() != null && !server.getId().equals("default")) {
                serializer.startTag(this.NAMESPACE, "id").text(server.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSettings(Settings settings, String tagName, XmlSerializer serializer) throws IOException {
        if (settings != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (settings.getLocalRepository() != null) {
                serializer.startTag(this.NAMESPACE, "localRepository").text(settings.getLocalRepository()).endTag(this.NAMESPACE, "localRepository");
            }
            if (!settings.isInteractiveMode()) {
                serializer.startTag(this.NAMESPACE, "interactiveMode").text(String.valueOf(settings.isInteractiveMode())).endTag(this.NAMESPACE, "interactiveMode");
            }
            if (settings.isUsePluginRegistry()) {
                serializer.startTag(this.NAMESPACE, "usePluginRegistry").text(String.valueOf(settings.isUsePluginRegistry())).endTag(this.NAMESPACE, "usePluginRegistry");
            }
            if (settings.isOffline()) {
                serializer.startTag(this.NAMESPACE, "offline").text(String.valueOf(settings.isOffline())).endTag(this.NAMESPACE, "offline");
            }
            if (settings.getProxies() != null && settings.getProxies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "proxies");
                for (IdentifiableBase o : settings.getProxies()) {
                    this.writeProxy((Proxy)o, "proxy", serializer);
                }
                serializer.endTag(this.NAMESPACE, "proxies");
            }
            if (settings.getServers() != null && settings.getServers().size() > 0) {
                serializer.startTag(this.NAMESPACE, "servers");
                for (IdentifiableBase o : settings.getServers()) {
                    this.writeServer((Server)o, "server", serializer);
                }
                serializer.endTag(this.NAMESPACE, "servers");
            }
            if (settings.getMirrors() != null && settings.getMirrors().size() > 0) {
                serializer.startTag(this.NAMESPACE, "mirrors");
                for (IdentifiableBase o : settings.getMirrors()) {
                    this.writeMirror((Mirror)o, "mirror", serializer);
                }
                serializer.endTag(this.NAMESPACE, "mirrors");
            }
            if (settings.getProfiles() != null && settings.getProfiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "profiles");
                for (IdentifiableBase o : settings.getProfiles()) {
                    this.writeProfile((Profile)o, "profile", serializer);
                }
                serializer.endTag(this.NAMESPACE, "profiles");
            }
            if (settings.getActiveProfiles() != null && settings.getActiveProfiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "activeProfiles");
                for (String activeProfile : settings.getActiveProfiles()) {
                    serializer.startTag(this.NAMESPACE, "activeProfile").text(activeProfile).endTag(this.NAMESPACE, "activeProfile");
                }
                serializer.endTag(this.NAMESPACE, "activeProfiles");
            }
            if (settings.getPluginGroups() != null && settings.getPluginGroups().size() > 0) {
                serializer.startTag(this.NAMESPACE, "pluginGroups");
                for (String pluginGroup : settings.getPluginGroups()) {
                    serializer.startTag(this.NAMESPACE, "pluginGroup").text(pluginGroup).endTag(this.NAMESPACE, "pluginGroup");
                }
                serializer.endTag(this.NAMESPACE, "pluginGroups");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeTrackableBase(TrackableBase trackableBase, String tagName, XmlSerializer serializer) throws IOException {
        if (trackableBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

