/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionSetFilter
implements ArtifactFilter {
    private Set<String> excludes;

    public ExclusionSetFilter(String[] excludes) {
        this.excludes = new LinkedHashSet<String>(Arrays.asList(excludes));
    }

    public ExclusionSetFilter(Set<String> excludes) {
        this.excludes = excludes;
    }

    public boolean include(Artifact artifact) {
        String id = artifact.getArtifactId();
        if (this.excludes.contains(id)) {
            return false;
        }
        id = artifact.getGroupId() + ':' + id;
        return !this.excludes.contains(id);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.excludes.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExclusionSetFilter)) {
            return false;
        }
        ExclusionSetFilter other = (ExclusionSetFilter)obj;
        return this.excludes.equals(other.excludes);
    }
}

