/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.MojoBindingUtils;
import org.apache.maven.lifecycle.NoSuchPhaseException;
import org.apache.maven.lifecycle.model.BuildBinding;
import org.apache.maven.lifecycle.model.CleanBinding;
import org.apache.maven.lifecycle.model.LifecycleBinding;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.model.Phase;
import org.apache.maven.lifecycle.model.SiteBinding;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class LifecycleUtils {
    private LifecycleUtils() {
    }

    public static void setupTrackingInfo(LifecycleBindings bindings) {
        for (LifecycleBinding binding : bindings.getBindingList()) {
            if (binding == null) continue;
            LinkedHashMap phaseMap = binding.getOrderedPhaseMapping();
            for (Map.Entry entry : phaseMap.entrySet()) {
                Phase phase = (Phase)entry.getValue();
                String phaseName = (String)entry.getKey();
                if (phase == null) continue;
                phase.setLifecycleInfo(phaseName, binding);
            }
        }
    }

    public static void setOrigin(LifecycleBindings bindings, String origin) {
        for (LifecycleBinding binding : bindings.getBindingList()) {
            if (binding == null) continue;
            for (Phase phase : binding.getPhasesInOrder()) {
                if (phase == null) continue;
                for (MojoBinding mojoBinding : phase.getBindings()) {
                    mojoBinding.setOrigin(origin);
                }
            }
        }
    }

    public static List getMojoBindingListForLifecycle(String stopPhase, LifecycleBindings bindings) throws NoSuchPhaseException {
        LifecycleBinding binding = LifecycleUtils.findLifecycleBindingForPhase(stopPhase, bindings);
        if (binding == null) {
            throw new NoSuchPhaseException(stopPhase, "Phase not found in any lifecycle.");
        }
        return LifecycleUtils.getMojoBindingListForLifecycle(stopPhase, binding);
    }

    public static List getMojoBindingListForLifecycle(String stopPhase, LifecycleBinding lifecycle) throws NoSuchPhaseException {
        List phaseNames = lifecycle.getPhaseNamesInOrder();
        int idx = phaseNames.indexOf(stopPhase);
        if (idx < 0) {
            throw new NoSuchPhaseException(stopPhase, "Phase not found in lifecycle: " + lifecycle.getId());
        }
        List phases = lifecycle.getPhasesInOrder();
        ArrayList bindings = new ArrayList();
        for (int i = 0; i <= idx; ++i) {
            Phase phase = (Phase)phases.get(i);
            List phaseBindings = phase.getBindings();
            if (phaseBindings == null || phaseBindings.isEmpty()) continue;
            bindings.addAll(phaseBindings);
        }
        return bindings;
    }

    public static LifecycleBinding findLifecycleBindingForPhase(String phaseName, LifecycleBindings lifecycles) {
        List lifecyclesAvailable = lifecycles.getBindingList();
        for (LifecycleBinding lifecycle : lifecyclesAvailable) {
            if (lifecycle.getPhaseNamesInOrder().indexOf(phaseName) <= -1) continue;
            return lifecycle;
        }
        return null;
    }

    public static void removeMojoBinding(String phaseName, MojoBinding mojoBinding, LifecycleBinding lifecycleBinding, boolean considerExecutionId) throws NoSuchPhaseException {
        List phaseNames = lifecycleBinding.getPhaseNamesInOrder();
        int idx = phaseNames.indexOf(phaseName);
        if (idx < 0) {
            throw new NoSuchPhaseException(phaseName, "Phase: " + phaseName + " not found in lifecycle: " + lifecycleBinding.getId());
        }
        List phases = lifecycleBinding.getPhasesInOrder();
        Phase phase = (Phase)phases.get(idx);
        if (phase != null) {
            List mojoBindings = phase.getBindings();
            String targetKey = MojoBindingUtils.createMojoBindingKey(mojoBinding, considerExecutionId);
            Iterator it = mojoBindings.iterator();
            while (it.hasNext()) {
                MojoBinding candidate = (MojoBinding)it.next();
                String candidateKey = MojoBindingUtils.createMojoBindingKey(candidate, considerExecutionId);
                if (!candidateKey.equals(targetKey)) continue;
                it.remove();
            }
            phase.setBindings(mojoBindings);
        }
    }

    public static void addMojoBinding(String phaseName, MojoBinding mojoBinding, LifecycleBinding lifecycleBinding) throws NoSuchPhaseException {
        List phaseNames = lifecycleBinding.getPhaseNamesInOrder();
        int idx = phaseNames.indexOf(phaseName);
        if (idx < 0) {
            throw new NoSuchPhaseException(phaseName, "Phase: " + phaseName + " not found in lifecycle: " + lifecycleBinding.getId());
        }
        List phases = lifecycleBinding.getPhasesInOrder();
        Phase phase = (Phase)phases.get(idx);
        phase.addBinding(mojoBinding);
        mojoBinding.setLifecycleInfo(phase);
    }

    public static void addMojoBinding(String phaseName, MojoBinding mojo, LifecycleBindings bindings) throws LifecycleSpecificationException {
        LifecycleBinding binding = LifecycleUtils.findLifecycleBindingForPhase(phaseName, bindings);
        if (binding == null) {
            throw new NoSuchPhaseException(phaseName, "Phase not found in any lifecycle: " + phaseName);
        }
        LifecycleUtils.addMojoBinding(phaseName, mojo, binding);
    }

    public static LifecycleBindings mergeBindings(LifecycleBindings existingBindings, LifecycleBindings newBindings, LifecycleBindings defaultBindings, boolean mergeConfigIfExecutionIdMatches) {
        return LifecycleUtils.mergeBindings(existingBindings, newBindings, defaultBindings, mergeConfigIfExecutionIdMatches, false);
    }

    public static LifecycleBindings mergeBindings(LifecycleBindings existingBindings, LifecycleBindings newBindings, LifecycleBindings defaultBindings, boolean mergeConfigIfExecutionIdMatches, boolean reverseConfigMergeDirection) {
        LifecycleBindings result = new LifecycleBindings();
        result.setPackaging(newBindings.getPackaging());
        CleanBinding cb = (CleanBinding)LifecycleUtils.cloneBinding(existingBindings.getCleanBinding());
        if (defaultBindings != null && LifecycleUtils.isNullOrEmpty(cb)) {
            cb = (CleanBinding)LifecycleUtils.cloneBinding(defaultBindings.getCleanBinding());
        }
        if (cb == null) {
            cb = new CleanBinding();
        }
        result.setCleanBinding(cb);
        BuildBinding bb = (BuildBinding)LifecycleUtils.cloneBinding(existingBindings.getBuildBinding());
        if (defaultBindings != null && LifecycleUtils.isNullOrEmpty(bb)) {
            bb = (BuildBinding)LifecycleUtils.cloneBinding(defaultBindings.getBuildBinding());
        }
        if (bb == null) {
            bb = new BuildBinding();
        }
        result.setBuildBinding(bb);
        SiteBinding sb = (SiteBinding)LifecycleUtils.cloneBinding(existingBindings.getSiteBinding());
        if (defaultBindings != null && LifecycleUtils.isNullOrEmpty(sb)) {
            sb = (SiteBinding)LifecycleUtils.cloneBinding(defaultBindings.getSiteBinding());
        }
        if (sb == null) {
            sb = new SiteBinding();
        }
        result.setSiteBinding(sb);
        for (LifecycleBinding lifecycleBinding : newBindings.getBindingList()) {
            if (lifecycleBinding == null) continue;
            List phaseNames = lifecycleBinding.getPhaseNamesInOrder();
            List phases = lifecycleBinding.getPhasesInOrder();
            for (int i = 0; i < phases.size(); ++i) {
                Phase phase = (Phase)phases.get(i);
                String name = (String)phaseNames.get(i);
                if (phase == null || phase.getBindings() == null || phase.getBindings().isEmpty()) continue;
                for (MojoBinding mojoBinding : phase.getBindings()) {
                    MojoBinding matchingBinding;
                    mojoBinding = LifecycleUtils.cloneMojoBinding(mojoBinding);
                    if (mergeConfigIfExecutionIdMatches && (matchingBinding = LifecycleUtils.findMatchingMojoBinding(mojoBinding, existingBindings, true)) != null) {
                        Xpp3Dom existingConfig = new Xpp3Dom((Xpp3Dom)matchingBinding.getConfiguration());
                        Xpp3Dom configuration = reverseConfigMergeDirection ? Xpp3Dom.mergeXpp3Dom((Xpp3Dom)existingConfig, (Xpp3Dom)((Xpp3Dom)mojoBinding.getConfiguration())) : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)mojoBinding.getConfiguration()), (Xpp3Dom)existingConfig);
                        mojoBinding.setConfiguration(configuration);
                        if (mojoBinding.getOrigin() == null && matchingBinding.getOrigin() != null) {
                            mojoBinding.setOrigin(matchingBinding.getOrigin());
                        }
                        LifecycleBinding resultBinding = LifecycleUtils.findLifecycleBindingForPhase(name, result);
                        try {
                            LifecycleUtils.removeMojoBinding(name, matchingBinding, resultBinding, true);
                        }
                        catch (NoSuchPhaseException e) {
                            IllegalStateException error = new IllegalStateException(e.getMessage() + "\nSomething strange is going on. Merging should not encounter such inconsistencies.");
                            error.initCause(e);
                            throw error;
                        }
                    }
                    try {
                        LifecycleUtils.addMojoBinding(name, mojoBinding, result);
                    }
                    catch (LifecycleSpecificationException e) {
                        IllegalArgumentException error = new IllegalArgumentException("Project bindings are invalid. Reason: " + e.getMessage());
                        error.initCause(e);
                        throw error;
                    }
                }
            }
        }
        return result;
    }

    private static boolean isNullOrEmpty(LifecycleBinding binding) {
        if (binding == null) {
            return true;
        }
        for (Phase phase : binding.getPhasesInOrder()) {
            if (phase.getBindings().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static MojoBinding findMatchingMojoBinding(MojoBinding mojoBinding, LifecycleBindings inBindings, boolean considerExecutionId) {
        String key = MojoBindingUtils.createMojoBindingKey(mojoBinding, considerExecutionId);
        return (MojoBinding)LifecycleUtils.mapMojoBindingsByKey(inBindings, considerExecutionId).get(key);
    }

    private static Map mapMojoBindingsByKey(LifecycleBindings bindings, boolean considerExecutionId) {
        HashMap<String, MojoBinding> byKey = new HashMap<String, MojoBinding>();
        for (LifecycleBinding binding : bindings.getBindingList()) {
            if (binding == null) continue;
            for (Phase phase : binding.getPhasesInOrder()) {
                if (phase == null) continue;
                for (MojoBinding mojoBinding : phase.getBindings()) {
                    byKey.put(MojoBindingUtils.createMojoBindingKey(mojoBinding, considerExecutionId), mojoBinding);
                }
            }
        }
        return byKey;
    }

    public static void removeMojoBindings(List toRemove, LifecycleBindings bindings, boolean considerExecutionId) throws NoSuchPhaseException {
        if (bindings.getCleanBinding() != null) {
            LifecycleUtils.removeMojoBindings(toRemove, bindings.getCleanBinding(), considerExecutionId);
        }
        if (bindings.getBuildBinding() != null) {
            LifecycleUtils.removeMojoBindings(toRemove, bindings.getBuildBinding(), considerExecutionId);
        }
        if (bindings.getSiteBinding() != null) {
            LifecycleUtils.removeMojoBindings(toRemove, bindings.getSiteBinding(), considerExecutionId);
        }
    }

    public static void removeMojoBindings(List toRemove, LifecycleBinding removeFrom, boolean considerExecutionId) throws NoSuchPhaseException {
        ArrayList<String> targets = new ArrayList<String>();
        for (MojoBinding binding : toRemove) {
            targets.add(MojoBindingUtils.createMojoBindingKey(binding, considerExecutionId));
        }
        List phases = removeFrom.getPhasesInOrder();
        for (int i = 0; i < phases.size(); ++i) {
            Phase phase = (Phase)phases.get(i);
            List phaseBindings = phase.getBindings();
            Iterator mojoIt = phaseBindings.iterator();
            while (mojoIt.hasNext()) {
                MojoBinding binding = (MojoBinding)mojoIt.next();
                String key = MojoBindingUtils.createMojoBindingKey(binding, considerExecutionId);
                if (!targets.contains(key)) continue;
                mojoIt.remove();
            }
            phase.setBindings(phaseBindings);
        }
    }

    public static LifecycleBindings cloneBindings(LifecycleBindings bindings) {
        LifecycleBindings result = new LifecycleBindings();
        if (bindings.getCleanBinding() != null) {
            result.setCleanBinding((CleanBinding)LifecycleUtils.cloneBinding(bindings.getCleanBinding()));
        }
        if (bindings.getBuildBinding() != null) {
            result.setBuildBinding((BuildBinding)LifecycleUtils.cloneBinding(bindings.getBuildBinding()));
        }
        if (bindings.getSiteBinding() != null) {
            result.setSiteBinding((SiteBinding)LifecycleUtils.cloneBinding(bindings.getSiteBinding()));
        }
        return result;
    }

    public static LifecycleBinding cloneBinding(LifecycleBinding binding) {
        LifecycleBinding result;
        if (binding == null) {
            return null;
        }
        if (binding instanceof CleanBinding) {
            result = new CleanBinding();
        } else if (binding instanceof SiteBinding) {
            result = new SiteBinding();
        } else if (binding instanceof BuildBinding) {
            result = new BuildBinding();
        } else {
            throw new IllegalArgumentException("Unrecognized LifecycleBinding type: " + binding.getClass().getName() + "; cannot clone.");
        }
        List phases = binding.getPhasesInOrder();
        List names = binding.getPhaseNamesInOrder();
        for (int i = 0; i < phases.size(); ++i) {
            Phase phase = (Phase)phases.get(i);
            String phaseName = (String)names.get(i);
            for (MojoBinding originalBinding : phase.getBindings()) {
                MojoBinding newBinding = LifecycleUtils.cloneMojoBinding(originalBinding);
                try {
                    LifecycleUtils.addMojoBinding(phaseName, newBinding, result);
                }
                catch (NoSuchPhaseException e) {
                    IllegalStateException error = new IllegalStateException(e.getMessage() + "\nSomething strange is going on. Cloning should not encounter such inconsistencies.");
                    error.initCause(e);
                    throw error;
                }
            }
        }
        return result;
    }

    public static MojoBinding cloneMojoBinding(MojoBinding binding) {
        MojoBinding result = new MojoBinding();
        result.setGroupId(binding.getGroupId());
        result.setArtifactId(binding.getArtifactId());
        result.setVersion(binding.getVersion());
        result.setConfiguration(binding.getConfiguration());
        result.setExecutionId(binding.getExecutionId());
        result.setGoal(binding.getGoal());
        result.setOrigin(binding.getOrigin());
        return result;
    }

    public static Phase findPhaseForMojoBinding(MojoBinding mojoBinding, LifecycleBindings lifecycleBindings, boolean considerExecutionId) {
        String targetKey = MojoBindingUtils.createMojoBindingKey(mojoBinding, considerExecutionId);
        for (LifecycleBinding binding : lifecycleBindings.getBindingList()) {
            for (Phase phase : binding.getPhasesInOrder()) {
                for (MojoBinding candidate : phase.getBindings()) {
                    String key = MojoBindingUtils.createMojoBindingKey(candidate, considerExecutionId);
                    if (!key.equals(targetKey)) continue;
                    return phase;
                }
            }
        }
        return null;
    }

    public static boolean isMojoBindingPresent(MojoBinding binding, List candidates, boolean considerExecutionId) {
        String key = MojoBindingUtils.createMojoBindingKey(binding, considerExecutionId);
        for (MojoBinding candidate : candidates) {
            String candidateKey = MojoBindingUtils.createMojoBindingKey(candidate, considerExecutionId);
            if (!candidateKey.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidPhaseName(String phaseName) {
        LifecycleBindings test = new LifecycleBindings();
        for (LifecycleBinding binding : test.getBindingList()) {
            if (!binding.getPhaseNamesInOrder().contains(phaseName)) continue;
            return true;
        }
        return false;
    }

    public static List getValidPhaseNames() {
        ArrayList phaseNames = new ArrayList();
        LifecycleBindings bindings = new LifecycleBindings();
        for (LifecycleBinding binding : bindings.getBindingList()) {
            Iterator phaseNameIt = binding.getPhaseNamesInOrder().iterator();
            while (phaseNameIt.hasNext()) {
                phaseNames.add(phaseNameIt.next());
            }
        }
        return phaseNames;
    }

    public static List getValidBuildPhaseNames() {
        ArrayList phaseNames = new ArrayList();
        BuildBinding binding = new BuildBinding();
        Iterator phaseNameIt = ((LifecycleBinding)binding).getPhaseNamesInOrder().iterator();
        while (phaseNameIt.hasNext()) {
            phaseNames.add(phaseNameIt.next());
        }
        return phaseNames;
    }

    public static List getValidCleanPhaseNames() {
        ArrayList phaseNames = new ArrayList();
        CleanBinding binding = new CleanBinding();
        Iterator phaseNameIt = ((LifecycleBinding)binding).getPhaseNamesInOrder().iterator();
        while (phaseNameIt.hasNext()) {
            phaseNames.add(phaseNameIt.next());
        }
        return phaseNames;
    }

    public static List getValidSitePhaseNames() {
        ArrayList phaseNames = new ArrayList();
        SiteBinding binding = new SiteBinding();
        Iterator phaseNameIt = ((LifecycleBinding)binding).getPhaseNamesInOrder().iterator();
        while (phaseNameIt.hasNext()) {
            phaseNames.add(phaseNameIt.next());
        }
        return phaseNames;
    }

    public static String createMojoBindingKey(MojoBinding mojoBinding, boolean considerExecutionId) {
        return MojoBindingUtils.createMojoBindingKey(mojoBinding, considerExecutionId);
    }
}

