/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelContainerAction;
import org.apache.maven.shared.model.ModelContainerFactory;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdModelContainerFactory
implements ModelContainerFactory {
    private String uri;
    public static final List<IdModelContainerFactory> ID_CONTAINER_FACTORIES = Collections.unmodifiableList(Arrays.asList(new IdModelContainerFactory(ProjectUri.PluginRepositories.PluginRepository.xUri), new IdModelContainerFactory(ProjectUri.Repositories.Repository.xUri), new IdModelContainerFactory(ProjectUri.Reporting.Plugins.Plugin.ReportSets.ReportSet.xUri), new IdModelContainerFactory(ProjectUri.Profiles.Profile.xUri), new IdModelContainerFactory(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri)));

    public IdModelContainerFactory(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri: null");
        }
        this.uri = uri;
    }

    public Collection<String> getUris() {
        return Collections.unmodifiableList(Arrays.asList(this.uri));
    }

    public ModelContainer create(List<ModelProperty> modelProperties) {
        if (modelProperties == null || modelProperties.size() == 0) {
            throw new IllegalArgumentException("modelProperties: null or empty");
        }
        return new IdModelContainer(modelProperties);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdModelContainer
    implements ModelContainer {
        private String id;
        private List<ModelProperty> properties;

        private IdModelContainer(List<ModelProperty> properties) {
            this.properties = new ArrayList<ModelProperty>(properties);
            this.properties = Collections.unmodifiableList(this.properties);
            for (ModelProperty mp : properties) {
                if (!mp.getUri().endsWith("/id")) continue;
                this.id = mp.getResolvedValue();
            }
        }

        public ModelContainerAction containerAction(ModelContainer modelContainer) {
            if (modelContainer == null) {
                throw new IllegalArgumentException("modelContainer: null");
            }
            if (!(modelContainer instanceof IdModelContainer)) {
                throw new IllegalArgumentException("modelContainer: wrong type");
            }
            IdModelContainer c = (IdModelContainer)modelContainer;
            if (c.id == null || this.id == null) {
                return ModelContainerAction.NOP;
            }
            return c.id.equals(this.id) ? ModelContainerAction.JOIN : ModelContainerAction.NOP;
        }

        public ModelContainer createNewInstance(List<ModelProperty> modelProperties) {
            return new IdModelContainer(modelProperties);
        }

        public List<ModelProperty> getProperties() {
            return this.properties;
        }

        public String toString() {
            return "ID = " + this.id;
        }
    }
}

