/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.shared.model.ModelContainerRule;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionRule
implements ModelContainerRule {
    public List<ModelProperty> execute(List<ModelProperty> modelProperties) {
        ArrayList<ModelProperty> properties = new ArrayList<ModelProperty>(modelProperties);
        ArrayList<ModelProperty> goalProperties = new ArrayList<ModelProperty>();
        ArrayList<ModelProperty> processedProperties = new ArrayList<ModelProperty>();
        for (ModelProperty mp : properties) {
            if (mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.Execution.Goals.goal)) {
                goalProperties.add(mp);
                continue;
            }
            if (mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.Execution.Goals.xURI)) {
                if (ExecutionRule.containsProperty(mp, processedProperties)) continue;
                processedProperties.add(mp);
                continue;
            }
            processedProperties.add(mp);
        }
        ArrayList<ModelProperty> c = new ArrayList<ModelProperty>();
        boolean x = false;
        for (ModelProperty mp : processedProperties) {
            if (!mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.Execution.configuration)) continue;
            if (x) {
                c.add(mp);
                continue;
            }
            x = true;
        }
        processedProperties.removeAll(c);
        if (!goalProperties.isEmpty()) {
            Collections.reverse(goalProperties);
            ArrayList<ModelProperty> uniqueGoals = new ArrayList<ModelProperty>();
            for (ModelProperty mp : goalProperties) {
                if (ExecutionRule.containsProperty(mp, uniqueGoals)) continue;
                uniqueGoals.add(mp);
            }
            Collections.reverse(uniqueGoals);
            processedProperties.addAll(ExecutionRule.findIndexOf(ProjectUri.Build.Plugins.Plugin.Executions.Execution.Goals.xURI, processedProperties) + 1, uniqueGoals);
        }
        ArrayList<ModelProperty> emptyTags = new ArrayList<ModelProperty>();
        for (ModelProperty mp : processedProperties) {
            if (!mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.Execution.Goals.xURI) || mp.getResolvedValue() == null || !mp.getResolvedValue().trim().equals("")) continue;
            emptyTags.add(mp);
        }
        processedProperties.removeAll(emptyTags);
        return processedProperties;
    }

    private static int findIndexOf(String uri, List<ModelProperty> modelProperties) {
        for (ModelProperty mp : modelProperties) {
            if (!mp.getUri().equals(uri)) continue;
            return modelProperties.indexOf(mp);
        }
        return -1;
    }

    private static boolean containsProperty(ModelProperty modelProperty, List<ModelProperty> modelProperties) {
        for (ModelProperty mp : modelProperties) {
            boolean b;
            if (!mp.getUri().equals(modelProperty.getUri()) || !(b = mp.getResolvedValue() == null && modelProperty.getResolvedValue() == null || mp.getResolvedValue() != null && !mp.getResolvedValue().trim().equals("") && mp.getResolvedValue().equals(modelProperty.getResolvedValue()))) continue;
            return true;
        }
        return false;
    }
}

