/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class SshdSocketAddress
extends SocketAddress {
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOCALHOST_IP = "127.0.0.1";
    public static final String IP_ANYADDR = "0.0.0.0";
    public static final String PRIVATE_CLASS_A_PREFIX = "10.";
    public static final String PRIVATE_CLASS_B_PREFIX = "172.";
    public static final String PRIVATE_CLASS_C_PREFIX = "192.168.";
    public static final String CARRIER_GRADE_NAT_PREFIX = "100.";
    public static final String BROADCAST_ADDRESS = "255.255.255.255";
    public static final SshdSocketAddress LOCALHOST_ADDRESS = new SshdSocketAddress("127.0.0.1", 0);
    public static final Comparator<InetAddress> BY_HOST_ADDRESS = (a1, a2) -> {
        String n1 = GenericUtils.trimToEmpty(SshdSocketAddress.toAddressString(a1));
        String n2 = GenericUtils.trimToEmpty(SshdSocketAddress.toAddressString(a2));
        return String.CASE_INSENSITIVE_ORDER.compare(n1, n2);
    };
    private static final long serialVersionUID = 6461645947151952729L;
    private final String hostName;
    private final int port;

    public SshdSocketAddress(int port) {
        this(IP_ANYADDR, port);
    }

    public SshdSocketAddress(String hostName, int port) {
        Objects.requireNonNull(hostName, "Host name may not be null");
        this.hostName = GenericUtils.isEmpty(hostName) ? IP_ANYADDR : hostName;
        ValidateUtils.checkTrue(port >= 0, "Port must be >= 0: %d", port);
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.getHostName(), this.getPort());
    }

    public String toString() {
        return this.getHostName() + ":" + this.getPort();
    }

    protected boolean isEquivalent(SshdSocketAddress that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return this.getPort() == that.getPort() && Objects.equals(this.getHostName(), that.getHostName());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.isEquivalent((SshdSocketAddress)o);
    }

    public int hashCode() {
        return Objects.hashCode(this.getHostName()) + this.getPort();
    }

    public static InetAddress getFirstExternalNetwork4Address() {
        List<InetAddress> addresses = SshdSocketAddress.getExternalNetwork4Addresses();
        return GenericUtils.size(addresses) > 0 ? addresses.get(0) : null;
    }

    public static List<InetAddress> getExternalNetwork4Addresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets != null && nets.hasMoreElements()) {
                NetworkInterface netint = nets.nextElement();
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                while (inetAddresses != null && inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!SshdSocketAddress.isValidHostAddress(inetAddress)) continue;
                    addresses.add(inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (GenericUtils.size(addresses) > 1) {
            Collections.sort(addresses, BY_HOST_ADDRESS);
        }
        return addresses;
    }

    public static boolean isValidHostAddress(InetAddress addr) {
        if (addr == null) {
            return false;
        }
        if (addr.isLinkLocalAddress()) {
            return false;
        }
        if (addr.isMulticastAddress()) {
            return false;
        }
        if (!(addr instanceof Inet4Address)) {
            return false;
        }
        return !SshdSocketAddress.isLoopback(addr);
    }

    public static boolean isLoopback(InetAddress addr) {
        if (addr == null) {
            return false;
        }
        if (addr.isLoopbackAddress()) {
            return true;
        }
        String ip = SshdSocketAddress.toAddressString(addr);
        return SshdSocketAddress.isLoopback(ip);
    }

    public static boolean isLoopback(String ip) {
        if (GenericUtils.isEmpty(ip)) {
            return false;
        }
        if (LOCALHOST_NAME.equals(ip) || LOCALHOST_IP.equals(ip)) {
            return true;
        }
        String[] values = GenericUtils.split(ip, '.');
        if (GenericUtils.length(values) != 4) {
            return false;
        }
        for (int index = 0; index < values.length; ++index) {
            int number;
            String val = values[index];
            if (!SshdSocketAddress.isValidIPv4AddressComponent(val)) {
                return false;
            }
            if (index != 0 || (number = Integer.parseInt(val)) == 127) continue;
            return false;
        }
        return true;
    }

    public static String toAddressString(SocketAddress addr) {
        if (addr == null) {
            return null;
        }
        if (addr instanceof InetSocketAddress) {
            return ((InetSocketAddress)addr).getHostString();
        }
        if (addr instanceof SshdSocketAddress) {
            return ((SshdSocketAddress)addr).getHostName();
        }
        return addr.toString();
    }

    public static InetSocketAddress toInetSocketAddress(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            return null;
        }
        if (remoteAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)remoteAddress;
        }
        if (remoteAddress instanceof SshdSocketAddress) {
            return ((SshdSocketAddress)remoteAddress).toInetSocketAddress();
        }
        throw new ClassCastException("Unknown remote address type: " + remoteAddress);
    }

    public static String toAddressString(InetAddress addr) {
        String ip;
        String string = ip = addr == null ? null : addr.toString();
        if (GenericUtils.isEmpty(ip)) {
            return null;
        }
        return ip.replaceAll(".*/", "");
    }

    public static boolean isIPv4Address(String addr) {
        if (GenericUtils.isEmpty(addr)) {
            return false;
        }
        String[] comps = GenericUtils.split(addr, '.');
        if (GenericUtils.length(comps) != 4) {
            return false;
        }
        for (String c : comps) {
            if (SshdSocketAddress.isValidIPv4AddressComponent(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrivateIPv4Address(String addr) {
        if (GenericUtils.isEmpty(addr)) {
            return false;
        }
        if (addr.startsWith(PRIVATE_CLASS_A_PREFIX) || addr.startsWith(PRIVATE_CLASS_C_PREFIX)) {
            return true;
        }
        if (!addr.startsWith(PRIVATE_CLASS_B_PREFIX)) {
            return false;
        }
        int nextCompPos = addr.indexOf(46, PRIVATE_CLASS_B_PREFIX.length());
        if (nextCompPos <= PRIVATE_CLASS_B_PREFIX.length()) {
            return false;
        }
        String value = addr.substring(PRIVATE_CLASS_B_PREFIX.length(), nextCompPos);
        if (!SshdSocketAddress.isValidIPv4AddressComponent(value)) {
            return false;
        }
        int v = Integer.parseInt(value);
        return v >= 16 && v <= 31;
    }

    public static boolean isCarrierGradeNatIPv4Address(String addr) {
        if (GenericUtils.isEmpty(addr)) {
            return false;
        }
        if (!addr.startsWith(CARRIER_GRADE_NAT_PREFIX)) {
            return false;
        }
        int nextCompPos = addr.indexOf(46, CARRIER_GRADE_NAT_PREFIX.length());
        if (nextCompPos <= CARRIER_GRADE_NAT_PREFIX.length()) {
            return false;
        }
        String value = addr.substring(CARRIER_GRADE_NAT_PREFIX.length(), nextCompPos);
        if (!SshdSocketAddress.isValidIPv4AddressComponent(value)) {
            return false;
        }
        int v = Integer.parseInt(value);
        return v >= 64 && v <= 127;
    }

    public static boolean isValidIPv4AddressComponent(CharSequence c) {
        if (GenericUtils.isEmpty(c) || c.length() > 3) {
            return false;
        }
        char ch = c.charAt(0);
        if (ch < '0' || ch > '9') {
            return false;
        }
        if (!NumberUtils.isIntegerNumber(c)) {
            return false;
        }
        int v = Integer.parseInt(c.toString());
        return v >= 0 && v <= 255;
    }
}

