/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.DHParameterSpec;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.pem.PEMResourceParserUtils;
import org.apache.sshd.common.random.JceRandomFactory;
import org.apache.sshd.common.random.RandomFactory;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.SecurityEntityFactory;
import org.apache.sshd.common.util.security.SecurityProviderChoice;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleGeneratorHostKeyProvider;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleKeyPairResourceParser;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleRandomFactory;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProvider;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    public static final String BOUNCY_CASTLE = "BC";
    public static final String EDDSA = "EdDSA";
    public static final String CURVE_ED25519_SHA512 = "ed25519-sha-512";
    public static final String MAX_DHGEX_KEY_SIZE_PROP = "org.apache.sshd.maxDHGexKeySize";
    public static final int MIN_DHGEX_KEY_SIZE = 1024;
    public static final int DEFAULT_DHGEX_KEY_SIZE = 1024;
    public static final int PREFERRED_DHGEX_KEY_SIZE = 4096;
    public static final int MAX_DHGEX_KEY_SIZE = 8192;
    public static final String SECURITY_PROVIDER_REGISTRARS = "org.apache.sshd.security.registrars";
    public static final List<String> DEFAULT_SECURITY_PROVIDER_REGISTRARS = Collections.unmodifiableList(Arrays.asList("org.apache.sshd.common.util.security.bouncycastle.BouncyCastleSecurityProviderRegistrar", "org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderRegistrar"));
    @Deprecated
    public static final String REGISTER_BOUNCY_CASTLE_PROP = "org.apache.sshd.registerBouncyCastle";
    public static final String ECC_SUPPORTED_PROP = "org.apache.sshd.eccSupport";
    @Deprecated
    public static final String EDDSA_SUPPORTED_PROP = "org.apache.sshd.eddsaSupport";
    public static final String PROP_DEFAULT_SECURITY_PROVIDER = "org.apache.sshd.security.defaultProvider";
    private static final AtomicInteger MAX_DHG_KEY_SIZE_HOLDER = new AtomicInteger(0);
    private static final Map<String, SecurityProviderRegistrar> REGISTERED_PROVIDERS = new LinkedHashMap<String, SecurityProviderRegistrar>();
    private static final AtomicReference<KeyPairResourceParser> KEYPAIRS_PARSER_HODLER = new AtomicReference();
    private static final Set<String> APRIORI_DISABLED_PROVIDERS = new TreeSet<String>();
    private static final AtomicBoolean REGISTRATION_STATE_HOLDER = new AtomicBoolean(false);
    private static final Map<Class<?>, Map<String, SecurityEntityFactory<?>>> SECURITY_ENTITY_FACTORIES = new HashMap();
    private static final AtomicReference<SecurityProviderChoice> DEFAULT_PROVIDER_HOLDER = new AtomicReference();
    private static Boolean hasEcc;

    private SecurityUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAPrioriDisabledProvider(String name) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No provider name specified");
        Set<String> set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            return APRIORI_DISABLED_PROVIDERS.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAPrioriDisabledProvider(String name, boolean disabled) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No provider name specified");
        Set<String> set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            if (disabled) {
                APRIORI_DISABLED_PROVIDERS.add(name);
            } else {
                APRIORI_DISABLED_PROVIDERS.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAPrioriDisabledProviders() {
        Set<String> set = APRIORI_DISABLED_PROVIDERS;
        synchronized (set) {
            return new TreeSet<String>(APRIORI_DISABLED_PROVIDERS);
        }
    }

    public static boolean isECCSupported() {
        if (hasEcc == null) {
            String propValue = System.getProperty(ECC_SUPPORTED_PROP);
            if (GenericUtils.isEmpty(propValue)) {
                try {
                    SecurityUtils.getKeyPairGenerator("EC");
                    hasEcc = Boolean.TRUE;
                }
                catch (Throwable t) {
                    hasEcc = Boolean.FALSE;
                }
            } else {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override ECC support value: " + propValue);
                hasEcc = Boolean.valueOf(propValue);
            }
        }
        return hasEcc;
    }

    public static boolean isDHGroupExchangeSupported() {
        return SecurityUtils.getMaxDHGroupExchangeKeySize() > 0;
    }

    public static boolean isDHOakelyGroupSupported(int keySize) {
        return SecurityUtils.getMaxDHGroupExchangeKeySize() >= keySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxDHGroupExchangeKeySize() {
        int maxSupportedKeySize;
        AtomicInteger atomicInteger = MAX_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            maxSupportedKeySize = MAX_DHG_KEY_SIZE_HOLDER.get();
            if (maxSupportedKeySize != 0) {
                return maxSupportedKeySize;
            }
            String propValue = System.getProperty(MAX_DHGEX_KEY_SIZE_PROP);
            if (GenericUtils.isEmpty(propValue)) {
                maxSupportedKeySize = -1;
                for (int testKeySize = 8192; testKeySize >= 1024; testKeySize -= 1024) {
                    if (!SecurityUtils.isDHGroupExchangeSupported(testKeySize)) continue;
                    maxSupportedKeySize = testKeySize;
                    break;
                }
            } else {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override max. DH group exchange key size: " + propValue);
                maxSupportedKeySize = Integer.parseInt(propValue);
                ValidateUtils.checkTrue(maxSupportedKeySize != 0, "Configured org.apache.sshd.maxDHGexKeySize value must be non-zero: %d", maxSupportedKeySize);
            }
            MAX_DHG_KEY_SIZE_HOLDER.set(maxSupportedKeySize);
        }
        return maxSupportedKeySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxDHGroupExchangeKeySize(int keySize) {
        AtomicInteger atomicInteger = MAX_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            MAX_DHG_KEY_SIZE_HOLDER.set(keySize);
        }
    }

    public static boolean isDHGroupExchangeSupported(int maxKeySize) {
        ValidateUtils.checkTrue(maxKeySize > 8, "Invalid max. key size: %d", maxKeySize);
        try {
            BigInteger r = new BigInteger("0").setBit(maxKeySize - 1);
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(r, r);
            KeyPairGenerator kpg = SecurityUtils.getKeyPairGenerator("DH");
            kpg.initialize(dhSkipParamSpec);
            return true;
        }
        catch (GeneralSecurityException t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderChoice getDefaultProviderChoice() {
        SecurityProviderChoice choice;
        AtomicReference<SecurityProviderChoice> atomicReference = DEFAULT_PROVIDER_HOLDER;
        synchronized (atomicReference) {
            choice = DEFAULT_PROVIDER_HOLDER.get();
            if (choice != null) {
                return choice;
            }
            String name = System.getProperty(PROP_DEFAULT_SECURITY_PROVIDER);
            choice = GenericUtils.isEmpty(name) || "none".equalsIgnoreCase(name) ? SecurityProviderChoice.EMPTY : SecurityProviderChoice.toSecurityProviderChoice(name);
            DEFAULT_PROVIDER_HOLDER.set(choice);
        }
        return choice;
    }

    public static void setDefaultProviderChoice(SecurityProviderChoice choice) {
        DEFAULT_PROVIDER_HOLDER.set(choice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRegisteredProviders() {
        Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
        synchronized (map) {
            return new TreeSet<String>(REGISTERED_PROVIDERS.keySet());
        }
    }

    public static boolean isBouncyCastleRegistered() {
        SecurityUtils.register();
        return SecurityUtils.isProviderRegistered(BOUNCY_CASTLE);
    }

    public static boolean isProviderRegistered(String provider) {
        return SecurityUtils.getRegisteredProvider(provider) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderRegistrar getRegisteredProvider(String provider) {
        ValidateUtils.checkNotNullAndNotEmpty(provider, "No provider name specified");
        Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
        synchronized (map) {
            return REGISTERED_PROVIDERS.get(provider);
        }
    }

    public static boolean isRegistrationCompleted() {
        return REGISTRATION_STATE_HOLDER.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register() {
        AtomicBoolean atomicBoolean = REGISTRATION_STATE_HOLDER;
        synchronized (atomicBoolean) {
            SecurityProviderChoice choice;
            if (REGISTRATION_STATE_HOLDER.get()) {
                return;
            }
            String regsList = System.getProperty(SECURITY_PROVIDER_REGISTRARS, GenericUtils.join(DEFAULT_SECURITY_PROVIDER_REGISTRARS, ','));
            boolean bouncyCastleRegistered = false;
            if (GenericUtils.length(regsList) > 0 && !"none".equalsIgnoreCase(regsList)) {
                String[] classes = GenericUtils.split(regsList, ',');
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                for (String registrarClass : classes) {
                    SecurityProviderRegistrar r;
                    try {
                        r = ThreadUtils.createDefaultInstance(SecurityUtils.class, SecurityProviderRegistrar.class, registrarClass);
                    }
                    catch (ReflectiveOperationException t) {
                        Throwable e = GenericUtils.peelException(t);
                        logger.error("Failed ({}) to create default {} registrar instance: {}", new Object[]{e.getClass().getSimpleName(), registrarClass, e.getMessage()});
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                        throw new RuntimeException(e);
                    }
                    String name = r.getName();
                    SecurityProviderRegistrar registeredInstance = SecurityUtils.registerSecurityProvider(r);
                    if (registeredInstance == null) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("register({}) not registered - enabled={}, supported={}", new Object[]{name, r.isEnabled(), r.isSupported()});
                        continue;
                    }
                    if (!BOUNCY_CASTLE.equalsIgnoreCase(name)) continue;
                    bouncyCastleRegistered = true;
                }
            }
            if (((choice = SecurityUtils.getDefaultProviderChoice()) == null || choice == SecurityProviderChoice.EMPTY) && bouncyCastleRegistered) {
                SecurityUtils.setDefaultProviderChoice(SecurityProviderChoice.toSecurityProviderChoice(BOUNCY_CASTLE));
            }
            REGISTRATION_STATE_HOLDER.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityProviderRegistrar registerSecurityProvider(SecurityProviderRegistrar registrar) {
        Objects.requireNonNull(registrar, "No registrar instance to register");
        String name = registrar.getName();
        SecurityProviderRegistrar registeredInstance = SecurityUtils.getRegisteredProvider(name);
        if (registeredInstance == null && registrar.isEnabled() && registrar.isSupported()) {
            try {
                SecurityProviderRegistrar.registerSecurityProvider(registrar);
                Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
                synchronized (map) {
                    REGISTERED_PROVIDERS.put(name, registrar);
                }
                return registrar;
            }
            catch (Throwable t) {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.error("Failed {} to register {} as a JCE provider: {}", new Object[]{t.getClass().getSimpleName(), name, t.getMessage()});
                throw new RuntimeException("Failed to register " + name + " as a JCE provider", t);
            }
        }
        return registeredInstance;
    }

    public static KeyPair loadKeyPairIdentity(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        KeyPairResourceParser parser = SecurityUtils.getKeyPairResourceParser();
        if (parser == null) {
            throw new NoSuchProviderException("No registered key-pair resource parser");
        }
        Collection<KeyPair> ids = parser.loadKeyPairs(resourceKey, provider, inputStream);
        int numLoaded = GenericUtils.size(ids);
        if (numLoaded <= 0) {
            throw new InvalidKeyException("Unsupported private key file format: " + resourceKey);
        }
        if (numLoaded != 1) {
            throw new InvalidKeySpecException("Multiple private key pairs N/A: " + resourceKey);
        }
        return ids.iterator().next();
    }

    public static AbstractGeneratorHostKeyProvider createGeneratorHostKeyProvider(Path path) {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        return new BouncyCastleGeneratorHostKeyProvider(path);
    }

    public static KeyPairResourceParser getBouncycastleKeyPairResourceParser() {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        return BouncyCastleKeyPairResourceParser.INSTANCE;
    }

    public static RandomFactory getRandomFactory() {
        if (SecurityUtils.isBouncyCastleRegistered()) {
            return BouncyCastleRandomFactory.INSTANCE;
        }
        return JceRandomFactory.INSTANCE;
    }

    public static boolean isEDDSACurveSupported() {
        SecurityUtils.register();
        SecurityProviderRegistrar r = SecurityUtils.getRegisteredProvider(EDDSA);
        return r != null && r.isEnabled() && r.isSupported();
    }

    public static PublicKeyEntryDecoder<? extends PublicKey, ? extends PrivateKey> getEDDSAPublicKeyEntryDecoder() {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new UnsupportedOperationException("EdDSA provider N/A");
        }
        return EdDSASecurityProvider.getEDDSAPublicKeyEntryDecoder();
    }

    public static PrivateKeyEntryDecoder<? extends PublicKey, ? extends PrivateKey> getOpenSSHEDDSAPrivateKeyEntryDecoder() {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new UnsupportedOperationException("EdDSA provider N/A");
        }
        return EdDSASecurityProvider.getOpenSSHEDDSAPrivateKeyEntryDecoder();
    }

    public static Signature getEDDSASigner() {
        if (SecurityUtils.isEDDSACurveSupported()) {
            return EdDSASecurityProvider.getEDDSASignature();
        }
        throw new UnsupportedOperationException("EdDSA Signer not available");
    }

    public static int getEDDSAKeySize(Key key) {
        return EdDSASecurityProvider.getEDDSAKeySize(key);
    }

    public static Class<? extends PublicKey> getEDDSAPublicKeyType() {
        return SecurityUtils.isEDDSACurveSupported() ? EdDSASecurityProvider.getEDDSAPublicKeyType() : PublicKey.class;
    }

    public static Class<? extends PrivateKey> getEDDSAPrivateKeyType() {
        return SecurityUtils.isEDDSACurveSupported() ? EdDSASecurityProvider.getEDDSAPrivateKeyType() : PrivateKey.class;
    }

    public static boolean compareEDDSAPPublicKeys(PublicKey k1, PublicKey k2) {
        return SecurityUtils.isEDDSACurveSupported() ? EdDSASecurityProvider.compareEDDSAPPublicKeys(k1, k2) : false;
    }

    public static boolean compareEDDSAPrivateKeys(PrivateKey k1, PrivateKey k2) {
        return SecurityUtils.isEDDSACurveSupported() ? EdDSASecurityProvider.compareEDDSAPrivateKeys(k1, k2) : false;
    }

    public static PublicKey recoverEDDSAPublicKey(PrivateKey key) throws GeneralSecurityException {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        return EdDSASecurityProvider.recoverEDDSAPublicKey(key);
    }

    public static PublicKey generateEDDSAPublicKey(String keyType, byte[] seed) throws GeneralSecurityException {
        if (!"ssh-ed25519".equals(keyType)) {
            throw new InvalidKeyException("Unsupported key type: " + keyType);
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        return EdDSASecurityProvider.generateEDDSAPublicKey(seed);
    }

    public static <B extends Buffer> B putRawEDDSAPublicKey(B buffer, PublicKey key) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new UnsupportedOperationException("EdDSA provider not supported");
        }
        return EdDSASecurityProvider.putRawEDDSAPublicKey(buffer, key);
    }

    public static <B extends Buffer> B putEDDSAKeyPair(B buffer, KeyPair kp) {
        return SecurityUtils.putEDDSAKeyPair(buffer, Objects.requireNonNull(kp, "No key pair").getPublic(), kp.getPrivate());
    }

    public static <B extends Buffer> B putEDDSAKeyPair(B buffer, PublicKey pubKey, PrivateKey prvKey) {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new UnsupportedOperationException("EdDSA provider not supported");
        }
        return EdDSASecurityProvider.putEDDSAKeyPair(buffer, pubKey, prvKey);
    }

    public static KeyPair extractEDDSAKeyPair(Buffer buffer, String keyType) throws GeneralSecurityException {
        if (!"ssh-ed25519".equals(keyType)) {
            throw new InvalidKeyException("Unsupported key type: " + keyType);
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        throw new GeneralSecurityException("Full SSHD-440 implementation N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPairResourceParser getKeyPairResourceParser() {
        KeyPairResourceParser parser;
        AtomicReference<KeyPairResourceParser> atomicReference = KEYPAIRS_PARSER_HODLER;
        synchronized (atomicReference) {
            parser = KEYPAIRS_PARSER_HODLER.get();
            if (parser != null) {
                return parser;
            }
            parser = KeyPairResourceParser.aggregate(PEMResourceParserUtils.PROXY, OpenSSHKeyPairResourceParser.INSTANCE);
            KEYPAIRS_PARSER_HODLER.set(parser);
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKeyPairResourceParser(KeyPairResourceParser parser) {
        AtomicReference<KeyPairResourceParser> atomicReference = KEYPAIRS_PARSER_HODLER;
        synchronized (atomicReference) {
            KEYPAIRS_PARSER_HODLER.set(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> SecurityEntityFactory<T> resolveSecurityEntityFactory(Class<T> entityType, String algorithm, Predicate<? super SecurityProviderRegistrar> entitySelector) {
        SecurityEntityFactory factoryEntry;
        Map factoriesMap;
        Map<Class<?>, Map<String, SecurityEntityFactory<?>>> map = SECURITY_ENTITY_FACTORIES;
        synchronized (map) {
            factoriesMap = SECURITY_ENTITY_FACTORIES.computeIfAbsent(entityType, k -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        }
        String effectiveName = SecurityProviderRegistrar.getEffectiveSecurityEntityName(entityType, algorithm);
        Map map2 = factoriesMap;
        synchronized (map2) {
            factoryEntry = factoriesMap.computeIfAbsent(effectiveName, k -> SecurityUtils.createSecurityEntityFactory(entityType, entitySelector));
        }
        return factoryEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> SecurityEntityFactory<T> createSecurityEntityFactory(Class<T> entityType, Predicate<? super SecurityProviderRegistrar> entitySelector) {
        SecurityProviderRegistrar registrar;
        SecurityUtils.register();
        Map<String, SecurityProviderRegistrar> map = REGISTERED_PROVIDERS;
        synchronized (map) {
            registrar = SecurityProviderRegistrar.findSecurityProviderRegistrarBySecurityEntity(entitySelector, REGISTERED_PROVIDERS.values());
        }
        try {
            return SecurityEntityFactory.toFactory(entityType, registrar, SecurityUtils.getDefaultProviderChoice());
        }
        catch (ReflectiveOperationException t) {
            Throwable e = GenericUtils.peelException(t);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static KeyFactory getKeyFactory(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory<KeyFactory> factory = SecurityUtils.resolveSecurityEntityFactory(KeyFactory.class, algorithm, r -> r.isKeyFactorySupported(algorithm));
        return factory.getInstance(algorithm);
    }

    public static Cipher getCipher(String transformation) throws GeneralSecurityException {
        SecurityEntityFactory<Cipher> factory = SecurityUtils.resolveSecurityEntityFactory(Cipher.class, transformation, r -> r.isCipherSupported(transformation));
        return factory.getInstance(transformation);
    }

    public static MessageDigest getMessageDigest(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory<MessageDigest> factory = SecurityUtils.resolveSecurityEntityFactory(MessageDigest.class, algorithm, r -> r.isMessageDigestSupported(algorithm));
        return factory.getInstance(algorithm);
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory<KeyPairGenerator> factory = SecurityUtils.resolveSecurityEntityFactory(KeyPairGenerator.class, algorithm, r -> r.isKeyPairGeneratorSupported(algorithm));
        return factory.getInstance(algorithm);
    }

    public static KeyAgreement getKeyAgreement(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory<KeyAgreement> factory = SecurityUtils.resolveSecurityEntityFactory(KeyAgreement.class, algorithm, r -> r.isKeyAgreementSupported(algorithm));
        return factory.getInstance(algorithm);
    }

    public static Mac getMac(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory<Mac> factory = SecurityUtils.resolveSecurityEntityFactory(Mac.class, algorithm, r -> r.isMacSupported(algorithm));
        return factory.getInstance(algorithm);
    }

    public static java.security.Signature getSignature(String algorithm) throws GeneralSecurityException {
        SecurityEntityFactory<java.security.Signature> factory = SecurityUtils.resolveSecurityEntityFactory(java.security.Signature.class, algorithm, r -> r.isSignatureSupported(algorithm));
        return factory.getInstance(algorithm);
    }

    public static CertificateFactory getCertificateFactory(String type) throws GeneralSecurityException {
        SecurityEntityFactory<CertificateFactory> factory = SecurityUtils.resolveSecurityEntityFactory(CertificateFactory.class, type, r -> r.isCertificateFactorySupported(type));
        return factory.getInstance(type);
    }
}

