/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.FilledArea;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.Constants;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.ImageAdapter;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.XMLHandlerConfigurator;
import org.w3c.dom.Document;

public abstract class AbstractRenderer
implements Renderer,
Constants {
    protected static final Log log = LogFactory.getLog((String)"org.apache.fop.render");
    protected FOUserAgent userAgent = null;
    protected int currentBPPosition = 0;
    protected int currentIPPosition = 0;
    protected int containingBPPosition = 0;
    protected int containingIPPosition = 0;
    protected PageViewport currentPageViewport;
    private Set warnedXMLHandlers;

    public abstract void setupFontInfo(FontInfo var1) throws FOPException;

    public AbstractRenderer(FOUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        if (this.userAgent == null) {
            throw new IllegalStateException("FOUserAgent has not been set on Renderer");
        }
    }

    public void stopRenderer() throws IOException {
    }

    public boolean supportsOutOfOrder() {
        return false;
    }

    public void setDocumentLocale(Locale locale) {
    }

    public void processOffDocumentItem(OffDocumentItem odi) {
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return null;
    }

    public ImageAdapter getImageAdapter() {
        return null;
    }

    protected PageViewport getCurrentPageViewport() {
        return this.currentPageViewport;
    }

    public void preparePage(PageViewport page) {
    }

    protected String convertTitleToString(LineArea title) {
        List children = title.getInlineAreas();
        String str = this.convertToString(children);
        return str.trim();
    }

    private String convertToString(List children) {
        StringBuffer sb = new StringBuffer();
        for (int count = 0; count < children.size(); ++count) {
            InlineArea inline = (InlineArea)children.get(count);
            if (inline instanceof TextArea) {
                sb.append(((TextArea)inline).getText());
                continue;
            }
            if (inline instanceof InlineParent) {
                sb.append(this.convertToString(((InlineParent)inline).getChildAreas()));
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public void startPageSequence(LineArea seqTitle) {
    }

    public void startPageSequence(PageSequence pageSequence) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(PageViewport page) throws IOException, FOPException {
        this.currentPageViewport = page;
        try {
            Page p = page.getPage();
            this.renderPageAreas(p);
        }
        finally {
            this.currentPageViewport = null;
        }
    }

    protected void renderPageAreas(Page page) {
        RegionViewport viewport = page.getRegionViewport(57);
        if (viewport != null) {
            this.renderRegionViewport(viewport);
        }
        if ((viewport = page.getRegionViewport(61)) != null) {
            this.renderRegionViewport(viewport);
        }
        if ((viewport = page.getRegionViewport(59)) != null) {
            this.renderRegionViewport(viewport);
        }
        if ((viewport = page.getRegionViewport(56)) != null) {
            this.renderRegionViewport(viewport);
        }
        if ((viewport = page.getRegionViewport(58)) != null) {
            this.renderRegionViewport(viewport);
        }
    }

    protected void renderRegionViewport(RegionViewport port) {
        this.currentBPPosition = 0;
        this.currentIPPosition = 0;
        RegionReference regionReference = port.getRegionReference();
        this.handleRegionTraits(port);
        this.startVParea(regionReference.getCTM(), port.getClipRectangle());
        if (regionReference.getRegionClass() == 58) {
            this.renderBodyRegion((BodyRegion)regionReference);
        } else {
            this.renderRegion(regionReference);
        }
        this.endVParea();
    }

    protected abstract void startVParea(CTM var1, Rectangle var2);

    protected abstract void endVParea();

    protected void handleRegionTraits(RegionViewport rv) {
    }

    protected void renderRegion(RegionReference region) {
        this.renderBlocks(null, region.getBlocks());
    }

    protected void renderBodyRegion(BodyRegion region) {
        Footnote foot;
        MainReference mr;
        BeforeFloat bf = region.getBeforeFloat();
        if (bf != null) {
            this.renderBeforeFloat(bf);
        }
        if ((mr = region.getMainReference()) != null) {
            this.renderMainReference(mr);
        }
        if ((foot = region.getFootnote()) != null) {
            this.renderFootnote(foot);
        }
    }

    protected void renderBeforeFloat(BeforeFloat bf) {
        List blocks = bf.getChildAreas();
        if (blocks != null) {
            this.renderBlocks(null, blocks);
            Block sep = bf.getSeparator();
            if (sep != null) {
                this.renderBlock(sep);
            }
        }
    }

    protected void renderFootnote(Footnote footnote) {
        this.currentBPPosition += footnote.getTop();
        List blocks = footnote.getChildAreas();
        if (blocks != null) {
            Block sep = footnote.getSeparator();
            if (sep != null) {
                this.renderBlock(sep);
            }
            this.renderBlocks(null, blocks);
        }
    }

    protected void renderMainReference(MainReference mr) {
        int saveBPPos;
        Span span = null;
        List spans = mr.getSpans();
        int saveSpanBPPos = saveBPPos = this.currentBPPosition;
        int saveIPPos = this.currentIPPosition;
        for (int count = 0; count < spans.size(); ++count) {
            span = (Span)spans.get(count);
            int level = span.getBidiLevel();
            if (level < 0) {
                level = 0;
            }
            if ((level & 1) == 1) {
                this.currentIPPosition += span.getIPD();
                this.currentIPPosition += mr.getColumnGap();
            }
            for (int c = 0; c < span.getColumnCount(); ++c) {
                NormalFlow flow = span.getNormalFlow(c);
                if (flow == null) continue;
                this.currentBPPosition = saveSpanBPPos;
                if ((level & 1) == 1) {
                    this.currentIPPosition -= flow.getIPD();
                    this.currentIPPosition -= mr.getColumnGap();
                }
                this.renderFlow(flow);
                if ((level & 1) != 0) continue;
                this.currentIPPosition += flow.getIPD();
                this.currentIPPosition += mr.getColumnGap();
            }
            this.currentIPPosition = saveIPPos;
            saveSpanBPPos = this.currentBPPosition = saveSpanBPPos + span.getHeight();
        }
        this.currentBPPosition = saveBPPos;
    }

    protected void renderFlow(NormalFlow flow) {
        List blocks = flow.getChildAreas();
        if (blocks != null) {
            this.renderBlocks(null, blocks);
        }
    }

    protected void handleBlockTraits(Block block) {
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        if (bv.getPositioning() == 2) {
            int saveIP = this.currentIPPosition;
            int saveBP = this.currentBPPosition;
            Rectangle clippingRect = null;
            if (bv.hasClip()) {
                clippingRect = new Rectangle(saveIP, saveBP, bv.getIPD(), bv.getBPD());
            }
            CTM ctm = bv.getCTM();
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.startVParea(ctm, clippingRect);
            this.handleBlockTraits(bv);
            this.renderBlocks(bv, children);
            this.endVParea();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            int saveIP = this.currentIPPosition;
            int saveBP = this.currentBPPosition;
            this.handleBlockTraits(bv);
            this.renderBlocks(bv, children);
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP + bv.getAllocBPD();
        }
    }

    protected abstract void renderReferenceArea(Block var1);

    protected void renderBlocks(Block parent, List blocks) {
        int saveIP = this.currentIPPosition;
        if (parent != null && !parent.getTraitAsBoolean(Trait.IS_VIEWPORT_AREA)) {
            this.currentBPPosition += parent.getBorderAndPaddingWidthBefore();
        }
        int contBP = this.currentBPPosition;
        int contIP = this.currentIPPosition;
        this.containingBPPosition = this.currentBPPosition;
        this.containingIPPosition = this.currentIPPosition;
        for (int count = 0; count < blocks.size(); ++count) {
            Object obj = blocks.get(count);
            if (obj instanceof Block) {
                this.currentIPPosition = contIP;
                this.containingBPPosition = contBP;
                this.containingIPPosition = contIP;
                this.renderBlock((Block)obj);
                this.containingBPPosition = contBP;
                this.containingIPPosition = contIP;
            } else if (obj instanceof LineArea) {
                LineArea line = (LineArea)obj;
                if (parent != null) {
                    int level = parent.getBidiLevel();
                    this.currentIPPosition = level == -1 || (level & 1) == 0 ? (this.currentIPPosition += parent.getStartIndent()) : (this.currentIPPosition += parent.getEndIndent());
                }
                this.renderLineArea(line);
                this.currentBPPosition += line.getAllocBPD();
            }
            this.currentIPPosition = saveIP;
        }
    }

    protected void renderBlock(Block block) {
        assert (block != null);
        List children = block.getChildAreas();
        if (block instanceof BlockViewport) {
            if (children != null) {
                this.renderBlockViewport((BlockViewport)block, children);
            } else {
                this.handleBlockTraits(block);
                this.currentBPPosition += block.getAllocBPD();
            }
        } else if (block.getTraitAsBoolean(Trait.IS_REFERENCE_AREA)) {
            this.renderReferenceArea(block);
        } else {
            int saveIP = this.currentIPPosition;
            int saveBP = this.currentBPPosition;
            this.currentIPPosition += block.getXOffset();
            this.currentBPPosition += block.getYOffset();
            this.currentBPPosition += block.getSpaceBefore();
            this.handleBlockTraits(block);
            if (children != null) {
                this.renderBlocks(block, children);
            }
            if (block.getPositioning() == 2) {
                this.currentBPPosition = saveBP;
            } else {
                this.currentIPPosition = saveIP;
                this.currentBPPosition = saveBP + block.getAllocBPD();
            }
        }
    }

    protected void renderLineArea(LineArea line) {
        List children = line.getInlineAreas();
        int saveBP = this.currentBPPosition;
        this.currentBPPosition += line.getSpaceBefore();
        int bl = line.getBidiLevel();
        if (bl >= 0) {
            if ((bl & 1) == 0) {
                this.currentIPPosition += line.getStartIndent();
            } else {
                this.currentIPPosition += line.getEndIndent();
                int overflow = this.computeInlinesOverflow(line);
                if (overflow > 0) {
                    this.currentIPPosition -= overflow;
                }
            }
        } else {
            this.currentIPPosition += line.getStartIndent();
        }
        int l = children.size();
        for (int i = 0; i < l; ++i) {
            InlineArea inline = (InlineArea)children.get(i);
            this.renderInlineArea(inline);
        }
        this.currentBPPosition = saveBP;
    }

    private int computeInlinesOverflow(LineArea line) {
        List children = line.getInlineAreas();
        int ipdConsumed = 0;
        int l = children.size();
        for (int i = 0; i < l; ++i) {
            InlineArea inline = (InlineArea)children.get(i);
            ipdConsumed += inline.getIPD();
        }
        return ipdConsumed - line.getIPD();
    }

    protected void renderInlineArea(InlineArea inlineArea) {
        if (inlineArea instanceof TextArea) {
            this.renderText((TextArea)inlineArea);
        } else if (inlineArea instanceof WordArea) {
            this.renderWord((WordArea)inlineArea);
        } else if (inlineArea instanceof SpaceArea) {
            this.renderSpace((SpaceArea)inlineArea);
        } else if (inlineArea instanceof InlineParent) {
            this.renderInlineParent((InlineParent)inlineArea);
        } else if (inlineArea instanceof InlineBlockParent) {
            this.renderInlineBlockParent((InlineBlockParent)inlineArea);
        } else if (inlineArea instanceof Space) {
            this.renderInlineSpace((Space)inlineArea);
        } else if (inlineArea instanceof InlineViewport) {
            this.renderInlineViewport((InlineViewport)inlineArea);
        } else if (inlineArea instanceof Leader) {
            this.renderLeader((Leader)inlineArea);
        }
    }

    protected abstract void renderInlineAreaBackAndBorders(InlineArea var1);

    protected void renderInlineSpace(Space space) {
        this.renderInlineAreaBackAndBorders(space);
        this.currentIPPosition += space.getAllocIPD();
    }

    protected void renderLeader(Leader area) {
        this.currentIPPosition += area.getAllocIPD();
    }

    protected void renderText(TextArea text) {
        List<InlineArea> children = text.getChildAreas();
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        int l = children.size();
        for (int i = 0; i < l; ++i) {
            InlineArea inline = children.get(i);
            this.renderInlineArea(inline);
        }
        this.currentIPPosition = saveIP + text.getAllocIPD();
    }

    protected void renderWord(WordArea word) {
        this.currentIPPosition += word.getAllocIPD();
    }

    protected void renderSpace(SpaceArea space) {
        this.currentIPPosition += space.getAllocIPD();
    }

    protected void renderInlineParent(InlineParent ip) {
        int ipAdjust;
        int level = ip.getBidiLevel();
        List<InlineArea> children = ip.getChildAreas();
        this.renderInlineAreaBackAndBorders(ip);
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        if (ip instanceof FilledArea && (level & 1) != 0) {
            int ipdChildren = 0;
            int l = children.size();
            for (int i = 0; i < l; ++i) {
                InlineArea inline = children.get(i);
                ipdChildren += inline.getAllocIPD();
            }
            ipAdjust = ip.getAllocIPD() - ipdChildren;
        } else {
            ipAdjust = 0;
        }
        if (level == -1 || (level & 1) == 0) {
            this.currentIPPosition += ip.getBorderAndPaddingWidthStart();
        } else {
            this.currentIPPosition += ip.getBorderAndPaddingWidthEnd();
            if (ipAdjust > 0) {
                this.currentIPPosition += ipAdjust;
            }
        }
        this.currentBPPosition += ip.getBlockProgressionOffset();
        int l = children.size();
        for (int i = 0; i < l; ++i) {
            InlineArea inline = children.get(i);
            this.renderInlineArea(inline);
        }
        this.currentIPPosition = saveIP + ip.getAllocIPD();
        this.currentBPPosition = saveBP;
    }

    protected void renderInlineBlockParent(InlineBlockParent ibp) {
        int level = ibp.getBidiLevel();
        this.renderInlineAreaBackAndBorders(ibp);
        this.currentIPPosition = level == -1 || (level & 1) == 0 ? (this.currentIPPosition += ibp.getBorderAndPaddingWidthStart()) : (this.currentIPPosition += ibp.getBorderAndPaddingWidthEnd());
        int saveBP = this.currentBPPosition;
        this.currentBPPosition += ibp.getBlockProgressionOffset();
        this.renderBlock(ibp.getChildArea());
        this.currentBPPosition = saveBP;
    }

    protected void renderInlineViewport(InlineViewport viewport) {
        Area content = viewport.getContent();
        int saveBP = this.currentBPPosition;
        this.currentBPPosition += viewport.getBlockProgressionOffset();
        Rectangle2D contpos = viewport.getContentPosition();
        if (content instanceof Image) {
            this.renderImage((Image)content, contpos);
        } else if (content instanceof Container) {
            this.renderContainer((Container)content);
        } else if (content instanceof ForeignObject) {
            this.renderForeignObject((ForeignObject)content, contpos);
        } else if (content instanceof InlineBlockParent) {
            this.renderInlineBlockParent((InlineBlockParent)content);
        }
        this.currentIPPosition += viewport.getAllocIPD();
        this.currentBPPosition = saveBP;
    }

    public void renderImage(Image image, Rectangle2D pos) {
    }

    protected void renderContainer(Container cont) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        List blocks = cont.getBlocks();
        this.renderBlocks(null, blocks);
        this.currentIPPosition = saveIP;
        this.currentBPPosition = saveBP;
    }

    protected void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
    }

    public void renderXML(RendererContext ctx, Document doc, String namespace) {
        XMLHandler handler = this.userAgent.getXMLHandlerRegistry().getXMLHandler((Renderer)this, namespace);
        if (handler != null) {
            try {
                XMLHandlerConfigurator configurator = new XMLHandlerConfigurator(this.userAgent);
                configurator.configure(ctx, namespace);
                handler.handleXML(ctx, doc, namespace);
            }
            catch (Exception e) {
                ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(ctx.getUserAgent().getEventBroadcaster());
                eventProducer.foreignXMLProcessingError(this, doc, namespace, e);
            }
        } else {
            if (this.warnedXMLHandlers == null) {
                this.warnedXMLHandlers = new HashSet();
            }
            if (!this.warnedXMLHandlers.contains(namespace)) {
                this.warnedXMLHandlers.add(namespace);
                ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(ctx.getUserAgent().getEventBroadcaster());
                eventProducer.foreignXMLNoHandler(this, doc, namespace);
            }
        }
    }

    protected AffineTransform mptToPt(AffineTransform at) {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        matrix[4] = matrix[4] / 1000.0;
        matrix[5] = matrix[5] / 1000.0;
        return new AffineTransform(matrix);
    }

    protected AffineTransform ptToMpt(AffineTransform at) {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        matrix[4] = Math.round(matrix[4] * 1000.0);
        matrix[5] = Math.round(matrix[5] * 1000.0);
        return new AffineTransform(matrix);
    }
}

