/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.CompressedObject;
import org.apache.fop.pdf.ObjectStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.xref.CompressedObjectReference;

class ObjectStreamManager {
    private static final int OBJECT_STREAM_CAPACITY = 100;
    private final PDFDocument pdfDocument;
    private final List<CompressedObjectReference> compressedObjectReferences;
    private int numObjectsInStream;
    private ObjectStream currentObjectStream;

    ObjectStreamManager(PDFDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.createObjectStream();
        this.compressedObjectReferences = new ArrayList<CompressedObjectReference>();
    }

    void add(CompressedObject compressedObject) {
        if (this.numObjectsInStream++ == 100) {
            this.createObjectStream();
            this.numObjectsInStream = 1;
        }
        this.compressedObjectReferences.add(this.currentObjectStream.addObject(compressedObject));
    }

    private void createObjectStream() {
        this.currentObjectStream = this.currentObjectStream == null ? new ObjectStream() : new ObjectStream(this.currentObjectStream);
        this.pdfDocument.assignObjectNumber(this.currentObjectStream);
        this.pdfDocument.addTrailerObject(this.currentObjectStream);
    }

    List<CompressedObjectReference> getCompressedObjectReferences() {
        return this.compressedObjectReferences;
    }
}

