/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.concurrent.Callable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Fail;

public class ThrowableAssert
extends AbstractThrowableAssert<ThrowableAssert, Throwable> {
    private static final String WRONG_EXCEPTION_TYPE = "Expecting code to throw <%s> but threw <%s> instead";

    public ThrowableAssert(Throwable actual) {
        super(actual, ThrowableAssert.class);
    }

    public <V> ThrowableAssert(Callable<V> runnable) {
        super(ThrowableAssert.buildThrowableAssertFromCallable(runnable), ThrowableAssert.class);
    }

    private static <V> Throwable buildThrowableAssertFromCallable(Callable<V> callable) throws AssertionError {
        try {
            callable.call();
            Fail.fail("Expecting code to throw an exception.");
            return null;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            return throwable;
        }
    }

    public static Throwable catchThrowable(ThrowingCallable shouldRaiseThrowable) {
        try {
            shouldRaiseThrowable.call();
        }
        catch (Throwable throwable) {
            return throwable;
        }
        return null;
    }

    public static <THROWABLE extends Throwable> THROWABLE catchThrowableOfType(ThrowingCallable shouldRaiseThrowable, Class<THROWABLE> type) {
        Throwable throwable = ThrowableAssert.catchThrowable(shouldRaiseThrowable);
        if (throwable == null) {
            return null;
        }
        ((ThrowableAssert)new ThrowableAssert(throwable).overridingErrorMessage(WRONG_EXCEPTION_TYPE, type, throwable.getClass())).isInstanceOf((Class)type);
        return (THROWABLE)throwable;
    }

    public static interface ThrowingCallable {
        public void call() throws Throwable;
    }
}

