/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.extractor;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.extractor.ByNameSingleExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.util.Preconditions;

public class ByNameMultipleExtractor<T>
implements Extractor<T, Tuple> {
    private final String[] fieldsOrProperties;

    public ByNameMultipleExtractor(String ... fieldsOrProperties) {
        this.fieldsOrProperties = fieldsOrProperties;
    }

    @Override
    public Tuple extract(T input) {
        Preconditions.checkArgument(this.fieldsOrProperties != null, "The names of the fields/properties to read should not be null", new Object[0]);
        Preconditions.checkArgument(this.fieldsOrProperties.length > 0, "The names of the fields/properties to read should not be empty", new Object[0]);
        Preconditions.checkArgument(input != null, "The object to extract fields/properties from should not be null", new Object[0]);
        List<Extractor<T, Object>> extractors = this.buildExtractors();
        List<Object> values = this.extractValues(input, extractors);
        return new Tuple(values.toArray());
    }

    private List<Object> extractValues(T input, List<Extractor<T, Object>> singleExtractors) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Extractor<T, Object> extractor : singleExtractors) {
            values.add(extractor.extract(input));
        }
        return values;
    }

    private List<Extractor<T, Object>> buildExtractors() {
        ArrayList<Extractor<T, Object>> result = new ArrayList<Extractor<T, Object>>();
        for (String name : this.fieldsOrProperties) {
            result.add(new ByNameSingleExtractor(name));
        }
        return result;
    }
}

