/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketTags;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.util.io.Streams;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    InputStream in;

    public SignatureSubpacketInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public SignatureSubpacket readPacket() throws IOException {
        int n = this.read();
        int n2 = 0;
        if (n < 0) {
            return null;
        }
        if (n < 192) {
            n2 = n;
        } else if (n <= 223) {
            n2 = (n - 192 << 8) + this.in.read() + 192;
        } else if (n == 255) {
            n2 = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
        }
        int n3 = this.in.read();
        if (n3 < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        byte[] byArray = new byte[n2 - 1];
        if (Streams.readFully((InputStream)this.in, (byte[])byArray) < byArray.length) {
            throw new EOFException();
        }
        boolean bl = (n3 & 0x80) != 0;
        int n4 = n3 & 0x7F;
        switch (n4) {
            case 2: {
                return new SignatureCreationTime(bl, byArray);
            }
            case 9: {
                return new KeyExpirationTime(bl, byArray);
            }
            case 3: {
                return new SignatureExpirationTime(bl, byArray);
            }
            case 7: {
                return new Revocable(bl, byArray);
            }
            case 4: {
                return new Exportable(bl, byArray);
            }
            case 16: {
                return new IssuerKeyID(bl, byArray);
            }
            case 5: {
                return new TrustSignature(bl, byArray);
            }
            case 11: 
            case 21: 
            case 22: {
                return new PreferredAlgorithms(n4, bl, byArray);
            }
            case 27: {
                return new KeyFlags(bl, byArray);
            }
            case 25: {
                return new PrimaryUserID(bl, byArray);
            }
            case 28: {
                return new SignerUserID(bl, byArray);
            }
            case 20: {
                return new NotationData(bl, byArray);
            }
        }
        return new SignatureSubpacket(n4, bl, byArray);
    }
}

