/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.utils.Uid;
import javax.transaction.xa.Xid;

public class BitronixXid
implements Xid {
    public static final int FORMAT_ID = 1114926712;
    private Uid globalTransactionId;
    private Uid branchQualifier;

    public BitronixXid(Uid globalTransactionId, Uid branchQualifier) {
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
    }

    public BitronixXid(Xid xid) {
        this.globalTransactionId = new Uid(xid.getGlobalTransactionId());
        this.branchQualifier = new Uid(xid.getBranchQualifier());
    }

    public int getFormatId() {
        return 1114926712;
    }

    public byte[] getBranchQualifier() {
        return this.branchQualifier.getArray();
    }

    public Uid getBranchQualifierUid() {
        return this.branchQualifier;
    }

    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId.getArray();
    }

    public Uid getGlobalTransactionIdUid() {
        return this.globalTransactionId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(288);
        sb.append("a Bitronix XID [");
        sb.append(this.globalTransactionId.toString());
        sb.append(" : ");
        sb.append(this.branchQualifier.toString());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BitronixXid)) {
            return false;
        }
        BitronixXid otherXid = (BitronixXid)obj;
        return 1114926712 == otherXid.getFormatId() && this.globalTransactionId.equals(otherXid.getGlobalTransactionIdUid()) && this.branchQualifier.equals(otherXid.getBranchQualifierUid());
    }

    public int hashCode() {
        int hashCode = 1114926712;
        if (this.globalTransactionId != null) {
            hashCode += this.globalTransactionId.hashCode();
        }
        if (this.branchQualifier != null) {
            hashCode += this.branchQualifier.hashCode();
        }
        return hashCode;
    }
}

