/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.journal.DiskForceWaitQueue;
import bitronix.tm.journal.TransactionLogAppender;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskForceBatcherThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DiskForceBatcherThread.class);
    private static DiskForceBatcherThread instance;
    private volatile boolean alive = true;
    private volatile DiskForceWaitQueue waitQueue = new DiskForceWaitQueue();

    public static synchronized DiskForceBatcherThread getInstance() {
        if (instance == null) {
            instance = new DiskForceBatcherThread();
        }
        return instance;
    }

    private DiskForceBatcherThread() {
        this.setName("bitronix-disk-force-batcher");
        this.setPriority(4);
        this.setDaemon(true);
        this.start();
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void enqueue(TransactionLogAppender tla) {
        block6: {
            DiskForceWaitQueue currrentWaitQueue = this.waitQueue;
            while (!currrentWaitQueue.enqueue(tla)) {
                if (log.isDebugEnabled()) {
                    log.debug("current DiskForceWaitQueue [" + currrentWaitQueue + "] is cleared, trying next one: [" + this.waitQueue + "]");
                }
                currrentWaitQueue = this.waitQueue;
            }
            if (log.isDebugEnabled()) {
                log.debug("batching disk force, there are " + currrentWaitQueue.size() + " TransactionLogAppender(s) in the wait queue");
            }
            try {
                currrentWaitQueue.waitUntilNotContains(tla);
            }
            catch (InterruptedException ex) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("interrupted while waiting for journal log to be forced, ignored as disk force will happen anyway");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("wait queue got emptied, disk force is done");
        }
    }

    private void runForceBatch() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("waiting for the wait queue to fill up");
        }
        while (this.alive && this.waitQueue.isEmpty()) {
            try {
                this.waitQueue.waitUntilNotEmpty();
            }
            catch (InterruptedException ex) {}
        }
        if (!this.alive) {
            if (log.isDebugEnabled()) {
                log.debug("interrupted while waiting for the queue to fill up");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("wait queue is not empty anymore (" + this.waitQueue.size() + " in queue)");
        }
        DiskForceWaitQueue oldWaitQueue = this.waitQueue;
        this.waitQueue = new DiskForceWaitQueue();
        if (log.isDebugEnabled()) {
            log.debug("forcing...");
        }
        oldWaitQueue.head().doForce();
        oldWaitQueue.clear();
    }

    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("disk force thread is up and running");
        }
        while (this.alive) {
            try {
                this.runForceBatch();
            }
            catch (Exception ex) {
                log.warn("unexpected Exception", (Throwable)ex);
            }
        }
        instance = null;
        if (log.isDebugEnabled()) {
            log.debug("disk force thread has terminated");
        }
    }

    public String toString() {
        return "a DiskForceBatcherThread";
    }
}

