/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.lrc;

import bitronix.tm.resource.jdbc.BaseProxyHandlerClass;
import bitronix.tm.resource.jdbc.lrc.LrcConnectionHandle;
import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LrcXAConnection
extends BaseProxyHandlerClass {
    private static final Logger log = LoggerFactory.getLogger(LrcXAConnection.class);
    private Connection connection;
    private LrcXAResource xaResource;
    private List connectionEventListeners = new ArrayList();

    public LrcXAConnection(Connection connection) {
        this.connection = connection;
        this.xaResource = new LrcXAResource(connection);
    }

    public XAResource getXAResource() throws SQLException {
        return this.xaResource;
    }

    public void close() throws SQLException {
        this.connection.close();
        this.fireCloseEvent();
    }

    public Connection getConnection() throws SQLException {
        LrcConnectionHandle lrcConnectionHandle = new LrcConnectionHandle(this.xaResource, this.connection);
        return (Connection)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)lrcConnectionHandle);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    private void fireCloseEvent() {
        if (log.isDebugEnabled()) {
            log.debug("notifying " + this.connectionEventListeners.size() + " connectionEventListeners(s) about closing of " + this);
        }
        for (int i = 0; i < this.connectionEventListeners.size(); ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.get(i);
            XAConnection conn = (XAConnection)Proxy.newProxyInstance(ClassLoaderUtils.getClassLoader(), new Class[]{XAConnection.class}, (InvocationHandler)this);
            connectionEventListener.connectionClosed(new ConnectionEvent(conn));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LrcXAConnection)) {
            return false;
        }
        LrcXAConnection other = (LrcXAConnection)obj;
        return this.connection.equals(other.connection);
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public String toString() {
        return "a JDBC LrcXAConnection on " + this.connection;
    }

    public Object getProxiedDelegate() throws Exception {
        return this.connection;
    }
}

