/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.resource.common.XAPool;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TaskException;
import bitronix.tm.timer.TaskScheduler;
import java.util.Date;

public class PoolShrinkingTask
extends Task {
    private XAPool xaPool;

    public PoolShrinkingTask(XAPool xaPool, Date executionTime, TaskScheduler scheduler) {
        super(executionTime, scheduler);
        this.xaPool = xaPool;
    }

    public Object getObject() {
        return this.xaPool;
    }

    public void execute() throws TaskException {
        try {
            this.xaPool.shrink();
        }
        catch (Exception ex) {
            throw new TaskException("error while trying to shrink " + this.xaPool, ex);
        }
        finally {
            this.getTaskScheduler().schedulePoolShrinking(this.xaPool);
        }
    }

    public String toString() {
        return "a PoolShrinkingTask scheduled for " + this.getExecutionTime() + " on " + this.xaPool;
    }
}

