/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.recovery.Recoverer;
import bitronix.tm.resource.common.XAPool;
import bitronix.tm.timer.PoolShrinkingTask;
import bitronix.tm.timer.RecoveryTask;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TransactionTimeoutTask;
import bitronix.tm.utils.Service;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScheduler
extends Thread
implements Service {
    private static final Logger log = LoggerFactory.getLogger(TaskScheduler.class);
    private final List tasks = Collections.synchronizedList(new ArrayList());
    private volatile boolean active = true;

    public TaskScheduler() {
        this.setDaemon(true);
        this.setName("bitronix-scheduler");
    }

    public int countTasksQueued() {
        return this.tasks.size();
    }

    public synchronized void shutdown() {
        try {
            long gracefulShutdownTime = TransactionManagerServices.getConfiguration().getGracefulShutdownInterval() * 1000;
            if (log.isDebugEnabled()) {
                log.debug("graceful scheduler shutdown interval: " + gracefulShutdownTime + "ms");
            }
            this.setActive(false);
            this.join(gracefulShutdownTime);
        }
        catch (InterruptedException ex) {
            log.error("could not stop the task scheduler within " + TransactionManagerServices.getConfiguration().getGracefulShutdownInterval() + "s");
        }
    }

    public void scheduleTransactionTimeout(BitronixTransaction transaction, Date executionTime) {
        if (log.isDebugEnabled()) {
            log.debug("scheduling transaction timeout task on " + transaction + " for " + executionTime);
        }
        if (transaction == null) {
            throw new IllegalArgumentException("expected a non-null transaction");
        }
        if (executionTime == null) {
            throw new IllegalArgumentException("expected a non-null execution date");
        }
        TransactionTimeoutTask task = new TransactionTimeoutTask(transaction, executionTime, this);
        this.addTask(task);
        if (log.isDebugEnabled()) {
            log.debug("scheduled " + task + ", total task(s) queued: " + this.tasks.size());
        }
    }

    public void cancelTransactionTimeout(BitronixTransaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug("cancelling transaction timeout task on " + transaction);
        }
        if (transaction == null) {
            throw new IllegalArgumentException("expected a non-null transaction");
        }
        if (!this.removeTaskByObject(transaction) && log.isDebugEnabled()) {
            log.debug("no task found based on object " + transaction);
        }
    }

    public void scheduleRecovery(Recoverer recoverer, Date executionTime) {
        if (log.isDebugEnabled()) {
            log.debug("scheduling recovery task for " + executionTime);
        }
        if (recoverer == null) {
            throw new IllegalArgumentException("expected a non-null recoverer");
        }
        if (executionTime == null) {
            throw new IllegalArgumentException("expected a non-null execution date");
        }
        RecoveryTask task = new RecoveryTask(recoverer, executionTime, this);
        this.addTask(task);
        if (log.isDebugEnabled()) {
            log.debug("scheduled " + task + ", total task(s) queued: " + this.tasks.size());
        }
    }

    public void cancelRecovery(Recoverer recoverer) {
        if (log.isDebugEnabled()) {
            log.debug("cancelling recovery task");
        }
        if (!this.removeTaskByObject(recoverer) && log.isDebugEnabled()) {
            log.debug("no task found based on object " + recoverer);
        }
    }

    public void schedulePoolShrinking(XAPool xaPool) {
        Date executionTime = xaPool.getNextShrinkDate();
        if (log.isDebugEnabled()) {
            log.debug("scheduling pool shrinking task on " + xaPool + " for " + executionTime);
        }
        if (executionTime == null) {
            throw new IllegalArgumentException("expected a non-null execution date");
        }
        PoolShrinkingTask task = new PoolShrinkingTask(xaPool, executionTime, this);
        this.addTask(task);
        if (log.isDebugEnabled()) {
            log.debug("scheduled " + task + ", total task(s) queued: " + this.tasks.size());
        }
    }

    public void cancelPoolShrinking(XAPool xaPool) {
        if (log.isDebugEnabled()) {
            log.debug("cancelling pool shrinking task on " + xaPool);
        }
        if (xaPool == null) {
            throw new IllegalArgumentException("expected a non-null XA pool");
        }
        if (!this.removeTaskByObject(xaPool) && log.isDebugEnabled()) {
            log.debug("no task found based on object " + xaPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Task task) {
        List list = this.tasks;
        synchronized (list) {
            this.removeTaskByObject(task.getObject());
            this.tasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTaskByObject(Object obj) {
        List list = this.tasks;
        synchronized (list) {
            if (log.isDebugEnabled()) {
                log.debug("removing task by " + obj);
            }
            for (int i = 0; i < this.tasks.size(); ++i) {
                Task task = (Task)this.tasks.get(i);
                if (task.getObject() != obj) continue;
                this.tasks.remove(task);
                if (log.isDebugEnabled()) {
                    log.debug("cancelled " + task + ", total task(s) still queued: " + this.tasks.size());
                }
                return true;
            }
            return false;
        }
    }

    void setActive(boolean active) {
        this.active = active;
    }

    private boolean isActive() {
        return this.active;
    }

    public void run() {
        while (this.isActive()) {
            try {
                this.executeElapsedTasks();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeElapsedTasks() {
        ArrayList tasks;
        if (this.tasks.size() == 0) {
            return;
        }
        List list = this.tasks;
        synchronized (list) {
            tasks = new ArrayList(this.tasks);
        }
        for (Task task : tasks) {
            if (task.getExecutionTime().compareTo(new Date()) > 0) continue;
            if (log.isDebugEnabled()) {
                log.debug("running " + task);
            }
            try {
                task.execute();
                if (!log.isDebugEnabled()) continue;
                log.debug("successfully ran " + task);
            }
            catch (Exception ex) {
                log.warn("error running " + task, (Throwable)ex);
            }
            finally {
                this.tasks.remove(task);
                if (!log.isDebugEnabled()) continue;
                log.debug("total task(s) still queued: " + tasks.size());
            }
        }
    }
}

