/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.twopc.PhaseException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import bitronix.tm.utils.CollectionUtils;
import bitronix.tm.utils.Decoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhaseEngine {
    private static final Logger log = LoggerFactory.getLogger(AbstractPhaseEngine.class);
    private Executor executor;

    protected AbstractPhaseEngine(Executor executor) {
        this.executor = executor;
    }

    protected void executePhase(XAResourceManager resourceManager, boolean reverse) throws PhaseException {
        List resources;
        SortedSet positions;
        if (reverse) {
            positions = resourceManager.getReverseOrderPositions();
            if (log.isDebugEnabled()) {
                log.debug("executing phase on " + resourceManager.size() + " resource(s) enlisted in " + positions.size() + " position(s) in reverse position order");
            }
        } else {
            positions = resourceManager.getNaturalOrderPositions();
            if (log.isDebugEnabled()) {
                log.debug("executing phase on " + resourceManager.size() + " resource(s) enlisted in " + positions.size() + " position(s) in natural position order");
            }
        }
        ArrayList<JobsExecutionReport> positionErrorReports = new ArrayList<JobsExecutionReport>();
        for (Object positionKey : positions) {
            JobsExecutionReport report;
            resources = reverse ? resourceManager.getReverseOrderResourcesForPosition(positionKey) : resourceManager.getNaturalOrderResourcesForPosition(positionKey);
            if (log.isDebugEnabled()) {
                log.debug("running " + resources.size() + " job(s) for position '" + positionKey + "'");
            }
            if ((report = this.runJobsForPosition(resources)).getExceptions().size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug(report.getExceptions().size() + " error(s) happened during execution of position '" + positionKey + "'");
                }
                positionErrorReports.add(report);
                break;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("ran " + resources.size() + " job(s) for position '" + positionKey + "'");
        }
        if (positionErrorReports.size() > 0) {
            ArrayList exceptions = new ArrayList();
            resources = new ArrayList();
            for (int i = 0; i < positionErrorReports.size(); ++i) {
                JobsExecutionReport report = (JobsExecutionReport)positionErrorReports.get(i);
                exceptions.addAll(report.getExceptions());
                resources.addAll(report.getResources());
            }
            throw new PhaseException(exceptions, resources);
        }
    }

    private JobsExecutionReport runJobsForPosition(List resources) {
        Object future;
        Job job;
        Iterator it = resources.iterator();
        ArrayList<Job> jobs = new ArrayList<Job>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        ArrayList<XAResourceHolderState> errorResources = new ArrayList<XAResourceHolderState>();
        while (it.hasNext()) {
            XAResourceHolderState resourceHolderState = (XAResourceHolderState)it.next();
            if (!this.isParticipating(resourceHolderState)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("skipping not participating resource " + resourceHolderState);
                continue;
            }
            job = this.createJob(resourceHolderState);
            future = this.executor.submit(job);
            job.setFuture(future);
            jobs.add(job);
        }
        for (int i = 0; i < jobs.size(); ++i) {
            job = (Job)jobs.get(i);
            future = job.getFuture();
            while (!this.executor.isDone(future)) {
                this.executor.waitFor(future, 1000L);
            }
            XAException xaException = job.getXAException();
            RuntimeException runtimeException = job.getRuntimeException();
            if (xaException != null) {
                if (log.isDebugEnabled()) {
                    log.debug("error executing " + job + ", errorCode=" + Decoder.decodeXAExceptionErrorCode(xaException));
                }
                exceptions.add(xaException);
                errorResources.add(job.getResource());
                continue;
            }
            if (runtimeException == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("error executing " + job);
            }
            exceptions.add(runtimeException);
            errorResources.add(job.getResource());
        }
        if (log.isDebugEnabled()) {
            log.debug("phase executed with " + exceptions.size() + " exception(s)");
        }
        return new JobsExecutionReport(exceptions, errorResources);
    }

    protected abstract boolean isParticipating(XAResourceHolderState var1);

    protected abstract Job createJob(XAResourceHolderState var1);

    protected void logFailedResources(PhaseException ex) {
        List exceptions = ex.getExceptions();
        List resources = ex.getResourceStates();
        for (int i = 0; i < exceptions.size(); ++i) {
            Throwable t = (Throwable)exceptions.get(i);
            XAResourceHolderState holderState = (XAResourceHolderState)resources.get(i);
            log.error("resource " + holderState.getUniqueName() + " failed on " + holderState.getXid(), t);
        }
    }

    protected static Set collectResourcesUniqueNames(List resources) {
        HashSet<String> uniqueNames = new HashSet<String>();
        for (int i = 0; i < resources.size(); ++i) {
            XAResourceHolderState resourceHolderState = (XAResourceHolderState)resources.get(i);
            String uniqueName = resourceHolderState.getUniqueName();
            uniqueNames.add(uniqueName);
        }
        return uniqueNames;
    }

    protected static List collectNotInterestedResources(List allResources, List interestedResources) {
        ArrayList<XAResourceHolderState> result = new ArrayList<XAResourceHolderState>();
        for (int i = 0; i < allResources.size(); ++i) {
            XAResourceHolderState resourceHolderState = (XAResourceHolderState)allResources.get(i);
            if (CollectionUtils.containsByIdentity(interestedResources, resourceHolderState)) continue;
            result.add(resourceHolderState);
        }
        return result;
    }

    private static final class JobsExecutionReport {
        private List exceptions;
        private List resources;

        private JobsExecutionReport(List exceptions, List resources) {
            this.exceptions = exceptions;
            this.resources = resources;
        }

        public List getExceptions() {
            return this.exceptions;
        }

        public List getResources() {
            return this.resources;
        }
    }
}

