/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.Version;
import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.utils.Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class CryptoEngine {
    private static final int LONG_SIZE_IN_BYTES = 8;
    private static final String CRYPTO_PASSWORD = "B1tr0n!+";

    public static String crypt(String cipher, String data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IOException {
        byte[] prependedBytes = Encoder.longToBytes(System.currentTimeMillis());
        byte[] dataBytes = data.getBytes("US-ASCII");
        byte[] toCrypt = new byte[8 + dataBytes.length];
        System.arraycopy(prependedBytes, 0, toCrypt, 0, 8);
        System.arraycopy(dataBytes, 0, toCrypt, 8, dataBytes.length);
        DESKeySpec desKeySpec = new DESKeySpec(CRYPTO_PASSWORD.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(cipher);
        SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
        Cipher desCipher = Cipher.getInstance(cipher);
        desCipher.init(1, secretKey);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CipherOutputStream cos = new CipherOutputStream(bos, desCipher);
        cos.write(toCrypt);
        cos.close();
        bos.close();
        byte[] cypherBytes = bos.toByteArray();
        return Base64.encodeBytes(cypherBytes);
    }

    public static String decrypt(String cipher, String data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IOException {
        int b;
        DESKeySpec desKeySpec = new DESKeySpec(CRYPTO_PASSWORD.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(cipher);
        SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
        Cipher desCipher = Cipher.getInstance(cipher);
        desCipher.init(2, secretKey);
        byte[] cypherBytes = Base64.decode(data);
        ByteArrayInputStream bis = new ByteArrayInputStream(cypherBytes);
        CipherInputStream cis = new CipherInputStream(bis, desCipher);
        StringBuffer sb = new StringBuffer();
        while ((b = cis.read()) != -1) {
            sb.append((char)b);
        }
        if (sb.length() < 9) {
            throw new BitronixRuntimeException("invalid crypted password '" + data + "'");
        }
        return sb.substring(8);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Bitronix Transaction Manager " + Version.getVersion() + " password property crypter");
        System.out.flush();
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: CryptoEngine <password> [cipher]");
            System.err.println("  where:");
            System.err.println("    <password> is mandatory and is the resource password to crypt");
            System.err.println("    [cipher]   is optional and is the cipher to be used to crypt the password");
            System.exit(1);
        }
        String data = args[0];
        String cipher = "DES";
        if (args.length > 1) {
            cipher = args[1];
        }
        String propertyValue = "{" + cipher + "}" + CryptoEngine.crypt(cipher, data);
        System.out.println("crypted password property value: " + propertyValue);
    }

    private static final class Base64 {
        public static final int NO_OPTIONS = 0;
        public static final int ENCODE = 1;
        public static final int DECODE = 0;
        public static final int GZIP = 2;
        public static final int DONT_BREAK_LINES = 8;
        public static final int URL_SAFE = 16;
        public static final int ORDERED = 32;
        private static final int MAX_LINE_LENGTH = 76;
        private static final byte EQUALS_SIGN = 61;
        private static final byte NEW_LINE = 10;
        private static final String PREFERRED_ENCODING = "UTF-8";
        private static final byte WHITE_SPACE_ENC = -5;
        private static final byte EQUALS_SIGN_ENC = -1;
        private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        private static final byte[] _STANDARD_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
        private static final byte[] _URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        private static final byte[] _URL_SAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
        private static final byte[] _ORDERED_ALPHABET = new byte[]{45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        private static final byte[] _ORDERED_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -9, -9, -9, -1, -9, -9, -9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, -9, -9, -9, -9, 37, -9, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -9, -9, -9, -9};

        private static byte[] getAlphabet(int options) {
            if ((options & 0x10) == 16) {
                return _URL_SAFE_ALPHABET;
            }
            if ((options & 0x20) == 32) {
                return _ORDERED_ALPHABET;
            }
            return _STANDARD_ALPHABET;
        }

        private static byte[] getDecodabet(int options) {
            if ((options & 0x10) == 16) {
                return _URL_SAFE_DECODABET;
            }
            if ((options & 0x20) == 32) {
                return _ORDERED_DECODABET;
            }
            return _STANDARD_DECODABET;
        }

        private Base64() {
        }

        private static byte[] encode3to4(byte[] b4, byte[] threeBytes, int numSigBytes, int options) {
            Base64.encode3to4(threeBytes, 0, numSigBytes, b4, 0, options);
            return b4;
        }

        private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset, int options) {
            byte[] ALPHABET = Base64.getAlphabet(options);
            int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
            switch (numSigBytes) {
                case 3: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                    destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                    return destination;
                }
                case 2: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                    destination[destOffset + 3] = 61;
                    return destination;
                }
                case 1: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = 61;
                    destination[destOffset + 3] = 61;
                    return destination;
                }
            }
            return destination;
        }

        public static String encodeBytes(byte[] source) {
            return Base64.encodeBytes(source, 0, source.length, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String encodeBytes(byte[] source, int off, int len, int options) {
            int dontBreakLines = options & 8;
            int gzip = options & 2;
            if (gzip == 2) {
                ByteArrayOutputStream baos = null;
                DeflaterOutputStream gzos = null;
                OutputStream b64os = null;
                try {
                    baos = new ByteArrayOutputStream();
                    b64os = new OutputStream(baos, 1 | options);
                    gzos = new GZIPOutputStream(b64os);
                    ((GZIPOutputStream)gzos).write(source, off, len);
                    gzos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String string = null;
                    return string;
                }
                finally {
                    try {
                        gzos.close();
                    }
                    catch (Exception e) {}
                    try {
                        b64os.close();
                    }
                    catch (Exception e) {}
                    try {
                        baos.close();
                    }
                    catch (Exception e) {}
                }
                try {
                    return new String(baos.toByteArray(), PREFERRED_ENCODING);
                }
                catch (UnsupportedEncodingException uue) {
                    return new String(baos.toByteArray());
                }
            }
            boolean breakLines = dontBreakLines == 0;
            int len43 = len * 4 / 3;
            byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + (breakLines ? len43 / 76 : 0)];
            int d = 0;
            int e = 0;
            int len2 = len - 2;
            int lineLength = 0;
            while (d < len2) {
                Base64.encode3to4(source, d + off, 3, outBuff, e, options);
                if (breakLines && (lineLength += 4) == 76) {
                    outBuff[e + 4] = 10;
                    ++e;
                    lineLength = 0;
                }
                d += 3;
                e += 4;
            }
            if (d < len) {
                Base64.encode3to4(source, d + off, len - d, outBuff, e, options);
                e += 4;
            }
            try {
                return new String(outBuff, 0, e, PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uue) {
                return new String(outBuff, 0, e);
            }
        }

        private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset, int options) {
            byte[] DECODABET = Base64.getDecodabet(options);
            if (source[srcOffset + 2] == 61) {
                int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
                destination[destOffset] = (byte)(outBuff >>> 16);
                return 1;
            }
            if (source[srcOffset + 3] == 61) {
                int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
                destination[destOffset] = (byte)(outBuff >>> 16);
                destination[destOffset + 1] = (byte)(outBuff >>> 8);
                return 2;
            }
            try {
                int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source[srcOffset + 3]] & 0xFF;
                destination[destOffset] = (byte)(outBuff >> 16);
                destination[destOffset + 1] = (byte)(outBuff >> 8);
                destination[destOffset + 2] = (byte)outBuff;
                return 3;
            }
            catch (Exception e) {
                System.out.println("" + source[srcOffset] + ": " + DECODABET[source[srcOffset]]);
                System.out.println("" + source[srcOffset + 1] + ": " + DECODABET[source[srcOffset + 1]]);
                System.out.println("" + source[srcOffset + 2] + ": " + DECODABET[source[srcOffset + 2]]);
                System.out.println("" + source[srcOffset + 3] + ": " + DECODABET[source[srcOffset + 3]]);
                return -1;
            }
        }

        public static byte[] decode(byte[] source, int off, int len, int options) {
            byte[] DECODABET = Base64.getDecodabet(options);
            int len34 = len * 3 / 4;
            byte[] outBuff = new byte[len34];
            int outBuffPosn = 0;
            byte[] b4 = new byte[4];
            int b4Posn = 0;
            for (int i = off; i < off + len; ++i) {
                byte sbiCrop = (byte)(source[i] & 0x7F);
                byte sbiDecode = DECODABET[sbiCrop];
                if (sbiDecode >= -5) {
                    if (sbiDecode < -1) continue;
                    b4[b4Posn++] = sbiCrop;
                    if (b4Posn <= 3) continue;
                    outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn, options);
                    b4Posn = 0;
                    if (sbiCrop != 61) continue;
                    break;
                }
                System.err.println("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
                return null;
            }
            byte[] out = new byte[outBuffPosn];
            System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
            return out;
        }

        public static byte[] decode(String s) {
            return Base64.decode(s, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static byte[] decode(String s, int options) {
            int head;
            byte[] bytes;
            try {
                bytes = s.getBytes(PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uee) {
                bytes = s.getBytes();
            }
            bytes = Base64.decode(bytes, 0, bytes.length, options);
            if (bytes != null && bytes.length >= 4 && 35615 == (head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00)) {
                ByteArrayInputStream bais = null;
                GZIPInputStream gzis = null;
                ByteArrayOutputStream baos = null;
                byte[] buffer = new byte[2048];
                try {
                    int length;
                    baos = new ByteArrayOutputStream();
                    bais = new ByteArrayInputStream(bytes);
                    gzis = new GZIPInputStream(bais);
                    while ((length = gzis.read(buffer)) >= 0) {
                        baos.write(buffer, 0, length);
                    }
                    bytes = baos.toByteArray();
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        baos.close();
                    }
                    catch (Exception e) {}
                    try {
                        gzis.close();
                    }
                    catch (Exception e) {}
                    try {
                        bais.close();
                    }
                    catch (Exception e) {}
                }
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object decodeToObject(String encodedObject) {
            byte[] objBytes = Base64.decode(encodedObject);
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            Object obj = null;
            try {
                bais = new ByteArrayInputStream(objBytes);
                ois = new ObjectInputStream(bais);
                obj = ois.readObject();
            }
            catch (IOException e) {
                e.printStackTrace();
                obj = null;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                obj = null;
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (Exception e) {}
            }
            return obj;
        }

        public static class OutputStream
        extends FilterOutputStream {
            private boolean encode;
            private int position;
            private byte[] buffer;
            private int bufferLength;
            private int lineLength;
            private boolean breakLines;
            private byte[] b4;
            private boolean suspendEncoding;
            private int options;
            private byte[] decodabet;

            public OutputStream(java.io.OutputStream out) {
                this(out, 1);
            }

            public OutputStream(java.io.OutputStream out, int options) {
                super(out);
                this.breakLines = (options & 8) != 8;
                this.encode = (options & 1) == 1;
                this.bufferLength = this.encode ? 3 : 4;
                this.buffer = new byte[this.bufferLength];
                this.position = 0;
                this.lineLength = 0;
                this.suspendEncoding = false;
                this.b4 = new byte[4];
                this.options = options;
                this.decodabet = Base64.getDecodabet(options);
            }

            public void write(int theByte) throws IOException {
                if (this.suspendEncoding) {
                    this.out.write(theByte);
                    return;
                }
                if (this.encode) {
                    this.buffer[this.position++] = (byte)theByte;
                    if (this.position >= this.bufferLength) {
                        this.out.write(Base64.encode3to4(this.b4, this.buffer, this.bufferLength, this.options));
                        this.lineLength += 4;
                        if (this.breakLines && this.lineLength >= 76) {
                            this.out.write(10);
                            this.lineLength = 0;
                        }
                        this.position = 0;
                    }
                } else if (this.decodabet[theByte & 0x7F] > -5) {
                    this.buffer[this.position++] = (byte)theByte;
                    if (this.position >= this.bufferLength) {
                        int len = Base64.decode4to3(this.buffer, 0, this.b4, 0, this.options);
                        this.out.write(this.b4, 0, len);
                        this.position = 0;
                    }
                } else if (this.decodabet[theByte & 0x7F] != -5) {
                    throw new IOException("Invalid character in Base64 data.");
                }
            }

            public void write(byte[] theBytes, int off, int len) throws IOException {
                if (this.suspendEncoding) {
                    this.out.write(theBytes, off, len);
                    return;
                }
                for (int i = 0; i < len; ++i) {
                    this.write(theBytes[off + i]);
                }
            }

            public void flushBase64() throws IOException {
                if (this.position > 0) {
                    if (this.encode) {
                        this.out.write(Base64.encode3to4(this.b4, this.buffer, this.position, this.options));
                        this.position = 0;
                    } else {
                        throw new IOException("Base64 input not properly padded.");
                    }
                }
            }

            public void close() throws IOException {
                this.flushBase64();
                super.close();
                this.buffer = null;
                this.out = null;
            }

            public void suspendEncoding() throws IOException {
                this.flushBase64();
                this.suspendEncoding = true;
            }

            public void resumeEncoding() {
                this.suspendEncoding = false;
            }
        }
    }
}

