/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Scheduler {
    public static final int DEFAULT_POSITION = 0;
    public static final int ALWAYS_FIRST_POSITION = Integer.MIN_VALUE;
    public static final int ALWAYS_LAST_POSITION = Integer.MAX_VALUE;
    public static final Object DEFAULT_POSITION_KEY = new Integer(0);
    public static final Object ALWAYS_FIRST_POSITION_KEY = new Integer(Integer.MIN_VALUE);
    public static final Object ALWAYS_LAST_POSITION_KEY = new Integer(Integer.MAX_VALUE);
    private List keys = new ArrayList();
    private Map objects = new TreeMap();
    private int size = 0;

    public synchronized void add(Object obj, int position) {
        Integer key = new Integer(position);
        ArrayList<Object> synchronizationsList = (ArrayList<Object>)this.objects.get(key);
        if (synchronizationsList == null) {
            if (!this.keys.contains(key)) {
                this.keys.add(key);
                Collections.sort(this.keys);
            }
            synchronizationsList = new ArrayList<Object>();
            this.objects.put(key, synchronizationsList);
        }
        synchronizationsList.add(obj);
        ++this.size;
    }

    public synchronized void remove(Object obj) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o != obj) continue;
            it.remove();
            return;
        }
        throw new NoSuchElementException("no such element: " + obj);
    }

    public synchronized SortedSet getNaturalOrderPositions() {
        return new TreeSet(this.objects.keySet());
    }

    public synchronized SortedSet getReverseOrderPositions() {
        TreeSet result = new TreeSet(Collections.reverseOrder());
        result.addAll(this.getNaturalOrderPositions());
        return result;
    }

    public synchronized List getByNaturalOrderForPosition(Object positionKey) {
        return (List)this.objects.get(positionKey);
    }

    public synchronized List getByReverseOrderForPosition(Object positionKey) {
        ArrayList result = new ArrayList(this.getByNaturalOrderForPosition(positionKey));
        Collections.reverse(result);
        return result;
    }

    public synchronized int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new SchedulerNaturalOrderIterator();
    }

    public Iterator reverseIterator() {
        return new SchedulerReverseOrderIterator();
    }

    public String toString() {
        return "a Scheduler with " + this.size() + " object(s) in " + this.getNaturalOrderPositions().size() + " position(s)";
    }

    private final class SchedulerReverseOrderIterator
    implements Iterator {
        private int nextKeyIndex;
        private List objectsOfCurrentKey;
        private int objectsOfCurrentKeyIndex;

        private SchedulerReverseOrderIterator() {
            this.nextKeyIndex = Scheduler.this.keys.size() - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (this.objectsOfCurrentKey == null) {
                    throw new NoSuchElementException("iterator not yet placed on an element");
                }
                --this.objectsOfCurrentKeyIndex;
                this.objectsOfCurrentKey.remove(this.objectsOfCurrentKeyIndex);
                if (this.objectsOfCurrentKey.size() == 0) {
                    Object key = Scheduler.this.keys.get(this.nextKeyIndex + 1);
                    Scheduler.this.keys.remove(this.nextKeyIndex + 1);
                    Scheduler.this.objects.remove(key);
                    this.objectsOfCurrentKey = null;
                }
                Scheduler.this.size--;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (this.objectsOfCurrentKey == null || this.objectsOfCurrentKeyIndex >= this.objectsOfCurrentKey.size()) {
                    if (this.nextKeyIndex >= 0) {
                        Integer currentKey = (Integer)Scheduler.this.keys.get(this.nextKeyIndex--);
                        this.objectsOfCurrentKey = (List)Scheduler.this.objects.get(currentKey);
                        this.objectsOfCurrentKeyIndex = 0;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("iterator bounds reached");
                }
                return this.objectsOfCurrentKey.get(this.objectsOfCurrentKeyIndex++);
            }
        }
    }

    private final class SchedulerNaturalOrderIterator
    implements Iterator {
        private int nextKeyIndex = 0;
        private List objectsOfCurrentKey;
        private int objectsOfCurrentKeyIndex;

        private SchedulerNaturalOrderIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (this.objectsOfCurrentKey == null) {
                    throw new NoSuchElementException("iterator not yet placed on an element");
                }
                --this.objectsOfCurrentKeyIndex;
                this.objectsOfCurrentKey.remove(this.objectsOfCurrentKeyIndex);
                if (this.objectsOfCurrentKey.size() == 0) {
                    --this.nextKeyIndex;
                    Object key = Scheduler.this.keys.get(this.nextKeyIndex);
                    Scheduler.this.keys.remove(this.nextKeyIndex);
                    Scheduler.this.objects.remove(key);
                    this.objectsOfCurrentKey = null;
                }
                Scheduler.this.size--;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (this.objectsOfCurrentKey == null || this.objectsOfCurrentKeyIndex >= this.objectsOfCurrentKey.size()) {
                    if (this.nextKeyIndex < Scheduler.this.keys.size()) {
                        Integer currentKey = (Integer)Scheduler.this.keys.get(this.nextKeyIndex++);
                        this.objectsOfCurrentKey = (List)Scheduler.this.objects.get(currentKey);
                        this.objectsOfCurrentKeyIndex = 0;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Scheduler scheduler = Scheduler.this;
            synchronized (scheduler) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("iterator bounds reached");
                }
                return this.objectsOfCurrentKey.get(this.objectsOfCurrentKeyIndex++);
            }
        }
    }
}

