/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.gmavenplus.groovyworkarounds.DotGroovyFile;
import org.codehaus.gmavenplus.groovyworkarounds.GroovyDocTemplateInfo;
import org.codehaus.gmavenplus.model.GroovyCompileConfiguration;
import org.codehaus.gmavenplus.model.GroovyDocConfiguration;
import org.codehaus.gmavenplus.model.GroovyStubConfiguration;
import org.codehaus.gmavenplus.model.Link;
import org.codehaus.gmavenplus.model.internal.Version;
import org.codehaus.gmavenplus.util.ClassWrangler;
import org.codehaus.gmavenplus.util.FileUtils;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public class GroovyCompiler {
    protected static final Version GROOVY_5_0_0_BETA_1 = new Version(5, 0, 0, "beta-1");
    protected static final Version GROOVY_5_0_0_ALPHA13 = new Version(5, 0, 0, "alpha-13");
    protected static final Version GROOVY_5_0_0_ALPHA11 = new Version(5, 0, 0, "alpha-11");
    protected static final Version GROOVY_5_0_0_ALPHA8 = new Version(5, 0, 0, "alpha-8");
    protected static final Version GROOVY_5_0_0_ALPHA3 = new Version(5, 0, 0, "alpha-3");
    protected static final Version GROOVY_5_0_0_ALPHA1 = new Version(5, 0, 0, "alpha-1");
    protected static final Version GROOVY_4_0_27 = new Version(4, 0, 27);
    protected static final Version GROOVY_4_0_24 = new Version(4, 0, 24);
    protected static final Version GROOVY_4_0_21 = new Version(4, 0, 21);
    protected static final Version GROOVY_4_0_16 = new Version(4, 0, 16);
    protected static final Version GROOVY_4_0_11 = new Version(4, 0, 11);
    protected static final Version GROOVY_4_0_6 = new Version(4, 0, 6);
    protected static final Version GROOVY_4_0_2 = new Version(4, 0, 2);
    protected static final Version GROOVY_4_0_0_BETA1 = new Version(4, 0, 0, "beta-1");
    protected static final Version GROOVY_4_0_0_ALPHA3 = new Version(4, 0, 0, "alpha-3");
    protected static final Version GROOVY_4_0_0_ALPHA1 = new Version(4, 0, 0, "alpha-1");
    protected static final Version GROOVY_3_0_8 = new Version(3, 0, 8);
    protected static final Version GROOVY_3_0_6 = new Version(3, 0, 6);
    protected static final Version GROOVY_3_0_5 = new Version(3, 0, 5);
    protected static final Version GROOVY_3_0_3 = new Version(3, 0, 3);
    protected static final Version GROOVY_3_0_0_BETA2 = new Version(3, 0, 0, "beta-2");
    protected static final Version GROOVY_3_0_0_BETA1 = new Version(3, 0, 0, "beta-1");
    protected static final Version GROOVY_3_0_0_ALPHA4 = new Version(3, 0, 0, "alpha-4");
    protected static final Version GROOVY_3_0_0_ALPHA2 = new Version(3, 0, 0, "alpha-2");
    protected static final Version GROOVY_3_0_0_ALPHA1 = new Version(3, 0, 0, "alpha-1");
    protected static final Version GROOVY_2_6_0_ALPHA4 = new Version(2, 6, 0, "alpha-4");
    protected static final Version GROOVY_2_6_0_ALPHA1 = new Version(2, 6, 0, "alpha-1");
    protected static final Version GROOVY_2_5_7 = new Version(2, 5, 7);
    protected static final Version GROOVY_2_5_3 = new Version(2, 5, 3);
    protected static final Version GROOVY_2_5_0_ALPHA1 = new Version(2, 5, 0, "alpha-1");
    protected static final Version GROOVY_2_3_3 = new Version(2, 3, 3);
    protected static final Version GROOVY_1_8_2 = new Version(1, 8, 2);
    protected static final Version GROOVY_1_8_3 = new Version(1, 8, 3);
    protected static final Version GROOVY_2_1_3 = new Version(2, 1, 3);
    protected static final Version GROOVY_2_1_0_BETA1 = new Version(2, 1, 0, "beta-1");
    protected static final Version GROOVY_2_0_0_BETA3 = new Version(2, 0, 0, "beta-3");
    protected static final Version GROOVY_1_9_0_BETA1 = new Version(1, 9, 0, "beta-1");
    protected static final Version GROOVY_1_9_0_BETA3 = new Version(1, 9, 0, "beta-3");
    protected static final Version GROOVY_1_6_0 = new Version(1, 6, 0);
    protected static final Version GROOVY_1_6_0_RC2 = new Version(1, 6, 0, "RC-2");
    protected static final Version GROOVY_1_5_2 = new Version(1, 5, 2);
    protected static final Version JAVA_1_7 = new Version(1, 7);
    protected static final Version JAVA_1_8 = new Version(1, 8);
    protected static final Version JAVA_12 = new Version(12);
    private final ClassWrangler classWrangler;
    private final Log log;

    public GroovyCompiler(ClassWrangler classWrangler, Log log) {
        this.classWrangler = classWrangler;
        this.log = log;
    }

    public void compile(GroovyCompileConfiguration configuration) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (configuration.getSources() == null || configuration.getSources().isEmpty()) {
            this.log.info((CharSequence)"No sources specified for compilation. Skipping.");
            return;
        }
        if (!configuration.isSkipBytecodeCheck()) {
            this.verifyGroovyVersionSupportsTargetBytecode(configuration.getTargetBytecode());
        }
        Class<?> compilerConfigurationClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilerConfiguration");
        Class<?> compilationUnitClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilationUnit");
        Class<?> groovyClassLoaderClass = this.classWrangler.getClass("groovy.lang.GroovyClassLoader");
        Object compilerConfiguration = this.setupCompilerConfiguration(configuration, compilerConfigurationClass);
        Object groovyClassLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class, compilerConfigurationClass), this.classWrangler.getClassLoader(), compilerConfiguration);
        Object transformLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class), this.classWrangler.getClassLoader());
        Object compilationUnit = this.setupCompilationUnit(configuration.getSources(), compilerConfigurationClass, compilationUnitClass, groovyClassLoaderClass, compilerConfiguration, groovyClassLoader, transformLoader);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "compile", new Class[0]), compilationUnit, new Object[0]);
        List classes = (List)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "getClasses", new Class[0]), compilationUnit, new Object[0]);
        this.log.info((CharSequence)("Compiled " + classes.size() + " file" + (classes.size() != 1 ? "s" : "") + "."));
    }

    public void generateGroovyDoc(GroovyDocConfiguration configuration) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (configuration.getSourceDirectories() == null || configuration.getSourceDirectories().length == 0) {
            this.log.info((CharSequence)"No source directories specified for GroovyDoc generation. Skipping.");
            return;
        }
        Class<?> groovyDocToolClass = this.classWrangler.getClass(configuration.getGroovyDocToolClass() == null ? "org.codehaus.groovy.tools.groovydoc.GroovyDocTool" : configuration.getGroovyDocToolClass());
        Class<?> outputToolClass = this.classWrangler.getClass(configuration.getOutputToolClass() == null ? "org.codehaus.groovy.tools.groovydoc.OutputTool" : configuration.getOutputToolClass());
        Class<?> fileOutputToolClass = this.classWrangler.getClass(configuration.getFileOutputToolClass() == null ? "org.codehaus.groovy.tools.groovydoc.FileOutputTool" : configuration.getFileOutputToolClass());
        Class<?> resourceManagerClass = this.classWrangler.getClass(configuration.getResourceManagerClass() == null ? "org.codehaus.groovy.tools.groovydoc.ResourceManager" : configuration.getResourceManagerClass());
        Class<?> classpathResourceManagerClass = this.classWrangler.getClass(configuration.getClasspathResourceManagerClass() == null ? "org.codehaus.groovy.tools.groovydoc.ClasspathResourceManager" : configuration.getClasspathResourceManagerClass());
        if (configuration.isAttachGroovyDocAnnotation()) {
            if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_3_0_0_ALPHA4)) {
                System.setProperty("runtimeGroovydoc", "true");
            } else {
                this.log.warn((CharSequence)("Requested to enable attaching GroovyDoc annotation, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_3_0_0_ALPHA4 + " or newer). Ignoring enableGroovyDocAnnotation parameter."));
            }
        }
        Object fileOutputTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(fileOutputToolClass, new Class[0]), new Object[0]);
        Object classpathResourceManager = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(classpathResourceManagerClass, new Class[0]), new Object[0]);
        FileSetManager fileSetManager = new FileSetManager();
        ArrayList<String> sourceDirectoriesStrings = new ArrayList<String>();
        for (FileSet sourceDirectory : configuration.getSourceDirectories()) {
            sourceDirectoriesStrings.add(sourceDirectory.getDirectory());
        }
        GroovyDocTemplateInfo groovyDocTemplateInfo = new GroovyDocTemplateInfo(this.classWrangler.getGroovyVersion());
        List<?> groovyDocLinks = this.setupLinks(configuration);
        if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_1_6_0_RC2) && configuration.getDocProperties() != null && !configuration.getDocProperties().isEmpty()) {
            this.log.warn((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support GroovyDoc documentation properties (docTitle, footer, header, displayAuthor, overviewFile, and scope). You need Groovy 1.6-RC-2 or newer to support this. Ignoring properties."));
        }
        List<String> groovyDocSources = this.setupGroovyDocSources(configuration.getSourceDirectories(), fileSetManager);
        Object groovyDocTool = this.createGroovyDocTool(groovyDocToolClass, resourceManagerClass, configuration.getDocProperties(), classpathResourceManager, sourceDirectoriesStrings, groovyDocTemplateInfo, groovyDocLinks, configuration);
        this.performGroovyDocGeneration(configuration.getOutputDirectory(), groovyDocToolClass, outputToolClass, fileOutputTool, groovyDocSources, groovyDocTool);
    }

    protected List<?> setupLinks(GroovyDocConfiguration configuration) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        ArrayList<Object> linksList = new ArrayList<Object>();
        if (configuration.getLinks() != null && !configuration.getLinks().isEmpty()) {
            Class<?> linkArgumentClass = null;
            if (configuration.getLinkArgumentClass() == null) {
                if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_1_6_0_RC2)) {
                    linkArgumentClass = this.classWrangler.getClass("org.codehaus.groovy.tools.groovydoc.LinkArgument");
                } else if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_1_5_2)) {
                    linkArgumentClass = this.classWrangler.getClass("org.codehaus.groovy.ant.Groovydoc$LinkArgument");
                }
            } else {
                linkArgumentClass = this.classWrangler.getClass(configuration.getLinkArgumentClass());
            }
            if (linkArgumentClass != null) {
                Method setHref = ReflectionUtils.findMethod(linkArgumentClass, "setHref", String.class);
                Method setPackages = ReflectionUtils.findMethod(linkArgumentClass, "setPackages", String.class);
                for (Link link : configuration.getLinks()) {
                    Object linkArgument = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(linkArgumentClass, new Class[0]), new Object[0]);
                    ReflectionUtils.invokeMethod(setHref, linkArgument, link.getHref());
                    ReflectionUtils.invokeMethod(setPackages, linkArgument, link.getPackages());
                    linksList.add(linkArgument);
                }
            } else {
                this.log.warn((CharSequence)("Requested to use GroovyDoc links, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be 1.5.2 or newer). Ignoring links parameter."));
            }
        }
        return linksList;
    }

    protected Object createGroovyDocTool(Class<?> groovyDocToolClass, Class<?> resourceManagerClass, Properties docProperties, Object classpathResourceManager, List<String> sourceDirectories, GroovyDocTemplateInfo groovyDocTemplateInfo, List<?> groovyDocLinks, GroovyDocConfiguration configuration) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object groovyDocTool;
        String[] defaultDocTemplates = configuration.getDefaultDocTemplates();
        String[] defaultPackageTemplates = configuration.getDefaultPackageTemplates();
        String[] defaultClassTemplates = configuration.getDefaultClassTemplates();
        if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_4_0_27) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA1) || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_BETA_1)) {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String[].class, String[].class, String[].class, String[].class, List.class, String.class, Properties.class), classpathResourceManager, sourceDirectories.toArray(new String[0]), defaultDocTemplates == null ? groovyDocTemplateInfo.defaultDocTemplates() : defaultDocTemplates, defaultPackageTemplates == null ? groovyDocTemplateInfo.defaultPackageTemplates() : defaultPackageTemplates, defaultClassTemplates == null ? groovyDocTemplateInfo.defaultClassTemplates() : defaultClassTemplates, groovyDocLinks, configuration.getLanguageLevel(), docProperties);
        } else if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_1_6_0_RC2)) {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String[].class, String[].class, String[].class, String[].class, List.class, Properties.class), classpathResourceManager, sourceDirectories.toArray(new String[0]), defaultDocTemplates == null ? groovyDocTemplateInfo.defaultDocTemplates() : defaultDocTemplates, defaultPackageTemplates == null ? groovyDocTemplateInfo.defaultPackageTemplates() : defaultPackageTemplates, defaultClassTemplates == null ? groovyDocTemplateInfo.defaultClassTemplates() : defaultClassTemplates, groovyDocLinks, docProperties);
        } else if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_1_5_2)) {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String.class, String[].class, String[].class, String[].class, List.class), classpathResourceManager, sourceDirectories.get(0), defaultDocTemplates == null ? groovyDocTemplateInfo.defaultDocTemplates() : defaultDocTemplates, defaultPackageTemplates == null ? groovyDocTemplateInfo.defaultPackageTemplates() : defaultPackageTemplates, defaultClassTemplates == null ? groovyDocTemplateInfo.defaultClassTemplates() : defaultClassTemplates, groovyDocLinks);
            if (sourceDirectories.size() > 1) {
                this.log.warn((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support more than one GroovyDoc source directory (must be 1.6-RC-2 or newer). Only using first source directory (" + sourceDirectories.get(0) + ")."));
            }
        } else {
            groovyDocTool = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyDocToolClass, resourceManagerClass, String.class, String[].class, String[].class, String[].class), classpathResourceManager, sourceDirectories.get(0), defaultDocTemplates == null ? groovyDocTemplateInfo.defaultDocTemplates() : defaultDocTemplates, defaultPackageTemplates == null ? groovyDocTemplateInfo.defaultPackageTemplates() : defaultPackageTemplates, defaultClassTemplates == null ? groovyDocTemplateInfo.defaultClassTemplates() : defaultClassTemplates);
            if (sourceDirectories.size() > 1) {
                this.log.warn((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support more than one GroovyDoc source directory (must be 1.6-RC-2 or newer). Only using first source directory (" + sourceDirectories.get(0) + ")."));
            }
        }
        return groovyDocTool;
    }

    protected List<String> setupGroovyDocSources(FileSet[] sourceDirectories, FileSetManager fileSetManager) {
        ArrayList<String> javaSources = new ArrayList<String>();
        ArrayList<String> groovySources = new ArrayList<String>();
        ArrayList<String> possibleGroovyStubs = new ArrayList<String>();
        for (FileSet sourceDirectory : sourceDirectories) {
            String[] sources;
            for (String source : sources = fileSetManager.getIncludedFiles(sourceDirectory)) {
                if (source.endsWith(".java") && !javaSources.contains(source)) {
                    javaSources.add(source);
                    continue;
                }
                if (groovySources.contains(source)) continue;
                groovySources.add(source);
                possibleGroovyStubs.add(source.replaceFirst("\\." + FileUtils.getFileExtension(source), ".java"));
            }
        }
        javaSources.removeAll(possibleGroovyStubs);
        ArrayList<String> groovyDocSources = new ArrayList<String>();
        groovyDocSources.addAll(javaSources);
        groovyDocSources.addAll(groovySources);
        return groovyDocSources;
    }

    protected void performGroovyDocGeneration(File outputDirectory, Class<?> groovyDocToolClass, Class<?> outputToolClass, Object fileOutputTool, List<String> groovyDocSources, Object groovyDocTool) throws InvocationTargetException, IllegalAccessException {
        this.log.debug((CharSequence)"Adding sources to generate GroovyDoc for:");
        if (this.log.isDebugEnabled()) {
            for (String groovyDocSource : groovyDocSources) {
                this.log.debug((CharSequence)("    " + groovyDocSource));
            }
        }
        if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_1_6_0_RC2)) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyDocToolClass, "add", List.class), groovyDocTool, groovyDocSources);
        } else {
            Method add = ReflectionUtils.findMethod(groovyDocToolClass, "add", String.class);
            for (String groovyDocSource : groovyDocSources) {
                ReflectionUtils.invokeMethod(add, groovyDocTool, groovyDocSource);
            }
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyDocToolClass, "renderToOutput", outputToolClass, String.class), groovyDocTool, fileOutputTool, outputDirectory.getAbsolutePath());
    }

    public void generateStubs(GroovyStubConfiguration configuration) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (configuration.getStubSources() == null || configuration.getStubSources().isEmpty()) {
            this.log.info((CharSequence)"No sources specified for stub generation. Skipping.");
            return;
        }
        if (!this.supportsStubGeneration()) {
            this.log.error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support stub generation. The minimum version of Groovy required is 1.8.2. Skipping stub generation."));
            return;
        }
        if (!configuration.isSkipBytecodeCheck()) {
            this.verifyGroovyVersionSupportsTargetBytecode(configuration.getTargetBytecode());
        }
        Class<?> compilerConfigurationClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilerConfiguration");
        Class<?> javaStubCompilationUnitClass = this.classWrangler.getClass("org.codehaus.groovy.tools.javac.JavaStubCompilationUnit");
        Class<?> groovyClassLoaderClass = this.classWrangler.getClass("groovy.lang.GroovyClassLoader");
        Object compilerConfiguration = this.setupStubCompilerConfiguration(configuration, compilerConfigurationClass);
        Object groovyClassLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class, compilerConfigurationClass), this.classWrangler.getClassLoader(), compilerConfiguration);
        Object javaStubCompilationUnit = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(javaStubCompilationUnitClass, compilerConfigurationClass, groovyClassLoaderClass, File.class), compilerConfiguration, groovyClassLoader, configuration.getOutputDirectory());
        this.addGroovySources(configuration.getStubSources(), compilerConfigurationClass, javaStubCompilationUnitClass, compilerConfiguration, javaStubCompilationUnit);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(javaStubCompilationUnitClass, "compile", new Class[0]), javaStubCompilationUnit, new Object[0]);
    }

    protected Object setupStubCompilerConfiguration(GroovyStubConfiguration configuration, Class<?> compilerConfigurationClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setDebug", Boolean.TYPE), compilerConfiguration, configuration.isDebug());
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setVerbose", Boolean.TYPE), compilerConfiguration, configuration.isVerbose());
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setWarningLevel", Integer.TYPE), compilerConfiguration, configuration.getWarningLevel());
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTolerance", Integer.TYPE), compilerConfiguration, configuration.getTolerance());
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetBytecode", String.class), compilerConfiguration, GroovyCompiler.translateJavacTargetToTargetBytecode(configuration.getTargetBytecode()));
        if (configuration.getSourceEncoding() != null) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, configuration.getSourceEncoding());
        }
        HashMap<String, Comparable<File>> options = new HashMap<String, Comparable<File>>();
        options.put("stubDir", configuration.getOutputDirectory());
        options.put("keepStubs", Boolean.TRUE);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setJointCompilationOptions", Map.class), compilerConfiguration, options);
        return compilerConfiguration;
    }

    protected void addGroovySources(Set<File> stubSources, Class<?> compilerConfigurationClass, Class<?> javaStubCompilationUnitClass, Object compilerConfiguration, Object javaStubCompilationUnit) throws InvocationTargetException, IllegalAccessException {
        HashSet<String> scriptExtensions = new HashSet<String>();
        for (File stubSource : stubSources) {
            scriptExtensions.add(FileUtils.getFileExtension(stubSource));
        }
        this.log.debug((CharSequence)("Detected Groovy file extensions: " + scriptExtensions + "."));
        if (this.supportsSettingExtensions()) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setScriptExtensions", Set.class), compilerConfiguration, scriptExtensions);
        }
        this.log.debug((CharSequence)"Adding Groovy to generate stubs for:");
        Method addSource = ReflectionUtils.findMethod(javaStubCompilationUnitClass, "addSource", File.class);
        for (File stubSource : stubSources) {
            this.log.debug((CharSequence)("    " + stubSource));
            if (this.supportsSettingExtensions()) {
                ReflectionUtils.invokeMethod(addSource, javaStubCompilationUnit, stubSource);
                continue;
            }
            DotGroovyFile dotGroovyFile = new DotGroovyFile(stubSource).setScriptExtensions(scriptExtensions);
            ReflectionUtils.invokeMethod(addSource, javaStubCompilationUnit, dotGroovyFile);
        }
    }

    protected boolean supportsStubGeneration() {
        return ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_1_8_2);
    }

    protected boolean supportsSettingExtensions() {
        return ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_1_8_3) && (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_1_9_0_BETA1) || ClassWrangler.groovyNewerThan(this.classWrangler.getGroovyVersion(), GROOVY_1_9_0_BETA3));
    }

    protected Object setupCompilationUnit(Set<File> sources, Class<?> compilerConfigurationClass, Class<?> compilationUnitClass, Class<?> groovyClassLoaderClass, Object compilerConfiguration, Object groovyClassLoader, Object transformLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object compilationUnit = ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_1_6_0) ? ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilationUnitClass, compilerConfigurationClass, CodeSource.class, groovyClassLoaderClass, groovyClassLoaderClass), compilerConfiguration, null, groovyClassLoader, transformLoader) : ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilationUnitClass, compilerConfigurationClass, CodeSource.class, groovyClassLoaderClass), compilerConfiguration, null, groovyClassLoader);
        this.log.debug((CharSequence)"Adding Groovy to compile:");
        Method addSourceMethod = ReflectionUtils.findMethod(compilationUnitClass, "addSource", File.class);
        for (File source : sources) {
            this.log.debug((CharSequence)("    " + source));
            ReflectionUtils.invokeMethod(addSourceMethod, compilationUnit, source);
        }
        return compilationUnit;
    }

    protected Object setupCompilerConfiguration(GroovyCompileConfiguration configuration, Class<?> compilerConfigurationClass) throws InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Map optimizationOptions;
        Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
        if (configuration.getConfigScript() != null) {
            if (!configuration.getConfigScript().exists()) {
                this.log.warn((CharSequence)("Configuration script file (" + configuration.getConfigScript().getAbsolutePath() + ") doesn't exist. Ignoring configScript parameter."));
            } else if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_1_0_BETA1)) {
                this.log.warn((CharSequence)("Requested to use configScript, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_1_0_BETA1 + " or newer). Ignoring configScript parameter."));
            } else {
                Class<?> bindingClass = this.classWrangler.getClass("groovy.lang.Binding");
                Class<?> importCustomizerClass = this.classWrangler.getClass("org.codehaus.groovy.control.customizers.ImportCustomizer");
                Class<?> groovyShellClass = this.classWrangler.getClass("groovy.lang.GroovyShell");
                Object binding = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(bindingClass, new Class[0]), new Object[0]);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class), binding, "configuration", compilerConfiguration);
                Object shellCompilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
                Object importCustomizer = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(importCustomizerClass, new Class[0]), new Object[0]);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(importCustomizerClass, "addStaticStar", String.class), importCustomizer, "org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder");
                List compilationCustomizers = (List)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getCompilationCustomizers", new Class[0]), shellCompilerConfiguration, new Object[0]);
                compilationCustomizers.add(importCustomizer);
                Object shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, ClassLoader.class, bindingClass, compilerConfigurationClass), this.classWrangler.getClassLoader(), binding, shellCompilerConfiguration);
                this.log.debug((CharSequence)("Using configuration script " + configuration.getConfigScript() + " for compilation."));
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "evaluate", File.class), shell, configuration.getConfigScript());
            }
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setDebug", Boolean.TYPE), compilerConfiguration, configuration.isDebug());
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setVerbose", Boolean.TYPE), compilerConfiguration, configuration.isVerbose());
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setWarningLevel", Integer.TYPE), compilerConfiguration, configuration.getWarningLevel());
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTolerance", Integer.TYPE), compilerConfiguration, configuration.getTolerance());
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetBytecode", String.class), compilerConfiguration, GroovyCompiler.translateJavacTargetToTargetBytecode(configuration.getTargetBytecode()));
        if (configuration.isPreviewFeatures()) {
            if (this.isJavaSupportPreviewFeatures()) {
                if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_5_7) || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_2_6_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_0_BETA1)) {
                    this.log.warn((CharSequence)("Requested to use preview features, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_5_7 + "/" + GROOVY_3_0_0_BETA1 + " or newer. No 2.6 version is supported. Ignoring previewFeatures parameter."));
                } else {
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setPreviewFeatures", Boolean.TYPE), compilerConfiguration, configuration.isPreviewFeatures());
                }
            } else {
                this.log.warn((CharSequence)("Requested to use to use preview features, but your Java version (" + this.getJavaVersionString() + ") doesn't support it. Ignoring previewFeatures parameter."));
            }
        }
        if (configuration.getSourceEncoding() != null) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, configuration.getSourceEncoding());
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetDirectory", String.class), compilerConfiguration, configuration.getCompileOutputDirectory().getAbsolutePath());
        if (configuration.isInvokeDynamic() || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_4_0_0_ALPHA1)) {
            if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_2_0_0_BETA3)) {
                if (this.classWrangler.isGroovyIndy()) {
                    if (this.isJavaSupportIndy()) {
                        optimizationOptions = (Map)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getOptimizationOptions", new Class[0]), compilerConfiguration, new Object[0]);
                        optimizationOptions.put("indy", true);
                        optimizationOptions.put("int", false);
                        this.log.info((CharSequence)"invokedynamic enabled.");
                    } else {
                        this.log.warn((CharSequence)("Requested to use to use invokedynamic, but your Java version (" + this.getJavaVersionString() + ") doesn't support it. Ignoring invokeDynamic parameter."));
                    }
                } else {
                    this.log.warn((CharSequence)"Requested to use invokedynamic, but your Groovy version doesn't support it (must use have indy classifier). Ignoring invokeDynamic parameter.");
                }
            } else {
                this.log.warn((CharSequence)("Requested to use invokeDynamic, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_0_0_BETA3 + " or newer). Ignoring invokeDynamic parameter."));
            }
        }
        if (configuration.isParameters()) {
            if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_2_5_0_ALPHA1)) {
                if (this.isJavaSupportParameters()) {
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setParameters", Boolean.TYPE), compilerConfiguration, configuration.isParameters());
                } else {
                    this.log.warn((CharSequence)("Requested to use to use parameters, but your Java version (" + this.getJavaVersionString() + ") doesn't support it. Ignoring parameters parameter."));
                }
            } else {
                this.log.warn((CharSequence)("Requested to use parameters, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_5_0_ALPHA1 + " or newer). Ignoring parameters parameter."));
            }
        }
        if (ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_3_0_5)) {
            if (configuration.getParallelParsing() == null && ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_4_0_0_ALPHA1) || configuration.getParallelParsing() != null && configuration.getParallelParsing().booleanValue()) {
                optimizationOptions = (Map)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getOptimizationOptions", new Class[0]), compilerConfiguration, new Object[0]);
                optimizationOptions.put("parallelParse", true);
                this.log.info((CharSequence)"Parallel parsing enabled.");
            } else {
                this.log.info((CharSequence)"Parallel parsing disabled.");
            }
        }
        return compilerConfiguration;
    }

    protected void verifyGroovyVersionSupportsTargetBytecode(String targetBytecode) {
        if (("1.5".equals(targetBytecode) || "5".equals(targetBytecode) || "1.6".equals(targetBytecode) || "6".equals(targetBytecode) || "1.7".equals(targetBytecode) || "7".equals(targetBytecode) || "1.8".equals(targetBytecode) || "8".equals(targetBytecode) || "1.9".equals(targetBytecode) || "9".equals(targetBytecode) || "10".equals(targetBytecode)) && ClassWrangler.groovyNewerThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA1)) {
            throw new IllegalArgumentException("Target bytecode " + targetBytecode + " isn't accepted by Groovy " + GROOVY_5_0_0_ALPHA1 + " or newer.");
        }
        if ("25".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_27)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_4_0_27 + " or newer.");
            }
            if (ClassWrangler.groovyNewerThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA13)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_5_0_0_ALPHA13 + " or newer.");
            }
        } else if ("24".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_24)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_4_0_24 + " or newer.");
            }
            if (ClassWrangler.groovyNewerThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA11)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_5_0_0_ALPHA11 + " or newer.");
            }
        } else if ("23".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_21)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_4_0_21 + " or newer.");
            }
            if (ClassWrangler.groovyNewerThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA8)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_5_0_0_ALPHA8 + " or newer.");
            }
        } else if ("22".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_16)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_4_0_16 + " or newer.");
            }
            if (ClassWrangler.groovyNewerThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_5_0_0_ALPHA3)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_5_0_0_ALPHA3 + " or newer.");
            }
        } else if ("21".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_11)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_4_0_11 + " or newer.");
            }
        } else if ("20".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_6)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_4_0_6 + " or newer.");
            }
        } else if ("19".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_2)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_4_0_2 + " or newer.");
            }
        } else if ("18".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_0_BETA1)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_4_0_0_BETA1 + " or newer.");
            }
        } else if ("17".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_8) || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_4_0_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_4_0_0_ALPHA3)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_3_0_8 + "/" + GROOVY_4_0_0_ALPHA3 + " or newer.");
            }
        } else if ("16".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_6)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_3_0_6 + " or newer.");
            }
        } else if ("15".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_3)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_3_0_3 + " or newer.");
            }
        } else if ("14".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_0_BETA2)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_3_0_0_BETA2 + " or newer.");
            }
        } else if ("13".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_5_7) || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_2_6_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_0_BETA1)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_2_5_7 + "/" + GROOVY_3_0_0_BETA1 + " or newer. No 2.6 version is supported.");
            }
        } else if ("12".equals(targetBytecode) || "11".equals(targetBytecode) || "10".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_5_3) || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_2_6_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_0_ALPHA4)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_3_0_0_ALPHA4 + " or newer. No 2.6 version is supported.");
            }
        } else if ("9".equals(targetBytecode) || "1.9".equals(targetBytecode)) {
            if (!this.classWrangler.isGroovyIndy() && (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_5_3) || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_2_6_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_6_0_ALPHA4) || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_3_0_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_0_ALPHA2))) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_2_6_0_ALPHA4 + "/" + GROOVY_3_0_0_ALPHA2 + " or newer.");
            }
            if (this.classWrangler.isGroovyIndy() && (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_5_3) || ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), GROOVY_2_6_0_ALPHA1) && ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_3_0_0_ALPHA4))) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_3_0_0_ALPHA4 + " or newer. No 2.6 version is supported.");
            }
        } else if ("8".equals(targetBytecode) || "1.8".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_3_3)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_2_3_3 + " or newer.");
            }
        } else if ("7".equals(targetBytecode) || "1.7".equals(targetBytecode) || "6".equals(targetBytecode) || "1.6".equals(targetBytecode)) {
            if (ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), GROOVY_2_1_3)) {
                throw new IllegalArgumentException("Target bytecode " + targetBytecode + " requires Groovy " + GROOVY_2_1_3 + " or newer.");
            }
        } else if (!("5".equals(targetBytecode) || "1.5".equals(targetBytecode) || "4".equals(targetBytecode) || "1.4".equals(targetBytecode))) {
            throw new IllegalArgumentException("Unrecognized target bytecode: '" + targetBytecode + "'. This check can be skipped with 'skipBytecodeCheck', but this may result in a different target bytecode being used.");
        }
    }

    public static String translateJavacTargetToTargetBytecode(String targetBytecode) {
        HashMap<String, String> javacTargetToTargetBytecode = new HashMap<String, String>();
        javacTargetToTargetBytecode.put("5", "1.5");
        javacTargetToTargetBytecode.put("6", "1.6");
        javacTargetToTargetBytecode.put("7", "1.7");
        javacTargetToTargetBytecode.put("8", "1.8");
        javacTargetToTargetBytecode.put("1.9", "9");
        return javacTargetToTargetBytecode.getOrDefault(targetBytecode, targetBytecode);
    }

    protected boolean isJavaSupportIndy() {
        return this.getJavaVersion().compareTo(JAVA_1_7, false) >= 0;
    }

    protected boolean isJavaSupportPreviewFeatures() {
        return this.getJavaVersion().compareTo(JAVA_12, false) >= 0;
    }

    protected boolean isJavaSupportParameters() {
        return this.getJavaVersion().compareTo(JAVA_1_8, false) >= 0;
    }

    protected Version getJavaVersion() {
        return Version.parseFromString(this.getJavaVersionString());
    }

    protected String getJavaVersionString() {
        return System.getProperty("java.version");
    }
}

