/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting.model.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.mojo.versions.reporting.model.PropertyAssociation;
import org.codehaus.mojo.versions.reporting.model.PropertyInfo;
import org.codehaus.mojo.versions.reporting.model.PropertyReportSummary;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesReport;
import org.codehaus.mojo.versions.reporting.model.io.stax.IndentingXMLStreamWriter;

public class PropertyUpdatesReportStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, PropertyUpdatesReport propertyUpdatesReport) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(propertyUpdatesReport.getModelEncoding(), "1.0");
        this.writePropertyUpdatesReport(propertyUpdatesReport, "PropertyUpdatesReport", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, PropertyUpdatesReport propertyUpdatesReport) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, propertyUpdatesReport.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(propertyUpdatesReport.getModelEncoding(), "1.0");
        this.writePropertyUpdatesReport(propertyUpdatesReport, "PropertyUpdatesReport", serializer);
        serializer.writeEndDocument();
    }

    private void writePropertyAssociation(PropertyAssociation propertyAssociation, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (propertyAssociation != null) {
            serializer.writeStartElement(tagName);
            if (propertyAssociation.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(propertyAssociation.getGroupId());
                serializer.writeEndElement();
            }
            if (propertyAssociation.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(propertyAssociation.getArtifactId());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePropertyInfo(PropertyInfo propertyInfo, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (propertyInfo != null) {
            serializer.writeStartElement(tagName);
            if (propertyInfo.getPropertyName() != null) {
                serializer.writeStartElement("propertyName");
                serializer.writeCharacters(propertyInfo.getPropertyName());
                serializer.writeEndElement();
            }
            if (propertyInfo.getPropertyAssociations() != null && propertyInfo.getPropertyAssociations().size() > 0) {
                serializer.writeStartElement("propertyAssociations");
                for (PropertyAssociation o : propertyInfo.getPropertyAssociations()) {
                    this.writePropertyAssociation(o, "propertyAssociation", serializer);
                }
                serializer.writeEndElement();
            }
            if (propertyInfo.getCurrentVersion() != null) {
                serializer.writeStartElement("currentVersion");
                serializer.writeCharacters(propertyInfo.getCurrentVersion());
                serializer.writeEndElement();
            }
            if (propertyInfo.getLastVersion() != null) {
                serializer.writeStartElement("lastVersion");
                serializer.writeCharacters(propertyInfo.getLastVersion());
                serializer.writeEndElement();
            }
            if (propertyInfo.getAny() != null && propertyInfo.getAny().size() > 0) {
                serializer.writeStartElement("any");
                for (String any : propertyInfo.getAny()) {
                    serializer.writeStartElement("any");
                    serializer.writeCharacters(any);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (propertyInfo.getIncrementals() != null && propertyInfo.getIncrementals().size() > 0) {
                serializer.writeStartElement("incrementals");
                for (String incremental : propertyInfo.getIncrementals()) {
                    serializer.writeStartElement("incremental");
                    serializer.writeCharacters(incremental);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (propertyInfo.getMinors() != null && propertyInfo.getMinors().size() > 0) {
                serializer.writeStartElement("minors");
                for (String minor : propertyInfo.getMinors()) {
                    serializer.writeStartElement("minor");
                    serializer.writeCharacters(minor);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (propertyInfo.getMajors() != null && propertyInfo.getMajors().size() > 0) {
                serializer.writeStartElement("majors");
                for (String major : propertyInfo.getMajors()) {
                    serializer.writeStartElement("major");
                    serializer.writeCharacters(major);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (propertyInfo.getStatus() != null) {
                serializer.writeStartElement("status");
                serializer.writeCharacters(propertyInfo.getStatus());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePropertyReportSummary(PropertyReportSummary propertyReportSummary, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (propertyReportSummary != null) {
            serializer.writeStartElement(tagName);
            if (propertyReportSummary.getUsingLastVersion() != null) {
                serializer.writeStartElement("usingLastVersion");
                serializer.writeCharacters(propertyReportSummary.getUsingLastVersion());
                serializer.writeEndElement();
            }
            if (propertyReportSummary.getNextVersionAvailable() != null) {
                serializer.writeStartElement("nextVersionAvailable");
                serializer.writeCharacters(propertyReportSummary.getNextVersionAvailable());
                serializer.writeEndElement();
            }
            if (propertyReportSummary.getNextIncrementalAvailable() != null) {
                serializer.writeStartElement("nextIncrementalAvailable");
                serializer.writeCharacters(propertyReportSummary.getNextIncrementalAvailable());
                serializer.writeEndElement();
            }
            if (propertyReportSummary.getNextMinorAvailable() != null) {
                serializer.writeStartElement("nextMinorAvailable");
                serializer.writeCharacters(propertyReportSummary.getNextMinorAvailable());
                serializer.writeEndElement();
            }
            if (propertyReportSummary.getNextMajorAvailable() != null) {
                serializer.writeStartElement("nextMajorAvailable");
                serializer.writeCharacters(propertyReportSummary.getNextMajorAvailable());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePropertyUpdatesReport(PropertyUpdatesReport propertyUpdatesReport, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (propertyUpdatesReport != null) {
            serializer.setDefaultNamespace("https://www.mojohaus.org/VERSIONS/PROPERTY-UPDATES-REPORT/2.0.0");
            serializer.writeStartElement(tagName);
            serializer.writeDefaultNamespace("https://www.mojohaus.org/VERSIONS/PROPERTY-UPDATES-REPORT/2.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "https://www.mojohaus.org/VERSIONS/PROPERTY-UPDATES-REPORT/2.0.0 https://www.mojohaus.org/versions/versions-model-report/xsd/property-updates-report-2.0.0.xsd");
            if (propertyUpdatesReport.getSummary() != null) {
                this.writePropertyReportSummary(propertyUpdatesReport.getSummary(), "summary", serializer);
            }
            if (propertyUpdatesReport.getProperties() != null && propertyUpdatesReport.getProperties().size() > 0) {
                serializer.writeStartElement("properties");
                for (PropertyInfo o : propertyUpdatesReport.getProperties()) {
                    this.writePropertyInfo(o, "property", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

