/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.SecretKey;
import org.cryptacular.CiphertextHeader;
import org.cryptacular.bean.CipherBean;
import org.cryptacular.generator.Nonce;

public abstract class AbstractCipherBean
implements CipherBean {
    private KeyStore keyStore;
    private String keyAlias;
    private String keyPassword;
    private Nonce nonce;

    public AbstractCipherBean() {
    }

    public AbstractCipherBean(KeyStore keyStore, String keyAlias, String keyPassword, Nonce nonce) {
        this.setKeyStore(keyStore);
        this.setKeyAlias(keyAlias);
        this.setKeyPassword(keyPassword);
        this.setNonce(nonce);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public void setNonce(Nonce nonce) {
        this.nonce = nonce;
    }

    @Override
    public byte[] encrypt(byte[] input) {
        return this.process(new CiphertextHeader(this.nonce.generate(), this.keyAlias), true, input);
    }

    @Override
    public void encrypt(InputStream input, OutputStream output) {
        CiphertextHeader header = new CiphertextHeader(this.nonce.generate(), this.keyAlias);
        try {
            output.write(header.encode());
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing ciphertext header to output stream", e);
        }
        this.process(header, true, input, output);
    }

    @Override
    public byte[] decrypt(byte[] input) {
        CiphertextHeader header = CiphertextHeader.decode(input);
        return this.process(header, false, input);
    }

    @Override
    public void decrypt(InputStream input, OutputStream output) {
        CiphertextHeader header = CiphertextHeader.decode(input);
        this.process(header, false, input, output);
    }

    protected SecretKey lookupKey(String alias) {
        Key key;
        try {
            key = this.keyStore.getKey(alias, this.keyPassword.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing " + alias, e);
        }
        if (key instanceof SecretKey) {
            return (SecretKey)key;
        }
        throw new IllegalArgumentException(alias + " is not a secret key");
    }

    protected abstract byte[] process(CiphertextHeader var1, boolean var2, byte[] var3);

    protected abstract void process(CiphertextHeader var1, boolean var2, InputStream var3, OutputStream var4);
}

