/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import org.bouncycastle.crypto.Digest;
import org.cryptacular.bean.AbstractHashBean;
import org.cryptacular.bean.HashBean;
import org.cryptacular.codec.Codec;
import org.cryptacular.spec.Spec;
import org.cryptacular.util.CodecUtil;

public class EncodingHashBean
extends AbstractHashBean
implements HashBean<String> {
    private Spec<Codec> codecSpec;

    public EncodingHashBean() {
    }

    public EncodingHashBean(Spec<Codec> codecSpec, Spec<Digest> digestSpec, int iterations) {
        super(digestSpec, iterations);
        this.setCodecSpec(codecSpec);
    }

    public Spec<Codec> getCodecSpec() {
        return this.codecSpec;
    }

    public void setCodecSpec(Spec<Codec> codecSpec) {
        this.codecSpec = codecSpec;
    }

    @Override
    public String hash(Object ... data) {
        return CodecUtil.encode(this.codecSpec.newInstance().getEncoder(), this.hashInternal(data));
    }

    @Override
    public boolean compare(String hash, Object ... data) {
        return this.compareInternal(CodecUtil.decode(this.codecSpec.newInstance().getDecoder(), hash), data);
    }
}

